/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.springframework.util.CollectionUtils;

public class AgendaBoServiceImpl
implements AgendaBoService {
    private static final ModelObjectUtils.Transformer<AgendaItemBo, AgendaItemDefinition> toAgendaItemDefinition = new ModelObjectUtils.Transformer<AgendaItemBo, AgendaItemDefinition>(){

        public AgendaItemDefinition transform(AgendaItemBo input) {
            return AgendaItemBo.to(input);
        }
    };
    private static final ModelObjectUtils.Transformer<AgendaBo, AgendaDefinition> toAgendaDefinition = new ModelObjectUtils.Transformer<AgendaBo, AgendaDefinition>(){

        public AgendaDefinition transform(AgendaBo input) {
            return AgendaBo.to(input);
        }
    };
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    @Override
    public AgendaDefinition createAgenda(AgendaDefinition agenda) {
        String contextId;
        if (agenda == null) {
            throw new RiceIllegalArgumentException("agenda is null");
        }
        String nameKey = agenda.getName();
        AgendaDefinition existing = this.getAgendaByNameAndContextId(nameKey, contextId = agenda.getContextId());
        if (existing != null) {
            throw new IllegalStateException("the agenda to create already exists: " + String.valueOf(agenda));
        }
        AgendaBo agendaBo = this.from(agenda);
        agendaBo = (AgendaBo)this.getDataObjectService().save((Object)agendaBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return this.to(agendaBo);
    }

    @Override
    public AgendaDefinition updateAgenda(AgendaDefinition agendaDefinition) {
        AgendaDefinition agendaDefinitionToUpdate;
        if (agendaDefinition == null) {
            throw new RiceIllegalArgumentException("agenda is null");
        }
        String agendaDefinitionId = agendaDefinition.getId();
        AgendaBo agendaBoExisting = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)agendaDefinitionId);
        if (agendaBoExisting == null) {
            throw new IllegalStateException("the agenda does not exist: " + String.valueOf(agendaDefinition));
        }
        if (agendaBoExisting.getId().equals(agendaDefinition.getId())) {
            agendaDefinitionToUpdate = agendaDefinition;
        } else {
            AgendaDefinition.Builder builder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
            builder.setId(agendaBoExisting.getId());
            agendaDefinitionToUpdate = builder.build();
        }
        AgendaBo agendaBoToUpdate = this.from(agendaDefinitionToUpdate);
        agendaBoToUpdate.setItems(agendaBoExisting.getItems());
        if (StringUtils.isNotBlank((String)agendaDefinition.getFirstItemId())) {
            agendaBoToUpdate.setFirstItem((AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)agendaDefinition.getFirstItemId()));
        }
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("agenda.id", agendaDefinitionToUpdate.getId());
        BusinessObjectServiceMigrationUtils.deleteMatching(this.getDataObjectService(), AgendaAttributeBo.class, fields);
        ArrayList<String> agendaItemsIds = new ArrayList<String>();
        HashMap<String, AgendaItemBo> mapIdToBo = new HashMap<String, AgendaItemBo>();
        ArrayList<String> agendaItemIdsReferenced = new ArrayList<String>();
        List<AgendaItemBo> items = agendaBoToUpdate.getItems();
        for (AgendaItemBo agendaItemBo : items) {
            agendaItemsIds.add(agendaItemBo.getId());
            mapIdToBo.put(agendaItemBo.getId(), agendaItemBo);
            if (agendaItemBo.getAlwaysId() != null) {
                agendaItemIdsReferenced.add(agendaItemBo.getAlwaysId());
            }
            if (agendaItemBo.getWhenTrueId() != null) {
                agendaItemIdsReferenced.add(agendaItemBo.getWhenTrueId());
            }
            if (agendaItemBo.getWhenFalseId() == null) continue;
            agendaItemIdsReferenced.add(agendaItemBo.getWhenFalseId());
        }
        AgendaBo agendaBoUpdated = (AgendaBo)this.getDataObjectService().save((Object)agendaBoToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        ArrayList<String> agendaItemIdsActuallyUsed = new ArrayList<String>();
        if (agendaBoUpdated.getFirstItem() != null) {
            AgendaItemBo agendaItemBoTop;
            AgendaItemBo agendaItemBoCurrent;
            agendaItemIdsActuallyUsed.add(agendaItemBoCurrent.getId());
            for (agendaItemBoCurrent = agendaItemBoTop = agendaBoUpdated.getFirstItem(); agendaItemBoCurrent != null; agendaItemBoCurrent = agendaItemBoCurrent.getAlways()) {
                if (!StringUtils.isNotEmpty((String)agendaItemBoCurrent.getAlwaysId())) continue;
                agendaItemIdsActuallyUsed.add(agendaItemBoCurrent.getAlwaysId());
            }
            for (agendaItemBoCurrent = agendaItemBoTop; agendaItemBoCurrent != null; agendaItemBoCurrent = agendaItemBoCurrent.getWhenTrue()) {
                if (!StringUtils.isNotEmpty((String)agendaItemBoCurrent.getWhenTrueId())) continue;
                agendaItemIdsActuallyUsed.add(agendaItemBoCurrent.getWhenTrueId());
            }
            for (agendaItemBoCurrent = agendaItemBoTop; agendaItemBoCurrent != null; agendaItemBoCurrent = agendaItemBoCurrent.getWhenFalse()) {
                if (!StringUtils.isNotEmpty((String)agendaItemBoCurrent.getWhenFalseId())) continue;
                agendaItemIdsActuallyUsed.add(agendaItemBoCurrent.getWhenFalseId());
            }
        }
        for (String sIdActuallyUsed : agendaItemIdsActuallyUsed) {
            if (!agendaItemsIds.contains(sIdActuallyUsed)) continue;
            agendaItemsIds.remove(sIdActuallyUsed);
        }
        for (String sAiboId : agendaItemsIds) {
            boolean bReferenced = agendaItemIdsReferenced.contains(sAiboId);
            if (bReferenced) continue;
            AgendaItemBo aibo = (AgendaItemBo)mapIdToBo.get(sAiboId);
            this.getDataObjectService().delete((Object)aibo);
        }
        return this.to(agendaBoUpdated);
    }

    @Override
    public void deleteAgenda(String agendaId) {
        if (agendaId == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        AgendaBo bo = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)agendaId);
        if (bo == null) {
            throw new IllegalStateException("the Agenda to delete does not exist: " + agendaId);
        }
        AgendaItemBo firstAgendaItem = bo.getFirstItem();
        if (firstAgendaItem != null) {
            this.getDataObjectService().delete((Object)firstAgendaItem);
            this.getDataObjectService().flush(AgendaItemBo.class);
            bo.setFirstItem(null);
            bo.setItems(null);
        }
        this.getDataObjectService().delete((Object)bo);
    }

    @Override
    public AgendaDefinition getAgendaByAgendaId(String agendaId) {
        if (StringUtils.isBlank((String)agendaId)) {
            throw new RiceIllegalArgumentException("agenda id is null or blank");
        }
        AgendaBo bo = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)agendaId);
        return this.to(bo);
    }

    @Override
    public AgendaDefinition getAgendaByNameAndContextId(String name, String contextId) {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("contextId", contextId);
        AgendaBo myAgenda = BusinessObjectServiceMigrationUtils.findSingleMatching(this.getDataObjectService(), AgendaBo.class, map);
        return this.to(myAgenda);
    }

    @Override
    public List<AgendaDefinition> getAgendasByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("context ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextId);
        List<AgendaBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public AgendaItemDefinition createAgendaItem(AgendaItemDefinition agendaItem) {
        AgendaDefinition existing;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        if (agendaItem.getId() != null && (existing = this.getAgendaByAgendaId(agendaItem.getId())) != null) {
            throw new IllegalStateException("the agendaItem to create already exists: " + String.valueOf(agendaItem));
        }
        AgendaItemBo bo = AgendaItemBo.from(agendaItem);
        if (StringUtils.isNotBlank((String)agendaItem.getRuleId()) && agendaItem.getRule() == null) {
            bo.setRule((RuleBo)this.getDataObjectService().find(RuleBo.class, (Object)agendaItem.getRuleId()));
        }
        if (StringUtils.isNotBlank((String)agendaItem.getAlwaysId()) && agendaItem.getAlways() == null) {
            bo.setAlways((AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)agendaItem.getAlwaysId()));
        }
        if (StringUtils.isNotBlank((String)agendaItem.getWhenTrueId()) && agendaItem.getWhenTrue() == null) {
            bo.setWhenTrue((AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)agendaItem.getWhenTrueId()));
        }
        if (StringUtils.isNotBlank((String)agendaItem.getWhenFalseId()) && agendaItem.getWhenFalse() == null) {
            bo.setWhenFalse((AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)agendaItem.getWhenFalseId()));
        }
        bo = (AgendaItemBo)this.getDataObjectService().save((Object)bo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return AgendaItemBo.to(bo);
    }

    @Override
    public AgendaItemDefinition updateAgendaItem(AgendaItemDefinition agendaItem) {
        AgendaItemDefinition toUpdate;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        String agendaItemIdKey = agendaItem.getId();
        AgendaItemDefinition existing = this.getAgendaItemById(agendaItemIdKey);
        if (existing == null) {
            throw new IllegalStateException("the agenda item does not exist: " + String.valueOf(agendaItem));
        }
        if (existing.getId().equals(agendaItem.getId())) {
            toUpdate = agendaItem;
        } else {
            AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        }
        AgendaItemBo aiBo = AgendaItemBo.from(toUpdate);
        AgendaItemBo updatedData = (AgendaItemBo)this.getDataObjectService().save((Object)aiBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return AgendaItemBo.to(updatedData);
    }

    @Override
    public void addAgendaItem(AgendaItemDefinition agendaItem, String parentId, Boolean position) {
        AgendaItemDefinition toCreate;
        AgendaItemDefinition.Builder builder;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        AgendaItemDefinition parent = null;
        if (parentId != null && (parent = this.getAgendaItemById(parentId)) == null) {
            throw new IllegalStateException("parent agendaItem does not exist in repository. parentId = " + parentId);
        }
        if (agendaItem.getId() == null) {
            builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
            builder.setId(AgendaItemBo.agendaItemIdIncrementer.getNewId());
            toCreate = builder.build();
        } else {
            toCreate = agendaItem;
        }
        this.createAgendaItem(toCreate);
        if (parentId != null) {
            builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)parent);
            if (position == null) {
                builder.setAlwaysId(toCreate.getId());
            } else if (position.booleanValue()) {
                builder.setWhenTrueId(toCreate.getId());
            } else if (!position.booleanValue()) {
                builder.setWhenFalseId(toCreate.getId());
            }
            AgendaItemDefinition parentToUpdate = builder.build();
            this.updateAgendaItem(parentToUpdate);
        }
    }

    @Override
    public AgendaItemDefinition getAgendaItemById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("agenda item id is null or blank");
        }
        AgendaItemBo bo = (AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)id);
        return AgendaItemBo.to(bo);
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByAgendaId(String agendaId) {
        if (StringUtils.isBlank((String)agendaId)) {
            throw new RiceIllegalArgumentException("agenda id is null or null");
        }
        List<Object> results = null;
        List<AgendaItemBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), AgendaItemBo.class, Collections.singletonMap("agendaId", agendaId));
        results = CollectionUtils.isEmpty(bos) ? Collections.emptyList() : Collections.unmodifiableList(ModelObjectUtils.transform(bos, toAgendaItemDefinition));
        return results;
    }

    @Override
    public List<AgendaDefinition> getAgendasByType(String typeId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)typeId)) {
            throw new RiceIllegalArgumentException("type ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        List<AgendaBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public List<AgendaDefinition> getAgendasByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)typeId)) {
            throw new RiceIllegalArgumentException("type ID is null or blank");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("context ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        map.put("contextId", contextId);
        List<AgendaBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByType(String typeId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByType(typeId));
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByContext(String contextId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByContextId(contextId));
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByTypeAndContext(typeId, contextId));
    }

    @Override
    public void deleteAgendaItem(String agendaItemId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)agendaItemId)) {
            throw new RiceIllegalArgumentException("agendaItemId must not be blank or null");
        }
        BusinessObjectServiceMigrationUtils.deleteMatching(this.getDataObjectService(), AgendaItemBo.class, Collections.singletonMap("id", agendaItemId));
    }

    private List<AgendaItemDefinition> findAgendaItemsForAgendas(List<AgendaDefinition> agendaDefinitions) {
        List<Object> results = null;
        if (!CollectionUtils.isEmpty(agendaDefinitions)) {
            ArrayList boResults = new ArrayList(agendaDefinitions.size());
            ArrayList<String> agendaIds = new ArrayList<String>(20);
            for (AgendaDefinition agendaDefinition : agendaDefinitions) {
                agendaIds.add(agendaDefinition.getId());
                if (agendaIds.size() != 20) continue;
                Predicate predicate = PredicateFactory.in((String)"agendaId", (Object[])agendaIds.toArray());
                QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{predicate});
                QueryResults batch = this.getDataObjectService().findMatching(AgendaItemBo.class, criteria);
                boResults.addAll(batch.getResults());
                agendaIds.clear();
            }
            if (agendaIds.size() > 0) {
                Predicate predicate = PredicateFactory.in((String)"agendaId", (Object[])agendaIds.toArray());
                QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{predicate});
                QueryResults batch = this.getDataObjectService().findMatching(AgendaItemBo.class, criteria);
                boResults.addAll(batch.getResults());
            }
            results = Collections.unmodifiableList(ModelObjectUtils.transform(boResults, toAgendaItemDefinition));
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public List<AgendaDefinition> convertAgendaBosToImmutables(Collection<AgendaBo> agendaBos) {
        if (CollectionUtils.isEmpty(agendaBos)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ModelObjectUtils.transform(agendaBos, toAgendaDefinition));
    }

    @Override
    public AgendaDefinition to(AgendaBo bo) {
        if (bo == null) {
            return null;
        }
        return AgendaDefinition.Builder.create((AgendaDefinitionContract)bo).build();
    }

    @Override
    public AgendaBo from(AgendaDefinition im) {
        if (im == null) {
            return null;
        }
        AgendaBo bo = new AgendaBo();
        bo.setId(im.getId());
        bo.setName(im.getName());
        bo.setTypeId(im.getTypeId());
        bo.setContextId(im.getContextId());
        bo.setFirstItemId(im.getFirstItemId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setActive(im.isActive());
        Set<AgendaAttributeBo> attributes = this.buildAgendaAttributeBo(im, bo);
        bo.setAttributeBos(attributes);
        return bo;
    }

    private Set<AgendaAttributeBo> buildAgendaAttributeBo(AgendaDefinition im, AgendaBo agendaBo) {
        HashSet<AgendaAttributeBo> attributes = new HashSet<AgendaAttributeBo>();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        for (Map.Entry entry : im.getAttributes().entrySet()) {
            KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
            if (attrDef != null) {
                AgendaAttributeBo attributeBo = new AgendaAttributeBo();
                attributeBo.setAgenda(agendaBo);
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                attributes.add(attributeBo);
                continue;
            }
            throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the agenda type with id = '" + im.getTypeId() + "'");
        }
        return attributes;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }
}

