/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.core.api.util.tree.Tree;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.ui.AgendaTreeLogicNode;
import org.kuali.rice.krms.impl.ui.AgendaTreeNode;
import org.kuali.rice.krms.impl.ui.AgendaTreeRuleNode;

public class AgendaEditor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContextBo context;
    private String namespace;
    private AgendaBo agenda;
    private String contextName;
    private AgendaItemBo agendaItemLine;
    private ActionBo agendaItemLineRuleAction;
    private String selectedAgendaItemId;
    private String cutAgendaItemId;
    private String selectedPropositionId;
    private String cutPropositionId;
    private List<String> deletedPropositionIdsFromRule = new ArrayList<String>();
    private List<String> deletedPropositionIds = new ArrayList<String>();
    private String copyRuleName;
    private String oldContextId;
    private String ruleEditorMessage;
    private boolean addRuleInProgress = false;
    private boolean disableButtons = false;
    private Map<String, String> customAttributesMap = new HashMap<String, String>();
    private Map<String, String> customRuleAttributesMap = new HashMap<String, String>();
    private Map<String, String> customRuleActionAttributesMap = new HashMap<String, String>();
    @Transient
    private transient KrmsTypeRepositoryService krmsTypeRepositoryService = null;
    @Transient
    private transient Tree<? extends AgendaTreeNode, String> agendaTree = null;

    public AgendaEditor() {
        this.agenda = new AgendaBo();
        this.agenda.setTypeId("");
        this.agendaItemLine = new AgendaItemBo();
        this.agendaItemLineRuleAction = new ActionBo();
    }

    private void addAgendaItemAndChildren(Node<AgendaTreeNode, String> parent, AgendaItemBo agendaItem, Collection<KrmsTypeDefinition> typeDefs) {
        Node child = new Node();
        child.setNodeLabel((Object)agendaItem.getRuleText());
        child.setNodeType("agendaNode ruleNode");
        child.setData((Object)new AgendaTreeRuleNode(agendaItem));
        parent.getChildren().add(child);
        if (agendaItem.getAlways() != null) {
            this.addAgendaItemAndChildren(parent, agendaItem.getAlways(), typeDefs);
        }
        if (agendaItem.getWhenTrue() != null) {
            Node whenTrue = new Node();
            whenTrue.setNodeLabel((Object)"When TRUE");
            whenTrue.setNodeType("agendaNode logicNode whenTrueNode");
            whenTrue.setData((Object)new AgendaTreeLogicNode());
            child.getChildren().add(whenTrue);
            this.addAgendaItemAndChildren((Node<AgendaTreeNode, String>)whenTrue, agendaItem.getWhenTrue(), typeDefs);
        }
        if (agendaItem.getWhenFalse() != null) {
            Node whenFalse = new Node();
            whenFalse.setNodeLabel((Object)"When FALSE");
            whenFalse.setNodeType("agendaNode logicNode whenFalseNode");
            whenFalse.setData((Object)new AgendaTreeLogicNode());
            child.getChildren().add(whenFalse);
            this.addAgendaItemAndChildren((Node<AgendaTreeNode, String>)whenFalse, agendaItem.getWhenFalse(), typeDefs);
        }
    }

    public Tree<? extends AgendaTreeNode, String> getAgendaRuleTree() {
        if (this.agendaTree == null) {
            this.refreshAgendaRuleTree();
        }
        return this.agendaTree;
    }

    public void refreshAgendaRuleTree() {
        Tree agendaTree = new Tree();
        List typeDefs = this.getKrmsTypeRepositoryService().findAllTypes();
        Node rootNode = new Node();
        agendaTree.setRootElement(rootNode);
        if (this.agenda != null) {
            String firstItemId = this.agenda.getFirstItemId();
            List<AgendaItemBo> items = this.agenda.getItems();
            AgendaItemBo firstItem = null;
            if (items != null && firstItemId != null) {
                for (AgendaItemBo item : items) {
                    if (!firstItemId.equals(item.getId())) continue;
                    firstItem = item;
                    break;
                }
            }
            if (firstItem != null) {
                this.addAgendaItemAndChildren((Node<AgendaTreeNode, String>)rootNode, firstItem, typeDefs);
            }
        }
        this.agendaTree = agendaTree;
    }

    public AgendaItemBo getAgendaItemLine() {
        return this.agendaItemLine;
    }

    public void setAgendaItemLine(AgendaItemBo agendaItemLine) {
        this.agendaItemLine = agendaItemLine;
    }

    public ActionBo getAgendaItemLineRuleAction() {
        return this.agendaItemLineRuleAction;
    }

    public void setAgendaItemLineRuleAction(ActionBo actionBo) {
        this.agendaItemLineRuleAction = actionBo;
    }

    public String getSelectedAgendaItemId() {
        return this.selectedAgendaItemId;
    }

    public void setSelectedAgendaItemId(String selectedAgendaItemId) {
        this.selectedAgendaItemId = selectedAgendaItemId;
    }

    public String getCutAgendaItemId() {
        return this.cutAgendaItemId;
    }

    public void setCutAgendaItemId(String cutAgendaItemId) {
        this.cutAgendaItemId = cutAgendaItemId;
    }

    public ContextBo getContext() {
        return this.context;
    }

    public void setContext(ContextBo context) {
        this.context = context;
    }

    public AgendaBo getAgenda() {
        return this.agenda;
    }

    public void setAgenda(AgendaBo agenda) {
        this.agenda = agenda;
    }

    public Map<String, String> getCustomAttributesMap() {
        return this.customAttributesMap;
    }

    public void setCustomAttributesMap(Map<String, String> customAttributesMap) {
        this.customAttributesMap = customAttributesMap;
    }

    public Map<String, String> getCustomRuleAttributesMap() {
        return this.customRuleAttributesMap;
    }

    public void setCustomRuleAttributesMap(Map<String, String> customRuleAttributesMap) {
        this.customRuleAttributesMap = customRuleAttributesMap;
    }

    public Map<String, String> getCustomRuleActionAttributesMap() {
        return this.customRuleActionAttributesMap;
    }

    public void setCustomRuleActionAttributesMap(Map<String, String> customRuleActionAttributesMap) {
        this.customRuleActionAttributesMap = customRuleActionAttributesMap;
    }

    public void setCopyRuleName(String copyRuleName) {
        this.copyRuleName = copyRuleName;
    }

    public String getCopyRuleName() {
        return this.copyRuleName;
    }

    public void setOldContextId(String oldContextId) {
        this.oldContextId = oldContextId;
    }

    public String getOldContextId() {
        return this.oldContextId;
    }

    public String getSelectedPropositionId() {
        return this.selectedPropositionId;
    }

    public void setSelectedPropositionId(String selectedPropositionId) {
        this.selectedPropositionId = selectedPropositionId;
    }

    public String getCutPropositionId() {
        return this.cutPropositionId;
    }

    public List<String> getDeletedPropositionIdsFromRule() {
        return this.deletedPropositionIdsFromRule;
    }

    public void setDeletedPropositionIdsFromRule(List<String> deletedPropositionIdsFromRule) {
        this.deletedPropositionIdsFromRule = deletedPropositionIdsFromRule;
    }

    public List<String> getDeletedPropositionIds() {
        return this.deletedPropositionIds;
    }

    public void setDeletedPropositionIds(List<String> deletedPropositionIds) {
        this.deletedPropositionIds = deletedPropositionIds;
    }

    public void addDeletedPropositionIdFromRule(String propId) {
        this.getDeletedPropositionIdsFromRule().add(propId);
    }

    public void clearDeletedPropositionIdsFromRule() {
        this.getDeletedPropositionIdsFromRule().clear();
    }

    public void applyDeletedPropositionIdsFromRule() {
        this.getDeletedPropositionIds().addAll(this.getDeletedPropositionIdsFromRule());
        this.clearDeletedPropositionIdsFromRule();
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRuleEditorMessage() {
        return this.ruleEditorMessage;
    }

    public void setRuleEditorMessage(String message) {
        this.ruleEditorMessage = message;
    }

    public boolean isAddRuleInProgress() {
        return this.addRuleInProgress;
    }

    public void setAddRuleInProgress(boolean addRuleInProgress) {
        this.addRuleInProgress = addRuleInProgress;
    }

    public boolean isDisableButtons() {
        return this.disableButtons;
    }

    public void setDisableButtons(boolean disableButtons) {
        this.disableButtons = disableButtons;
    }

    public void setCutPropositionId(String cutPropositionId) {
        this.cutPropositionId = cutPropositionId;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        if (this.krmsTypeRepositoryService == null) {
            this.krmsTypeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        }
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService dataObjectService) {
        this.krmsTypeRepositoryService = dataObjectService;
    }
}

