/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.rule;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermBoService;

public class TermBusRule
extends MaintenanceDocumentRuleBase {
    private DataObjectService dataObjectService;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        TermBo term = (TermBo)document.getNewMaintainableObject().getDataObject();
        isValid &= this.validateId(term);
        isValid &= this.validateDescriptionNamespace(term);
        return isValid &= this.validateTermSpecId(term);
    }

    private boolean validateTermSpecId(TermBo term) {
        if (StringUtils.isBlank((String)term.getSpecificationId())) {
            this.putFieldError("dataObject.specificationId", "error.term.invalidTermSpecification");
            return false;
        }
        TermSpecificationDefinition termSpec = KrmsRepositoryServiceLocator.getTermBoService().getTermSpecificationById(term.getSpecificationId());
        if (termSpec == null) {
            this.putFieldError("dataObject.specificationId", "error.term.invalidTermSpecification");
            return false;
        }
        return true;
    }

    private boolean validateId(TermBo term) {
        TermDefinition termInDatabase;
        if (StringUtils.isNotBlank((String)term.getId()) && (termInDatabase = this.getTermBoService().getTerm(term.getId())) != null && !StringUtils.equals((String)termInDatabase.getId(), (String)term.getId())) {
            this.putFieldError("dataObject.id", "error.term.duplicateId");
            return false;
        }
        return true;
    }

    private boolean validateDescriptionNamespace(TermBo term) {
        if (term.getSpecification() != null && StringUtils.isNotBlank((String)term.getDescription()) && StringUtils.isNotBlank((String)term.getSpecification().getNamespace())) {
            HashMap<String, String> critMap = new HashMap<String, String>();
            critMap.put("description", term.getDescription());
            critMap.put("specification.namespace", term.getSpecification().getNamespace());
            QueryByCriteria criteria = QueryByCriteria.Builder.andAttributes(critMap).build();
            QueryResults queryResults = this.getDataObjectService().findMatching(TermBo.class, criteria);
            TermBo termInDatabase = null;
            if (!CollectionUtils.isEmpty((Collection)queryResults.getResults()) && queryResults.getResults().size() == 1) {
                termInDatabase = (TermBo)queryResults.getResults().get(0);
            }
            if (termInDatabase != null && !StringUtils.equals((String)termInDatabase.getId(), (String)term.getId())) {
                this.putFieldError("dataObject.description", "error.term.duplicateNameNamespace");
                return false;
            }
        }
        return true;
    }

    public TermBoService getTermBoService() {
        return KrmsRepositoryServiceLocator.getTermBoService();
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            return KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setBoService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

