/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.provider.repository;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.framework.engine.AgendaTree;

/**
 * TODO... 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class LazyAgendaTree implements AgendaTree {

	private final Object mutex = new Object();
	private final AgendaDefinition agendaDefinition;
	private final RepositoryToEngineTranslator translator;
	
	private AgendaTree agendaTree;
	
	public LazyAgendaTree(AgendaDefinition agendaDefinition, RepositoryToEngineTranslator translator) {
		this.agendaDefinition = agendaDefinition;
		this.translator = translator;
	}

	@Override
    public void execute(ExecutionEnvironment environment) {
		initialize();
		agendaTree.execute(environment);
	}
	
	public void initialize() {
		// could use double-checked locking here for max efficiency
		synchronized (mutex) {
			if (agendaTree == null) {
				agendaTree = translator.translateAgendaDefinitionToAgendaTree(agendaDefinition);
			}
		}
	}

}
