/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.registry;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.QNameAsStringAdapter;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.api.registry.ServiceInfoContract;
import org.w3c.dom.Element;

@XmlRootElement(name="serviceInfo")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ServiceInfoType", propOrder={"serviceId", "serviceName", "endpointUrl", "instanceId", "applicationId", "serverIpAddress", "type", "serviceVersion", "status", "serviceDescriptorId", "checksum", "versionNumber", "_futureElements"})
public final class ServiceInfo
extends AbstractDataTransferObject
implements ServiceInfoContract {
    private static final long serialVersionUID = 4793306414624564991L;
    @XmlElement(name="serviceId", required=false)
    private final String serviceId;
    @XmlJavaTypeAdapter(value=QNameAsStringAdapter.class)
    @XmlElement(name="serviceName", required=true)
    private final QName serviceName;
    @XmlElement(name="endpointUrl", required=true)
    private final String endpointUrl;
    @XmlElement(name="instanceId", required=true)
    private final String instanceId;
    @XmlElement(name="applicationId", required=true)
    private final String applicationId;
    @XmlElement(name="serverIpAddress", required=true)
    private final String serverIpAddress;
    @XmlElement(name="type", required=true)
    private final String type;
    @XmlElement(name="serviceVersion", required=true)
    private final String serviceVersion;
    @XmlJavaTypeAdapter(value=ServiceEndpointStatus.Adapter.class)
    @XmlElement(name="status", required=true)
    private final String status;
    @XmlElement(name="serviceDescriptorId", required=false)
    private final String serviceDescriptorId;
    @XmlElement(name="checksum", required=true)
    private final String checksum;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ServiceInfo() {
        this.serviceId = null;
        this.serviceName = null;
        this.endpointUrl = null;
        this.instanceId = null;
        this.applicationId = null;
        this.serverIpAddress = null;
        this.type = null;
        this.serviceVersion = null;
        this.status = null;
        this.serviceDescriptorId = null;
        this.checksum = null;
        this.versionNumber = null;
    }

    private ServiceInfo(Builder builder) {
        this.serviceId = builder.getServiceId();
        this.serviceName = builder.getServiceName();
        this.endpointUrl = builder.getEndpointUrl();
        this.instanceId = builder.getInstanceId();
        this.applicationId = builder.getApplicationId();
        this.serverIpAddress = builder.getServerIpAddress();
        this.type = builder.getType();
        this.serviceVersion = builder.getServiceVersion();
        ServiceEndpointStatus builderStatus = builder.getStatus();
        this.status = builderStatus == null ? null : builderStatus.getCode();
        this.serviceDescriptorId = builder.getServiceDescriptorId();
        this.checksum = builder.getChecksum();
        this.versionNumber = builder.getVersionNumber();
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Override
    public ServiceEndpointStatus getStatus() {
        return ServiceEndpointStatus.fromCode(this.status);
    }

    @Override
    public String getServiceDescriptorId() {
        return this.serviceDescriptorId;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    static class Elements {
        static final String SERVICE_ID = "serviceId";
        static final String SERVICE_NAME = "serviceName";
        static final String ENDPOINT_URL = "endpointUrl";
        static final String INSTANCE_ID = "instanceId";
        static final String APPLICATION_ID = "applicationId";
        static final String SERVER_IP_ADDRESS = "serverIpAddress";
        static final String TYPE = "type";
        static final String SERVICE_VERSION = "serviceVersion";
        static final String STATUS = "status";
        static final String SERVICE_DESCRIPTOR_ID = "serviceDescriptorId";
        static final String CHECKSUM = "checksum";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "serviceInfo";
        static final String TYPE_NAME = "ServiceInfoType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ServiceInfoContract {
        private static final long serialVersionUID = 4424090938369742940L;
        private String serviceId;
        private QName serviceName;
        private String endpointUrl;
        private String instanceId;
        private String applicationId;
        private String serverIpAddress;
        private String type;
        private String serviceVersion;
        private ServiceEndpointStatus status;
        private String serviceDescriptorId;
        private String checksum;
        private Long versionNumber;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ServiceInfoContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setServiceId(contract.getServiceId());
            builder.setServiceName(contract.getServiceName());
            builder.setEndpointUrl(contract.getEndpointUrl());
            builder.setInstanceId(contract.getInstanceId());
            builder.setApplicationId(contract.getApplicationId());
            builder.setServerIpAddress(contract.getServerIpAddress());
            builder.setType(contract.getType());
            builder.setServiceVersion(contract.getServiceVersion());
            builder.setStatus(contract.getStatus());
            builder.setServiceDescriptorId(contract.getServiceDescriptorId());
            builder.setChecksum(contract.getChecksum());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public ServiceInfo build() {
            this.validateAll();
            return new ServiceInfo(this);
        }

        @Override
        public String getServiceId() {
            return this.serviceId;
        }

        @Override
        public QName getServiceName() {
            return this.serviceName;
        }

        @Override
        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        @Override
        public String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public String getServerIpAddress() {
            return this.serverIpAddress;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getServiceVersion() {
            return this.serviceVersion;
        }

        @Override
        public ServiceEndpointStatus getStatus() {
            return this.status;
        }

        @Override
        public String getServiceDescriptorId() {
            return this.serviceDescriptorId;
        }

        @Override
        public String getChecksum() {
            return this.checksum;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setServiceName(QName serviceName) {
            this.validateServiceName(serviceName);
            this.serviceName = serviceName;
        }

        public void setEndpointUrl(String endpointUrl) {
            this.validateEndpointUrl(endpointUrl);
            this.endpointUrl = endpointUrl;
        }

        public void setInstanceId(String instanceId) {
            this.validateInstanceId(instanceId);
            this.instanceId = instanceId;
        }

        public void setApplicationId(String applicationId) {
            this.validateApplicationId(applicationId);
            this.applicationId = applicationId;
        }

        public void setServerIpAddress(String serverIpAddress) {
            this.validateServerIpAddress(serverIpAddress);
            this.serverIpAddress = serverIpAddress;
        }

        public void setType(String type) {
            this.validateType(type);
            this.type = type;
        }

        public void setServiceVersion(String serviceVersion) {
            this.validateServiceVersion(serviceVersion);
            this.serviceVersion = serviceVersion;
        }

        public void setStatus(ServiceEndpointStatus status) {
            this.validateStatus(status);
            this.status = status;
        }

        public void setServiceDescriptorId(String serviceDescriptorId) {
            this.serviceDescriptorId = serviceDescriptorId;
        }

        public void setChecksum(String checksum) {
            this.validateChecksum(checksum);
            this.checksum = checksum;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        private void assertNotNull(String name, Object object) {
            if (object == null) {
                throw new IllegalArgumentException(name + " was null");
            }
        }

        private void assertNotBlank(String name, String value) {
            this.assertNotNull(name, value);
            if (StringUtils.isBlank((String)value)) {
                throw new IllegalArgumentException(name + " was blank");
            }
        }

        private void validateServiceName(QName serviceName) {
            this.assertNotNull("serviceName", serviceName);
        }

        private void validateEndpointUrl(String endpointUrl) {
            this.assertNotBlank("endpointUrl", endpointUrl);
        }

        private void validateInstanceId(String instanceId) {
            this.assertNotBlank("instanceId", instanceId);
        }

        private void validateApplicationId(String applicationId) {
            this.assertNotBlank("applicationId", applicationId);
        }

        private void validateServerIpAddress(String serverIpAddress) {
            this.assertNotBlank("serverIpAddress", serverIpAddress);
        }

        private void validateType(String type) {
            this.assertNotBlank("type", type);
        }

        private void validateServiceVersion(String serviceVersion) {
            this.assertNotBlank("serviceVersion", serviceVersion);
        }

        private void validateStatus(ServiceEndpointStatus status) {
            this.assertNotNull("status", (Object)status);
        }

        private void validateChecksum(String checksum) {
            this.assertNotBlank("checksum", checksum);
        }

        private void validateAll() {
            this.validateServiceName(this.serviceName);
            this.validateEndpointUrl(this.endpointUrl);
            this.validateInstanceId(this.instanceId);
            this.validateApplicationId(this.applicationId);
            this.validateServerIpAddress(this.serverIpAddress);
            this.validateType(this.type);
            this.validateServiceVersion(this.serviceVersion);
            this.validateStatus(this.status);
            this.validateChecksum(this.checksum);
        }
    }
}

