/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api.bus.support;

import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.springframework.beans.factory.InitializingBean;

/**
 * Used from Spring to register service definitions from an already configured and started KSB.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ServiceBusExporter implements InitializingBean {
	
	private static org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(ServiceBusExporter.class);
	
	private ServiceDefinition serviceDefinition;
	private boolean forceSync = false;
	private ServiceBus serviceBus;

	@Override
    public void afterPropertiesSet() {
		if (getServiceDefinition() == null) {
			throw new IllegalStateException("serviceDefinition must be set");
		}
		getServiceDefinition().validate();
		if ( LOG.isInfoEnabled() ) {
			LOG.info("Attempting to export service with service name '" + getServiceDefinition().getServiceName());
		}
		if (getServiceBus() == null) {
			setServiceBus(autoLocateServiceBus());
		}
		if (getServiceBus() == null) {
			throw new IllegalStateException("serviceBus could not be located and was not set, must not be null");
		}
		getServiceBus().publishService(getServiceDefinition(), forceSync);
	}
	
	protected ServiceBus autoLocateServiceBus() {
		return KsbApiServiceLocator.getServiceBus();
	}

	public ServiceDefinition getServiceDefinition() {
		return this.serviceDefinition;
	}

	public void setServiceDefinition(ServiceDefinition serviceDefinition) {
		this.serviceDefinition = serviceDefinition;
	}
	
	public boolean isForceSync() {
		return this.forceSync;
	}

	public void setForceRefresh(boolean forceSync) {
		this.forceSync = forceSync;
	}

	public ServiceBus getServiceBus() {
		return this.serviceBus;
	}

	public void setServiceBus(ServiceBus serviceBus) {
		this.serviceBus = serviceBus;
	}

}
