/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;

/**
 * A static service locator which aids in locating the various services that
 * form the Kuali Service Bus API.
 */
public class KsbApiServiceLocator {

	public static final String SERVICE_BUS = "rice.ksb.serviceBus";
	public static final String SERVICE_REGISTRY = "rice.ksb.serviceRegistry";

    static <T> T getService(String serviceName) {
        return GlobalResourceLoader.<T>getService(serviceName);
    }

    public static ServiceBus getServiceBus() {
        return getService(SERVICE_BUS);
    }
    
    public static ServiceRegistry getServiceRegistry() {
    	return getService(SERVICE_REGISTRY);
    }
}
