/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;

@XmlRootElement(name="javaServiceConfiguration")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="JavaServiceConfigurationType", propOrder={"serviceInterfaces"})
public final class JavaServiceConfiguration
extends AbstractServiceConfiguration {
    private static final long serialVersionUID = -4226512121638441108L;
    @XmlElementWrapper(name="serviceInterfaces", required=false)
    @XmlElement(name="serviceInterface", required=false)
    private final List<String> serviceInterfaces;

    private JavaServiceConfiguration() {
        this.serviceInterfaces = null;
    }

    private JavaServiceConfiguration(Builder builder) {
        super(builder);
        this.serviceInterfaces = builder.getServiceInterfaces() == null ? null : new ArrayList<String>(builder.getServiceInterfaces());
    }

    public static JavaServiceConfiguration fromServiceDefinition(JavaServiceDefinition javaServiceDefinition) {
        return Builder.create(javaServiceDefinition).build();
    }

    public List<String> getServiceInterfaces() {
        if (this.serviceInterfaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.serviceInterfaces);
    }

    public static final class Builder
    extends AbstractServiceConfiguration.Builder<JavaServiceConfiguration> {
        private static final long serialVersionUID = 4300659121377259098L;
        private List<String> serviceInterfaces;

        public List<String> getServiceInterfaces() {
            return this.serviceInterfaces;
        }

        public void setServiceInterfaces(List<String> serviceInterfaces) {
            this.serviceInterfaces = serviceInterfaces == null ? null : new ArrayList<String>(serviceInterfaces);
        }

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(JavaServiceDefinition javaServiceDefinition) {
            Builder builder = Builder.create();
            builder.copyServiceDefinitionProperties(javaServiceDefinition);
            builder.setServiceInterfaces(javaServiceDefinition.getServiceInterfaces());
            return builder;
        }

        @Override
        public JavaServiceConfiguration build() {
            return new JavaServiceConfiguration(this);
        }
    }

    static class Elements {
        protected static final String SERVICE_INTERFACES = "serviceInterfaces";
        protected static final String SERVICE_INTERFACE = "serviceInterface";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "javaServiceConfiguration";
        static final String TYPE_NAME = "JavaServiceConfigurationType";

        Constants() {
        }
    }
}

