/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.soap;

import java.io.IOException;
import java.util.Properties;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.log4j.Logger;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.handler.RequestData;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.config.wss4j.CryptoPasswordCallbackHandler;

public class CXFWSS4JOutInterceptor
extends WSS4JOutInterceptor {
    private static final Logger LOG = Logger.getLogger(CXFWSS4JOutInterceptor.class);
    private final boolean busSecurity;

    public CXFWSS4JOutInterceptor(boolean busSecurity) {
        this.busSecurity = busSecurity;
        if (busSecurity) {
            this.setProperty("action", "Signature");
            this.setProperty("passwordCallbackClass", CryptoPasswordCallbackHandler.class.getName());
            this.setProperty("signatureKeyIdentifier", "IssuerSerial");
            this.setProperty("user", ConfigContext.getCurrentContextConfig().getKeystoreAlias());
        }
    }

    public Crypto loadSignatureCrypto(RequestData reqData) {
        try {
            return new Merlin(this.getMerlinProperties(), ClassLoaderUtils.getDefaultClassLoader());
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
    }

    public Crypto loadDecryptionCrypto(RequestData reqData) {
        return this.loadSignatureCrypto(reqData);
    }

    protected Properties getMerlinProperties() throws IOException {
        Properties props = new Properties();
        props.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        props.put("org.apache.ws.security.crypto.merlin.keystore.password", ConfigContext.getCurrentContextConfig().getKeystorePassword());
        props.put("org.apache.ws.security.crypto.merlin.alias.password", ConfigContext.getCurrentContextConfig().getKeystorePassword());
        props.put("org.apache.ws.security.crypto.merlin.keystore.alias", ConfigContext.getCurrentContextConfig().getKeystoreAlias());
        props.put("org.apache.ws.security.crypto.merlin.file", ConfigContext.getCurrentContextConfig().getKeystoreFile());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using keystore location " + ConfigContext.getCurrentContextConfig().getKeystoreFile()));
        }
        return props;
    }

    public void handleMessage(SoapMessage mc) {
        if (this.busSecurity) {
            super.handleMessage(mc);
        }
    }
}

