/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.exceptionhandling;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.exceptionhandling.DefaultMessageExceptionHandler;
import org.kuali.rice.ksb.messaging.exceptionhandling.ExceptionRoutingService;
import org.kuali.rice.ksb.messaging.exceptionhandling.MessageExceptionHandler;
import org.kuali.rice.ksb.messaging.quartz.MessageServiceExecutorJob;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class DefaultExceptionServiceImpl
implements ExceptionRoutingService {
    private static final Logger LOG = Logger.getLogger(DefaultExceptionServiceImpl.class);

    @Override
    public void placeInExceptionRouting(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        LOG.error((Object)("Exception caught processing message " + message.getRouteQueueId() + " " + message.getServiceName() + ": " + throwable));
        AsynchronousCall methodCall = null;
        methodCall = message.getMethodCall() != null ? message.getMethodCall() : message.getPayload().getMethodCall();
        message.setMethodCall(methodCall);
        MessageExceptionHandler exceptionHandler = this.getMessageExceptionHandler(methodCall.getServiceConfiguration().getServiceName());
        exceptionHandler.handleException(throwable, message, service);
    }

    @Override
    public void placeInExceptionRoutingLastDitchEffort(Throwable throwable, PersistedMessageBO message, Object service) throws Exception {
        LOG.error((Object)("Exception caught processing message " + message.getRouteQueueId() + " " + message.getServiceName() + ": " + throwable));
        AsynchronousCall methodCall = null;
        methodCall = message.getMethodCall() != null ? message.getMethodCall() : message.getPayload().getMethodCall();
        message.setMethodCall(methodCall);
        MessageExceptionHandler exceptionHandler = this.getMessageExceptionHandler(methodCall.getServiceConfiguration().getServiceName());
        exceptionHandler.handleExceptionLastDitchEffort(throwable, message, service);
    }

    protected MessageExceptionHandler getMessageExceptionHandler(QName serviceName) {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        Endpoint endpoint = serviceBus.getEndpoint(serviceName);
        if (endpoint == null) {
            throw new RiceRuntimeException("No services found for name " + serviceName);
        }
        String messageExceptionHandlerName = endpoint.getServiceConfiguration().getMessageExceptionHandler();
        if (messageExceptionHandlerName == null) {
            messageExceptionHandlerName = DefaultMessageExceptionHandler.class.getName();
        }
        return (MessageExceptionHandler)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(messageExceptionHandlerName));
    }

    @Override
    public void scheduleExecution(Throwable throwable, PersistedMessageBO message, String description) throws Exception {
        KSBServiceLocator.getMessageQueueService().delete(message);
        PersistedMessageBO messageCopy = message.copy();
        Scheduler scheduler = KSBServiceLocator.getScheduler();
        JobDataMap jobData = new JobDataMap();
        jobData.put((Object)"message", (Object)messageCopy);
        JobDetail jobDetail = new JobDetail("Exception_Message_Job " + Math.random(), "Exception Messaging", MessageServiceExecutorJob.class);
        jobDetail.setJobDataMap(jobData);
        if (!StringUtils.isBlank((String)description)) {
            jobDetail.setDescription(description);
        }
        jobDetail.addJobListener("MessageServiceExecutorJobListener");
        SimpleTrigger trigger = new SimpleTrigger("Exception_Message_Trigger " + Math.random(), "Exception Messaging", (Date)messageCopy.getQueueDate());
        trigger.setJobDataMap(jobData);
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }
}

