/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.impl.bus.diff;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.impl.bus.LocalService;

/**
 * TODO... 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class LocalServicesDiff {

	private final List<ServiceInfo> servicesToRemoveFromRegistry;
	private final List<LocalService> localServicesToPublish;
	private final Map<LocalService, ServiceInfo> localServicesToUpdate;
		
	public LocalServicesDiff(List<ServiceInfo> servicesToRemoveFromRegistry,
			List<LocalService> localServicesToPublish,
			Map<LocalService, ServiceInfo> localServicesToUpdate) {
		this.servicesToRemoveFromRegistry = servicesToRemoveFromRegistry == null ? Collections.<ServiceInfo>emptyList() : servicesToRemoveFromRegistry;
		this.localServicesToPublish = localServicesToPublish == null ? Collections.<LocalService>emptyList() : localServicesToPublish;
		this.localServicesToUpdate = localServicesToUpdate == null ? Collections.<LocalService, ServiceInfo>emptyMap() : localServicesToUpdate;
	}

	public List<ServiceInfo> getServicesToRemoveFromRegistry() {
		return this.servicesToRemoveFromRegistry;
	}

	public List<LocalService> getLocalServicesToPublish() {
		return this.localServicesToPublish;
	}
	
	public Map<LocalService, ServiceInfo> getLocalServicesToUpdate() {
		return this.localServicesToUpdate;
	}

}
