/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.credentials;

import java.security.cert.X509Certificate;

import org.kuali.rice.core.api.security.credentials.Credentials;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.core.api.security.credentials.CredentialsType;
import org.springframework.util.Assert;

/**
 * Implementation of a CredentialsSource that returns an X509 Certificate.
 * <p>
 * Note that this class is for service-to-service authentication, not
 * user-to-service authentication.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 0.9
 * @see X509Certificate
 */
public final class X509CredentialsSource implements CredentialsSource {

    private final X509Certificate certificate;

    public X509CredentialsSource(final X509Certificate certificate) {
        Assert.notNull(certificate, "certificate cannot be null.");
        this.certificate = certificate;
    }

    
    
    @Override
    public Credentials getCredentials(final String serviceEndpoint) {
    	return new X509Credentials(certificate);
	}

    @Override
    public CredentialsType getSupportedCredentialsType() {
        return CredentialsType.X509;
    }
}
