/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.quartz;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MessageServiceExecutorJob
implements Job,
Serializable {
    private static final Logger LOG = LogManager.getLogger(MessageServiceExecutorJob.class);
    private static final long serialVersionUID = 6702139047380618522L;
    public static final String MESSAGE_KEY = "message";

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            PersistedMessageBO message = (PersistedMessageBO)jec.getJobDetail().getJobDataMap().get((Object)MESSAGE_KEY);
            message.setQueueStatus("R");
            message.setLockVerNbr(null);
            message = KSBServiceLocator.getMessageQueueService().save(message);
            KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
        }
        catch (Throwable t) {
            LOG.error("Caught throwable attempting to process message in exception messaging queue.", t);
            throw new JobExecutionException((Throwable)new Exception(t));
        }
    }
}

