/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.quartz;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.threadpool.KSBThreadPool;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.util.KSBConstants;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import java.io.Serializable;


/**
 * Job saves a {@link org.kuali.rice.ksb.messaging.PersistedMessageBO} to the message queue in the state of 'R' and then puts into a
 * {@link MessageServiceInvoker} for execution in {@link KSBThreadPool}.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
public class MessageServiceExecutorJob implements Job, Serializable {

    private static final Logger LOG = LogManager.getLogger(MessageServiceExecutorJob.class);

    private static final long serialVersionUID = 6702139047380618522L;

    public static final String MESSAGE_KEY = "message";

    @Override
    public void execute(JobExecutionContext jec) throws JobExecutionException {
	try {
	    PersistedMessageBO message = (PersistedMessageBO) jec.getJobDetail().getJobDataMap().get(MESSAGE_KEY);
 	    message.setQueueStatus(KSBConstants.ROUTE_QUEUE_ROUTING);
        message.setLockVerNbr(null);
	    message = KSBServiceLocator.getMessageQueueService().save(message);
	    KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
	} catch (Throwable t) {
	    LOG.error("Caught throwable attempting to process message in exception messaging queue.", t);
	    throw new JobExecutionException(new Exception(t));
	}
    }
}
