/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.util;

import java.util.HashMap;
import java.util.Map;


/**
 * Utility class to translate the various codes into labels and vice versa.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CodeTranslator {

    public static final Map<String, String> routeQueueStatusLabels = getRouteQueueStatusLabels();

    private static Map<String, String> getRouteQueueStatusLabels() {
        Map<String, String> routeQueueStatusLabels = new HashMap<String, String>();
        routeQueueStatusLabels.put(KSBConstants.ROUTE_QUEUE_EXCEPTION, KSBConstants.ROUTE_QUEUE_EXCEPTION_LABEL);
        routeQueueStatusLabels.put(KSBConstants.ROUTE_QUEUE_QUEUED, KSBConstants.ROUTE_QUEUE_QUEUED_LABEL);
        routeQueueStatusLabels.put(KSBConstants.ROUTE_QUEUE_ROUTING, KSBConstants.ROUTE_QUEUE_ROUTING_LABEL);
        return routeQueueStatusLabels;
    }

    static public String getRouteQueueStatusLabel(String routeQueueStatusCode) {
        return routeQueueStatusLabels.get(routeQueueStatusCode);
    }

}
