/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.state;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * This is the contract for a State.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface StateContract extends Versioned, Inactivatable, Coded {

    /**
     * This the postal name for the State.  This cannot be null or a blank string.
     *
     * @return postal name
     */
    String getName();

    /**
     * The name of the state according to StateCodeDataTypeV3 in UniversalCodes-V2.0.xsd
     * @return V3 postal name
     */
    String getNameV3();

    /**
     * This the postal country code for the State.  This cannot be null or a blank string.
     *
     * @return postal country code
     */
    String getCountryCode();
}
