/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api.county;

import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * This is the contract for a State.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CountyContract extends Inactivatable, Versioned, Coded {

    /**
     * This the postal country code for the County.  This cannot be null or a blank string.
     *
     * @return postal country code
     */
    String getCountryCode();

    /**
     * This the postal state code for the County.  This cannot be null or a blank string.
     *
     * @return postal state code
     */
    String getStateCode();

    /**
     * This the name for the County.  This cannot be null or a blank string.
     *
     * @return name
     */
    String getName();
}
