/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.framework.campus;

import java.util.Comparator;

import org.kuali.rice.location.api.campus.CampusType;

public class CampusTypeComparator implements Comparator<CampusType> {

	private CampusTypeComparator() {
	}
	
	public static final Comparator<CampusType> INSTANCE = new CampusTypeComparator();
	
    @Override
	public int compare(CampusType o1, CampusType o2) {

        CampusType obj1 = o1;
        CampusType obj2 = o2;

        return obj1.getCode().compareTo(obj2.getCode());
    }

}
