/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.country;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryContract;
import org.kuali.rice.location.api.country.CountryQueryResults;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.impl.country.CountryBo;

public final class CountryServiceImpl
implements CountryService {
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private CriteriaLookupService criteriaLookupService;

    public Country getCountry(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is blank");
        }
        CountryBo countryBo = (CountryBo)this.businessObjectService.findByPrimaryKey(CountryBo.class, Collections.singletonMap("code", code));
        return CountryBo.to(countryBo);
    }

    public Country getCountryByAlternateCode(String alternateCode) {
        if (StringUtils.isBlank((String)alternateCode)) {
            throw new RiceIllegalArgumentException("alt code is blank");
        }
        Collection countryList = this.businessObjectService.findMatching(CountryBo.class, Collections.singletonMap("alternateCode", alternateCode));
        if (countryList == null || countryList.isEmpty()) {
            return null;
        }
        if (countryList.size() == 1) {
            return CountryBo.to((CountryBo)((Object)countryList.iterator().next()));
        }
        throw new RiceIllegalStateException("Multiple countries found with same alternateCode");
    }

    public List<Country> findAllCountriesNotRestricted() {
        ArrayList<String> criteriaValues = new ArrayList<String>();
        criteriaValues.add(null);
        criteriaValues.add("N");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("restricted", criteriaValues);
        map.put("active", Boolean.TRUE);
        Collection countryBos = this.businessObjectService.findMatching(CountryBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(countryBos);
    }

    public List<Country> findAllCountries() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("active", Boolean.TRUE);
        Collection countryBos = this.businessObjectService.findMatching(CountryBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(countryBos);
    }

    public Country getDefaultCountry() {
        String defaultCountryCode = this.parameterService.getParameterValueAsString("KR-NS", "All", "DEFAULT_COUNTRY");
        if (StringUtils.isBlank((String)defaultCountryCode)) {
            return null;
        }
        return this.getCountry(defaultCountryCode);
    }

    public CountryQueryResults findCountries(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(CountryBo.class, queryByCriteria);
        CountryQueryResults.Builder builder = CountryQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Country.Builder> ims = new ArrayList<Country.Builder>();
        for (CountryBo bo : results.getResults()) {
            ims.add(Country.Builder.create((CountryContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    List<Country> convertListOfBosToImmutables(Collection<CountryBo> countryBos) {
        ArrayList<Country> countries = new ArrayList<Country>();
        for (CountryBo bo : countryBos) {
            Country country = CountryBo.to(bo);
            countries.add(country);
        }
        return Collections.unmodifiableList(countries);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

