<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="field" required="true" type="org.kuali.rice.kns.web.ui.Field" description="The field to render as read only." %>
<%@ attribute name="addHighlighting" required="false"
              description="boolean indicating if this field should be highlighted (to indicate old/new change)" %>
<%@ attribute name="isLookup" required="false"
              description="boolean indicating if this is a Lookup Screen" %>

<%-- Put the .div span around the link instead of vice versa,
    so that if JavaScript changes the .div contents there is no misleading link. --%>
<span id="${field.propertyName}.div">
<c:if test="${not (empty field.inquiryURL.href || empty field.propertyValue)}">
	<a title="<c:out value="${field.inquiryURL.title}"/>" href="<c:out value="${field.inquiryURL.href}"/>" target="_blank">
</c:if>

<kul:readonlyfield addHighlighting="${addHighlighting}" field="${field}" isLookup="${isLookup}" />

<c:if test="${not (empty field.inquiryURL.href || empty field.propertyValue)}">
  </a>
</c:if>
&nbsp;
</span>
