/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.common.JiraAwareFailureUtils;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestBase;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.kuali.rice.testtools.selenium.JiraAwareWebDriverUtils;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class JiraAwareAftBase
extends AutomatedFunctionalTestBase
implements JiraAwareFailable {
    private boolean passed = false;

    protected abstract void checkForIncidentReport(String var1, String var2);

    protected abstract WebDriver getDriver();

    protected void assertButtonDisabledByText(String buttonText) {
        JiraAwareWebDriverUtils.assertButtonDisabledByText(this.getDriver(), buttonText, this);
    }

    protected void assertButtonEnabledByText(String buttonText) {
        JiraAwareWebDriverUtils.assertButtonEnabledByText(this.getDriver(), buttonText, this);
    }

    protected void assertDataTableContains(String[][] data) throws InterruptedException {
        boolean dataPresent = true;
        String missingMessage = "";
        int s = data.length;
        for (int i = 0; i < s; ++i) {
            String dataTableRow = this.findDataTableRow(data[i][0]).getText();
            int t = data[i].length;
            for (int j = 1; j < t; ++j) {
                if (dataTableRow.contains(data[i][j])) continue;
                dataPresent = false;
                missingMessage = missingMessage + data[i][j] + " not present in data table row containing " + data[i][0] + ". ";
            }
            WebDriverUtils.jGrowl(this.getDriver(), "Assert DataTable Row", false, "Assert datatable row '" + dataTableRow + "' contains '" + Arrays.toString(data[i]) + "' " + dataPresent);
        }
        if (!dataPresent) {
            this.jiraAwareFail(missingMessage);
        }
    }

    protected void assertDataTableContains(String[][] data, String tableClass) throws InterruptedException {
        boolean dataPresent = true;
        String missingMessage = "";
        int s = data.length;
        for (int i = 0; i < s; ++i) {
            String dataTableRow = this.findDataTableRow(data[i][0], tableClass).getText();
            int t = data[i].length;
            for (int j = 1; j < t; ++j) {
                if (dataTableRow.contains(data[i][j])) continue;
                dataPresent = false;
                missingMessage = missingMessage + data[i][j] + " not present in data table row containing " + data[i][0] + ". ";
            }
        }
        if (!dataPresent) {
            this.jiraAwareFail(missingMessage);
        }
    }

    protected void assertElementPresentByName(String name) {
        this.assertElementPresentByName(name, this.getClass().toString());
    }

    protected void assertElementPresentByName(String name, String message) {
        try {
            this.findElement(By.name((String)name));
        }
        catch (Throwable t) {
            this.jiraAwareFail(name + " not present " + message);
        }
    }

    protected void assertElementPresentByXpath(String locator) {
        this.assertElementPresentByXpath(locator, this.getClass().toString());
    }

    protected void assertElementPresent(By by) {
        this.assertElementPresent(by, this.getClass().toString());
    }

    protected void assertElementPresent(By by, String message) {
        try {
            this.findElement(by);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by, message, t);
        }
    }

    protected void assertElementPresentByXpath(String locator, String message) {
        try {
            this.findElement(By.xpath((String)locator));
        }
        catch (Throwable t) {
            this.jiraAwareFail(By.xpath((String)locator), message, t);
        }
    }

    protected void assertElementPresentByLinkText(String linkText) {
        try {
            this.findElement(By.linkText((String)linkText));
        }
        catch (Throwable t) {
            this.jiraAwareFail(By.cssSelector((String)linkText), this.getClass().toString(), t);
        }
    }

    protected void assertElementPresent(String locator) {
        try {
            this.findElement(By.cssSelector((String)locator));
        }
        catch (Throwable t) {
            this.jiraAwareFail(By.cssSelector((String)locator), this.getClass().toString(), t);
        }
    }

    protected void assertEquals(boolean expected, boolean actual) {
        if (expected != actual) {
            this.jiraAwareFail("Expected \"" + expected + "\" but saw \"" + actual + "\" instead");
        }
    }

    protected void assertEquals(int expected, int actual) {
        if (expected != actual) {
            this.jiraAwareFail("Expected \"" + expected + "\" but saw \"" + actual + "\" instead");
        }
    }

    protected void assertEquals(String message, int expected, int actual) {
        if (expected != actual) {
            this.jiraAwareFail("Expected \"" + expected + "\" but saw \"" + actual + "\" instead " + message);
        }
    }

    protected void assertEquals(String expected, String actual) {
        if (!expected.equals(actual)) {
            this.jiraAwareFail("Expected \"" + expected + "\" but saw \"" + actual + "\" instead in " + this.getClass().toString());
        }
    }

    protected void assertEquals(String message, String expected, String actual) {
        if (!expected.equals(actual)) {
            this.jiraAwareFail("Expected \"" + expected + "\" but saw \"" + actual + "\" instead " + message);
        }
    }

    protected void assertFalse(boolean booleanToAssertFalse) {
        JiraAwareWebDriverUtils.assertFalse(booleanToAssertFalse, this);
    }

    protected void assertFalse(String message, boolean booleanToAssertFalse) {
        JiraAwareWebDriverUtils.assertFalse(message, booleanToAssertFalse, this);
    }

    protected void assertIsVisible(String locator) {
        if (!this.isVisible(locator)) {
            this.jiraAwareFail(locator + " is not visible and should be");
        }
    }

    protected void assertIsVisible(By by, String message) {
        if (!this.isVisible(by)) {
            this.jiraAwareFail(by + " not visible " + message);
        }
    }

    protected void assertIsVisibleById(String id) {
        if (!this.isVisibleById(id)) {
            this.jiraAwareFail(id + " is not visible and should be");
        }
    }

    protected void assertIsVisibleByXpath(String xpath, String message) {
        if (!this.isVisibleByXpath(xpath)) {
            this.jiraAwareFail(xpath + " not visible " + message);
        }
    }

    protected void assertIsNotVisible(By by) {
        this.assertIsNotVisible(by, this.getClass().toString());
    }

    protected void assertIsNotVisible(By by, String message) {
        if (this.isVisible(by)) {
            this.jiraAwareFail(by + " is visible and should not be " + message);
        }
    }

    protected void assertIsNotVisible(String locator) {
        if (this.isVisible(locator)) {
            this.jiraAwareFail(locator + " is visible and should not be");
        }
    }

    protected void assertIsNotVisibleByXpath(String xpath) {
        if (this.isVisible(By.xpath((String)xpath))) {
            this.jiraAwareFail(xpath + " is visible and should not be");
        }
    }

    protected void assertIsNotVisibleByXpath(String xpath, String message) {
        if (this.isVisibleByXpath(xpath)) {
            this.jiraAwareFail(xpath + " visible and should not be " + message);
        }
    }

    protected void assertLabeledTextNotPresent(String[][] labeledText) {
        boolean allLabeledTextNotPresent = true;
        String missingMessage = "";
        int s = labeledText.length;
        for (int i = 0; i < s; ++i) {
            if (!this.isLabeledTextPresent(labeledText[i][0], labeledText[i][1])) continue;
            allLabeledTextNotPresent = false;
            missingMessage = missingMessage + "Text: " + labeledText[i][1] + " labeled by: " + labeledText[i][0] + " present. ";
        }
        if (!allLabeledTextNotPresent) {
            this.jiraAwareFail(missingMessage);
        }
    }

    protected void assertLabeledTextPresent(String[][] labeledText) {
        boolean allLabeledTextPresent = true;
        String missingMessage = "";
        int s = labeledText.length;
        for (int i = 0; i < s; ++i) {
            if (this.isLabeledTextPresent(labeledText[i][0], labeledText[i][1])) continue;
            allLabeledTextPresent = false;
            missingMessage = missingMessage + "Text: " + labeledText[i][1] + " labeled by: " + labeledText[i][0] + " not present. ";
        }
        if (!allLabeledTextPresent) {
            this.jiraAwareFail(missingMessage);
        }
    }

    protected void assertLabeledInputTextPresent(String[][] labeledText) {
        boolean allLabeledTextPresent = true;
        String missingMessage = "";
        int s = labeledText.length;
        for (int i = 0; i < s; ++i) {
            if (this.isLabeledInputTextPresent(labeledText[i][0], labeledText[i][1])) continue;
            allLabeledTextPresent = false;
            missingMessage = missingMessage + "Text: " + labeledText[i][1] + " labeled by: " + labeledText[i][0] + " not present. ";
        }
        if (!allLabeledTextPresent) {
            this.jiraAwareFail(missingMessage);
        }
    }

    protected void assertLabeledTextPresent(String label, String text) {
        if (!this.isLabeledTextPresent(label, text)) {
            this.jiraAwareFail("Text: " + text + " labeled by: " + label + " not present");
        }
    }

    protected void assertResultCount(String count) throws InterruptedException {
        this.jiraAwareWaitFor(By.cssSelector((String)"div.dataTables_info"), "result count for " + this.getClass().toString());
        this.assertTextPresent("of " + count + " entries", "div.dataTables_info", this.getClass().toString());
    }

    protected void assertTextPresent(String text) {
        this.assertTextPresent(text, this.getClass().toString());
    }

    protected void assertTextPresent(String text, String message) {
        WebDriverUtils.jGrowl(this.getDriver(), "Assert Text Present", false, "Assert text '" + text + "' is present.");
        String pageSource = this.getDriver().getPageSource();
        if (!pageSource.contains(text)) {
            this.jiraAwareFail(text + " not present " + message);
        }
        WebDriverUtils.highlightElement(this.getDriver(), By.xpath((String)("//*[contains(text(), '" + text + "')]")));
    }

    protected void assertTextPresent(String text, String cssSelector, String message) {
        WebElement element = this.findElement(By.cssSelector((String)cssSelector));
        if (!element.getText().contains(text)) {
            this.jiraAwareFail(text + " for " + cssSelector + " not present " + message);
        }
    }

    protected void assertTextNotPresent(String text) {
        this.assertTextNotPresent(text, this.getClass().toString());
    }

    protected void assertTextNotPresent(String text, String message) {
        String contents = this.getDriver().getPageSource();
        if (contents.contains(text)) {
            this.jiraAwareFail(text + " is present and should not be " + message);
        }
    }

    protected void assertTextNotPresent(String text, String cssSelector, String message) {
        WebElement element = this.findElement(By.cssSelector((String)cssSelector));
        if (element.getText().contains(text)) {
            this.jiraAwareFail(text + " for " + cssSelector + " is present and shouldn't be " + message);
        }
    }

    protected void assertTrue(boolean booleanToAssertTrue) {
        JiraAwareWebDriverUtils.assertTrue(this.getClass().toString(), booleanToAssertTrue, this);
    }

    protected void assertTrue(String message, boolean booleanToAssertTrue) {
        JiraAwareWebDriverUtils.assertTrue(message, booleanToAssertTrue, this);
    }

    @Override
    public void fail(String message) {
        this.passed = false;
        WebDriverUtils.jGrowl(this.getDriver(), "Failure " + this.getClass().getSimpleName(), true, message);
        Assert.fail((String)message);
    }

    protected WebElement findDataTableRow(String keyText) throws InterruptedException {
        return this.findDataTableRow(keyText, "dataTable");
    }

    protected WebElement findDataTableRow(String keyText, String className) throws InterruptedException {
        this.jiraAwareWaitFor(By.className((String)className));
        WebElement element = this.findElement(By.className((String)className));
        return this.findElement(By.xpath((String)("./*/tr//*[contains(text(), '" + keyText + "')]/ancestor::tr")), element);
    }

    protected WebElement findElement(By by) {
        try {
            return WebDriverUtils.findElement(this.getDriver(), by);
        }
        catch (Throwable t) {
            this.checkForIncidentReport(by.toString(), t.getMessage());
            this.jiraAwareFail(by.toString(), t.getMessage(), t);
            return null;
        }
    }

    protected WebElement findElement(By by, WebElement elementToFindOn) {
        try {
            WebElement found = elementToFindOn.findElement(by);
            WebDriverUtils.highlightElement(this.getDriver(), found);
            return found;
        }
        catch (Throwable t) {
            this.checkForIncidentReport(by.toString(), t.getMessage());
            this.jiraAwareFail(by.toString(), t.getMessage() + " " + this.getClass().toString(), t);
            return null;
        }
    }

    protected boolean isLabeledTextPresent(String label, String text) {
        WebElement element = this.findElement(By.xpath((String)("//tr/th/label[contains(text(), '" + label + "')]/ancestor::tr/td")));
        String labeledText = element.getText().trim();
        WebDriverUtils.jGrowl(this.getDriver(), "Is Labeled Text Present", false, "Is text '" + text + "' present for label '" + label + "'? " + labeledText.contains(text) + " saw " + labeledText);
        return labeledText.contains(text);
    }

    protected boolean isLabeledInputTextPresent(String label, String text) {
        String labeledText = "no input or select found no text returned";
        List inputs = this.getDriver().findElements(By.xpath((String)("//tr/th/label[contains(text(), '" + label + "')]/ancestor::tr/td/div/input")));
        if (inputs.size() > 1) {
            System.out.println("found more elements in labeled input than expected");
        }
        if (inputs.size() == 1) {
            labeledText = ((WebElement)inputs.get(0)).getAttribute("value").trim();
            if (labeledText.equals(text.toUpperCase())) {
                text = text.toUpperCase();
            }
        } else {
            inputs = this.getDriver().findElements(By.xpath((String)("//tr/th/label[contains(text(), '" + label + "')]/ancestor::tr/td/div/select")));
            if (inputs.size() > 1) {
                System.out.println("found more elements in labeled input than expected");
            }
            if (inputs.size() == 1) {
                List options = ((WebElement)inputs.get(0)).findElements(By.tagName((String)"option"));
                for (WebElement option : options) {
                    if (option.getAttribute("selected") == null) continue;
                    labeledText = option.getText().trim();
                }
            }
        }
        WebDriverUtils.jGrowl(this.getDriver(), "Is Labeled Text Present", false, "Is text '" + text + "' present for label '" + label + "'? " + labeledText.contains(text) + " saw " + labeledText);
        return labeledText.contains(text);
    }

    protected boolean isVisible(String locator) {
        return this.isVisible(By.cssSelector((String)locator));
    }

    protected boolean isVisible(By by) {
        List elements = this.getDriver().findElements(by);
        for (WebElement element : elements) {
            try {
                if (!element.isDisplayed()) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    protected boolean isVisibleById(String id) {
        return this.isVisible(By.id((String)id));
    }

    protected boolean isVisibleByXpath(String locator) {
        return this.isVisible(By.xpath((String)locator));
    }

    protected WebElement jiraAwareClearType(By by, String text) {
        return this.jiraAwareClearAndType(by, text, this.getClass().toString().replace("class ", ""));
    }

    protected WebElement jiraAwareClearAndType(By by, String text, String failureMessage) {
        this.findElement(by).clear();
        return this.jiraAwareType(by, text, failureMessage);
    }

    protected WebElement jiraAwareClearAndTypeByName(String name, String text) {
        return this.jiraAwareClearAndType(By.name((String)name), text, this.getClass().toString().replace("class ", ""));
    }

    protected WebElement jiraAwareClearAndTypeByName(String name, String text, String failureMessage) {
        return this.jiraAwareClearAndType(By.name((String)name), text, failureMessage);
    }

    @Override
    public void jiraAwareFail(String message) {
        this.jiraAwareFail("", message, null, this);
    }

    @Override
    public void jiraAwareFail(String contents, String message) {
        this.jiraAwareFail(contents, message, null, this);
    }

    protected void jiraAwareFail(By by, String message, Throwable throwable) {
        this.jiraAwareFail(by.toString(), message, throwable, this);
    }

    @Override
    public void jiraAwareFail(String contents, String message, Throwable throwable) {
        this.jiraAwareFail(contents, message, throwable, this);
    }

    public void jiraAwareFail(String pageSource, By by, String message, Throwable t) {
    }

    protected void jiraAwareFail(String contents, String message, Throwable throwable, JiraAwareFailable failable) {
        String errorMessage;
        this.passed = false;
        if (message == null) {
            message = "";
        }
        String javascriptErrors = WebDriverUtils.javascriptErrorsToString(WebDriverUtils.javascriptErrors(this.getDriver()));
        message = javascriptErrors + message;
        if (contents == null) {
            contents = this.getDriver().getPageSource();
        }
        if (!contents.startsWith("\nIncident report") && !message.startsWith("\nIncident report") && (errorMessage = AutomatedFunctionalTestUtils.incidentReportMessage(this.getDriver().getPageSource(), "", message)) != null) {
            JiraAwareFailureUtils.failOnMatchedJira(errorMessage, message, failable);
            JiraAwareFailureUtils.fail(errorMessage, message, throwable, failable);
        }
        JiraAwareFailureUtils.fail(contents, message, throwable, failable);
    }

    protected void jiraAwareWaitAndClick(By by, String message) throws InterruptedException {
        this.jiraAwareWaitAndClick(by, message, this);
    }

    protected WebElement jiraAwareType(By by, String text) {
        return this.jiraAwareType(by, text, this.getClass().toString().replace("class ", ""));
    }

    protected WebElement jiraAwareType(By by, String text, String failureMessage) {
        try {
            return this.type(by, text);
        }
        catch (Throwable t) {
            JiraAwareFailureUtils.failOnMatchedJira(by.toString(), failureMessage, this);
            this.jiraAwareFail(t.getMessage() + " " + by.toString() + "  unable to type text '" + text + "'  " + failureMessage + " current url " + this.getDriver().getCurrentUrl() + "\n" + AutomatedFunctionalTestUtils.deLinespace(this.getDriver().getPageSource()));
            return null;
        }
    }

    protected WebElement jiraAwareTypeByName(String name, String text) {
        return this.jiraAwareType(By.name((String)name), text, this.getClass().toString().replace("class ", ""));
    }

    protected WebElement jiraAwareTypeByName(String name, String text, String failureMessage) {
        return this.jiraAwareType(By.name((String)name), text, failureMessage);
    }

    protected void jiraAwareWaitAndClick(By by, String message, JiraAwareFailable failable) throws InterruptedException {
        this.jiraAwareWaitAndClick(by, WebDriverUtils.configuredImplicityWait(), message, failable);
    }

    protected void jiraAwareWaitAndClick(By by, int waitSeconds, String message, JiraAwareFailable failable) throws InterruptedException {
        try {
            this.jiraAwareWaitFor(by, waitSeconds, message, failable);
            this.findElement(by).click();
        }
        catch (Throwable t) {
            failable.jiraAwareFail(by.toString(), message, t);
        }
    }

    protected WebElement jiraAwareWaitFor(By by) throws InterruptedException {
        return this.jiraAwareWaitFor(by, this.getClass().toString());
    }

    protected WebElement jiraAwareWaitFor(By by, String message) throws InterruptedException {
        try {
            return WebDriverUtils.waitFor(this.getDriver(), WebDriverUtils.configuredImplicityWait(), by, message);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by, message + " " + this.getClass().toString(), t);
            return null;
        }
    }

    protected void jiraAwareWaitFors(By by, String message) throws InterruptedException {
        try {
            WebDriverUtils.waitFors(this.getDriver(), WebDriverUtils.configuredImplicityWait(), by, message);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by, message, t);
        }
    }

    protected void jiraAwareWaitFor(By by, String message, JiraAwareFailable failable) throws InterruptedException {
        this.jiraAwareWaitFor(by, WebDriverUtils.configuredImplicityWait(), message, failable);
    }

    protected void jiraAwareWaitFor(By by, int waitSeconds, String message, JiraAwareFailable failable) throws InterruptedException {
        try {
            WebDriverUtils.waitFor(this.getDriver(), waitSeconds, by, message);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by.toString(), message, t, failable);
        }
    }

    protected WebElement jiraAwareWaitFor(By by, int seconds, String message) throws InterruptedException {
        try {
            return WebDriverUtils.waitFor(this.getDriver(), seconds, by, message);
        }
        catch (Throwable t) {
            this.jiraAwareFail(by, message, t);
            return null;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }

    protected void selectOptionByName(String name, String optionValue) throws InterruptedException {
        this.selectOption(By.name((String)name), optionValue);
    }

    protected void selectOptionByXpath(String locator, String optionValue) throws InterruptedException {
        this.selectOption(By.name((String)locator), optionValue);
    }

    protected void selectOption(By by, String optionValue) throws InterruptedException {
        WebElement select1 = this.findElement(by);
        List options = select1.findElements(By.tagName((String)"option"));
        String name = select1.getAttribute("name");
        if (options == null || options.size() == 0) {
            this.jiraAwareFail("No options for select " + select1.toString() + " was looking for value " + optionValue + " using " + by.toString());
        }
        for (WebElement option : options) {
            if (!option.getAttribute("value").equals(optionValue)) continue;
            WebDriverUtils.jGrowl(this.getDriver(), "Select " + option.getText(), false, "Select " + option.getText() + " from " + name);
            option.click();
            break;
        }
    }

    protected void selectOptionText(By by, String optionText) throws InterruptedException {
        WebElement select1 = this.findElement(by);
        List options = select1.findElements(By.tagName((String)"option"));
        String name = select1.getAttribute("name");
        if (options == null || options.size() == 0) {
            this.jiraAwareFail("No options for select " + select1.toString() + " was looking for text " + optionText + " using " + by.toString());
        }
        for (WebElement option : options) {
            if (!option.getText().equals(optionText)) continue;
            WebDriverUtils.jGrowl(this.getDriver(), "Select " + option.getText(), false, "Select " + option.getText() + " from " + name);
            option.click();
            break;
        }
    }

    private WebElement type(By by, String text) {
        WebElement element = this.findElement(by);
        String name = element.getAttribute("name");
        WebDriverUtils.jGrowl(this.getDriver(), "Type", false, "Type into " + name + " the text: " + text);
        WebDriverUtils.highlightElement(this.getDriver(), element);
        element.sendKeys(new CharSequence[]{text});
        return element;
    }

    private WebElement typeByName(String name, String text) {
        return this.type(By.name((String)name), text);
    }

    protected void passed() {
        if (this.passed) {
            WebDriverUtils.jGrowl(this.getDriver(), "Passed has been called more than once " + this.getClass().getSimpleName(), true, "Passed");
        }
        this.passed = true;
        WebDriverUtils.jGrowl(this.getDriver(), "Success " + this.getClass().getSimpleName(), true, "Passed");
    }

    protected WebElement waitAndType(By by, String text, String message) throws InterruptedException {
        try {
            this.jiraAwareWaitFor(by, message);
            return this.type(by, text);
        }
        catch (Throwable t) {
            this.checkForIncidentReport(by.toString(), message);
            JiraAwareFailureUtils.failOnMatchedJira(by.toString(), message, this);
            this.jiraAwareFail(t.getMessage() + " " + by.toString() + "  unable to type text '" + text + "'  " + message + " current url " + this.getDriver().getCurrentUrl() + "\n" + AutomatedFunctionalTestUtils.deLinespace(this.getDriver().getPageSource()));
            return null;
        }
    }
}

