/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class JiraIssueCreation {
    WebDriver driver;
    String jiraBase;
    List<File> jiraDataDirs = new LinkedList<File>();
    boolean passed = false;
    Map<String, String> jiraMap = new HashMap<String, String>();
    Map<String, Map<String, String>> jiraMaps = new HashMap<String, Map<String, String>>();

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.jiraMap.put("project-field", System.getProperty("jira.project", "Kuali Rice Development"));
        this.jiraMap.put("jira.versions", System.getProperty("jira.versions", "2.5").replaceAll(",", " "));
        this.jiraMap.put("jira.fixVersions", System.getProperty("jira.fixVersions", "").replaceAll(",", " "));
        this.jiraMap.put("issuetype-field", System.getProperty("jira.issuetype", "Bug Fix"));
        this.jiraMap.put("jira.component", System.getProperty("jira.component", "Regression,Development").replaceAll(",", " "));
        this.jiraMap.put("jira.priority", System.getProperty("jira.priority", "Critical"));
        this.jiraBase = System.getProperty("jira.base.url", "https://jira.kuali.org");
        File inputDir = new File(System.getProperty("jira.input.dir", "."));
        File[] listDir = inputDir.listFiles();
        for (int i = 0; i < listDir.length; ++i) {
            if (!listDir[i].isDirectory()) continue;
            this.jiraDataDirs.add(listDir[i]);
        }
        this.createJiraMaps();
        this.dumpJiraMaps();
        this.login();
        this.passed = true;
    }

    private void dumpJiraMaps() {
        for (Map<String, String> jiraMapped : this.jiraMaps.values()) {
            for (String key : jiraMapped.keySet()) {
                System.out.println(key + " = " + jiraMapped.get(key));
            }
            System.out.println("\n\n\n\n\n\n\n\n");
        }
    }

    private void login() throws InterruptedException {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        FirefoxProfile profile = new FirefoxProfile();
        profile.setEnableNativeEvents(false);
        capabilities.setCapability("firefox_profile", (Object)profile);
        this.driver = new FirefoxDriver((Capabilities)capabilities);
        this.driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        this.driver.get(this.jiraBase + "/secure/Dashboard.jspa");
        WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.className((String)"login-link"), this.getClass().toString()).click();
        WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"username"), this.getClass().toString());
        this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{System.getProperty("cas.username")});
        this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{System.getProperty("cas.password")});
        this.driver.findElement(By.name((String)"submit")).click();
    }

    @After
    public void tearDown() {
    }

    public void createJiraMaps() throws InterruptedException, IOException {
        LinkedList<JiraData> jiraDatas = new LinkedList<JiraData>();
        for (File dir : this.jiraDataDirs) {
            File[] inputFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jira");
                }
            });
            int s = inputFiles.length;
            for (int i = 0; i < s; ++i) {
                jiraDatas.add(this.parseJiraData(inputFiles[i]));
            }
            String testClass = ((JiraData)jiraDatas.get((int)0)).fullTestName.substring(0, ((JiraData)jiraDatas.get((int)0)).fullTestName.lastIndexOf("."));
            testClass = testClass.replace("org.kuali.rice.", "");
            testClass = testClass.replace("edu.sampleu.", "");
            String summary = System.getProperty("jira.summary.start", "").replaceAll("_", " ") + " " + testClass;
            if (jiraDatas.size() == 1) {
                summary = summary + " " + ((JiraData)jiraDatas.get((int)0)).testDetails;
            }
            summary = summary.replace("java.lang.AssertionError: ", "");
            if ((summary = summary.replace("org.eclipse.persistence.exceptions.DatabaseException: \nInternal Exception: com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException: ", "")).indexOf("\n") > -1) {
                summary = summary.substring(0, summary.indexOf("\n")).trim();
            } else if (summary.indexOf("\t") > -1) {
                summary = summary.substring(0, summary.indexOf("\t")).trim();
            }
            if (summary.length() > 180) {
                summary = summary.substring(0, 179);
            }
            this.jiraMap.put("jira.summary", summary);
            StringBuilder description = new StringBuilder(summary).append(" ").append(System.getProperty("jira.description.start", "").replaceAll("_", " ")).append("\n");
            for (JiraData jiraData : jiraDatas) {
                if (!"".equals(jiraData.aftSteps)) {
                    description.append("\n").append(jiraData.aftSteps);
                }
                description.append("\n").append(jiraData.fullTestName).append(" ( ").append(jiraData.shortTestName).append(" ) - ");
                description.append(jiraData.testUrl).append("\n");
                description.append("\n{code}\n\n").append(((JiraData)jiraDatas.get((int)0)).testDetails).append("\n\n{code}\n");
            }
            this.jiraMap.put("jira.description", description.toString());
            this.jiraMaps.put(dir.getName(), new HashMap<String, String>(this.jiraMap));
        }
    }

    @Test
    public void testCreateJira() throws InterruptedException, IOException {
        for (Map<String, String> jiraMap : this.jiraMaps.values()) {
            WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"create_link"), this.getClass().toString());
            this.driver.get(this.jiraBase + "/secure/CreateIssue!default.jspa");
            WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"project-field"), this.getClass().toString()).sendKeys(new CharSequence[]{jiraMap.get("jira.project")});
            WebElement issue = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"issuetype-field"), this.getClass().toString());
            issue.click();
            issue.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            issue.sendKeys(new CharSequence[]{jiraMap.get("jira.issuetype")});
            issue.sendKeys(new CharSequence[]{Keys.TAB});
            WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"issue-create-submit"), this.getClass().toString()).click();
            WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"summary"), this.getClass().toString()).sendKeys(new CharSequence[]{jiraMap.get("jira.summary")});
            WebElement component = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"components-textarea"), this.getClass().toString());
            String components = jiraMap.get("jira.component");
            StringTokenizer tokens = new StringTokenizer(components);
            while (tokens.hasMoreElements()) {
                component.click();
                component.sendKeys(new CharSequence[]{tokens.nextToken()});
                component.sendKeys(new CharSequence[]{Keys.TAB});
            }
            WebElement descriptionElement = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"description"), this.getClass().toString());
            descriptionElement.click();
            descriptionElement.sendKeys(new CharSequence[]{jiraMap.get("jira.description")});
            WebElement priority = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"priority-field"), this.getClass().toString());
            priority.click();
            priority.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            priority.sendKeys(new CharSequence[]{jiraMap.get("jira.priority")});
            priority.sendKeys(new CharSequence[]{Keys.TAB});
            WebElement version = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"versions-textarea"), this.getClass().toString());
            version.click();
            version.sendKeys(new CharSequence[]{jiraMap.get("jira.versions")});
            version.sendKeys(new CharSequence[]{Keys.TAB});
            WebElement fixVersion = WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"fixVersions-textarea"), this.getClass().toString());
            fixVersion.click();
            fixVersion.sendKeys(new CharSequence[]{jiraMap.get("jira.fixVersions")});
            fixVersion.sendKeys(new CharSequence[]{Keys.TAB});
            WebDriverUtils.waitFor(this.driver, WebDriverUtils.configuredImplicityWait(), By.id((String)"customfield_11621-1"), this.getClass().toString()).click();
            WebDriverUtils.waitFor(this.driver, 8, By.id((String)"issue-create-submit"), this.getClass().toString());
        }
    }

    protected JiraData parseJiraData(File inputFile) throws IOException {
        String rawData = FileUtils.readFileToString((File)inputFile, (String)null);
        JiraData jiraData = new JiraData();
        try {
            jiraData.aftSteps = rawData.substring(rawData.indexOf("AFT Step:"), rawData.indexOf("Abbreviated test name: "));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        jiraData.shortTestName = rawData.substring(rawData.indexOf("Abbreviated test name: ") + 23, rawData.indexOf("Full test name: ")).trim();
        jiraData.fullTestName = rawData.substring(rawData.indexOf("Full test name: ") + 16, rawData.indexOf("Test results url: ")).trim();
        jiraData.testUrl = rawData.substring(rawData.indexOf("Test results url: ") + 18, rawData.indexOf("Error Message: ")).trim();
        jiraData.errorMessage = rawData.substring(rawData.indexOf("Error Message: ") + 15, rawData.indexOf("Test Details: ")).trim();
        jiraData.testDetails = rawData.substring(rawData.indexOf("Test Details: ") + 14, rawData.length()).trim().replace("\t", "       ");
        return jiraData;
    }

    private void closeAndQuitWebDriver() {
        if (this.driver != null) {
            if (WebDriverUtils.dontTearDownPropertyNotSet() && WebDriverUtils.dontTearDownOnFailure(this.passed)) {
                try {
                    this.driver.close();
                }
                catch (NoSuchWindowException nswe) {
                    System.out.println("NoSuchWindowException closing WebDriver " + nswe.getMessage());
                }
                finally {
                    if (this.driver != null) {
                        this.driver.quit();
                    }
                }
            }
        } else {
            System.out.println("WebDriver is null for " + this.getClass().toString());
        }
    }

    class JiraData {
        String aftSteps = "";
        String shortTestName;
        String fullTestName;
        String testUrl;
        String errorMessage;
        String testDetails;

        JiraData() {
        }
    }
}

