/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import com.saucelabs.common.SauceOnDemandAuthentication;
import com.saucelabs.common.SauceOnDemandSessionIdProvider;
import com.saucelabs.saucerest.SauceREST;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.junit.Assert;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SauceLabsWebDriverHelper
implements SauceOnDemandSessionIdProvider {
    public static final String REMOTE_DRIVER_SAUCELABS_PROPERTY = "remote.driver.saucelabs";
    public static final String SAUCE_BROWSER_PROPERTY = "saucelabs.browser";
    public static final String SAUCE_BUILD_PROPERTY = "rice.version";
    public static final String SAUCE_DOWNLOAD_SCRIPT_PROPERTY = "saucelabs.download.scripts";
    public static final String SAUCE_IDLE_TIMEOUT_SECONDS_PROPERTY = "saucelabs.idle.timeout.seconds";
    public static final String SAUCE_KEY_PROPERTY = "saucelabs.key";
    public static final String SAUCE_MAX_DURATION_SECONDS_PROPERTY = "saucelabs.max.duration.seconds";
    public static final String SAUCE_PLATFORM_PROPERTY = "saucelabs.platform";
    public static final String SAUCE_IE_INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS_PROPERTY = "saucelabs.ie.ignore.domains";
    public static final String SAUCE_POPUP_PROPERTY = "saucelabs.pop.disable";
    public static final String SAUCE_SHARE_PROPERTY = "saucelabs.share";
    public static final String SAUCE_USER_PROPERTY = "saucelabs.user";
    public static final String SAUCE_VERSION_PROPERTY = "saucelabs.browser.version";
    public static final String SAUCE_REST_API_DELAY_MS = "saucelabs.rest.api.delay.ms";
    public SauceOnDemandAuthentication authentication = new SauceOnDemandAuthentication(System.getProperty("saucelabs.user"), System.getProperty("saucelabs.key"));
    private WebDriver driver;
    private String sessionId;

    public void setUp(String className, String testName) throws Exception {
        if (System.getProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY) == null) {
            return;
        }
        if (System.getProperty(SAUCE_USER_PROPERTY) == null || System.getProperty(SAUCE_KEY_PROPERTY) == null) {
            Assert.fail((String)"-Dsaucelabs.user and -Dsaucelabs.key must be set to saucelabs user and access key.");
        }
        DesiredCapabilities capabilities = null;
        if ("ff".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY))) {
            capabilities = DesiredCapabilities.firefox();
        } else if ("ie".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY))) {
            capabilities = DesiredCapabilities.internetExplorer();
            capabilities.setCapability("ignoreProtectedModeSettings", System.getProperty(SAUCE_IE_INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS_PROPERTY, "true"));
        } else {
            capabilities = "chrome".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.chrome() : ("opera".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.opera() : ("android".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.android() : ("safari".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.safari() : ("ipad".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.ipad() : ("iphone".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY)) ? DesiredCapabilities.iphone() : DesiredCapabilities.firefox())))));
        }
        String version = System.getProperty(SAUCE_VERSION_PROPERTY);
        if (version == null || "0".equals(version)) {
            if (!"chrome".equalsIgnoreCase(System.getProperty(SAUCE_BROWSER_PROPERTY))) {
                throw new RuntimeException("Blank or 0 version for a browser not chrome " + System.getProperty(SAUCE_BROWSER_PROPERTY));
            }
            capabilities.setCapability("version", "");
        } else {
            capabilities.setCapability("version", version);
        }
        capabilities.setCapability("platform", System.getProperty(SAUCE_PLATFORM_PROPERTY, Platform.UNIX.toString()).replaceAll("_", " "));
        capabilities.setCapability("idle-timeout", (Object)Integer.parseInt(System.getProperty(SAUCE_IDLE_TIMEOUT_SECONDS_PROPERTY, "180")));
        capabilities.setCapability("max-duration", (Object)Integer.parseInt(System.getProperty(SAUCE_MAX_DURATION_SECONDS_PROPERTY, "600")));
        capabilities.setCapability("name", className + "." + testName + "-" + AutomatedFunctionalTestUtils.DTS);
        capabilities.setCapability("disable-popup-handler", System.getProperty(SAUCE_POPUP_PROPERTY, "false"));
        capabilities.setCapability("public", System.getProperty(SAUCE_SHARE_PROPERTY, "public restricted"));
        System.out.println("Requesting Saucelabs RemoteWebDriver with DesiredCapabilities of " + capabilities.toString());
        this.driver = new RemoteWebDriver(new URL("http://" + this.authentication.getUsername() + ":" + this.authentication.getAccessKey() + "@ondemand.saucelabs.com:80/wd/hub"), (Capabilities)capabilities);
        this.sessionId = ((RemoteWebDriver)this.driver).getSessionId().toString();
        System.out.println("SauceLabs job can be viewed at https://saucelabs.com/jobs/" + this.sessionId);
    }

    private void downloadResults(String className, String testName) {
        if ("true".equals(System.getProperty(SAUCE_DOWNLOAD_SCRIPT_PROPERTY, "false"))) {
            try {
                String dir = this.determineSaveDir(className, testName);
                String resources = "mkdir " + dir + " ; cd " + dir + " ; \n" + this.curlSaveResourceString(className, testName, "selenium-server.log") + " ; \n" + this.curlSaveResourceString(className, testName, "video.flv") + " ; \n" + "cd ../\n";
                System.out.println(resources);
                this.writeFile("SauceLabsResources" + dir + ".sh", resources);
            }
            catch (Exception e) {
                System.out.println("Exception while writing SauceLabsResources.sh " + e.getMessage());
                System.out.println(this.curlSaveResourceString(className, testName, "selenium-server.log"));
                System.out.println(this.curlSaveResourceString(className, testName, "video.flv"));
            }
        }
    }

    public void tearDown(boolean passed, String sessionId, String className, String testName) throws Exception {
        if (sessionId != null && System.getProperty(REMOTE_DRIVER_SAUCELABS_PROPERTY) != null) {
            SauceREST client = new SauceREST(System.getProperty(SAUCE_USER_PROPERTY), System.getProperty(SAUCE_KEY_PROPERTY));
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("passed", passed);
            updates.put("build", System.getProperty(SAUCE_BUILD_PROPERTY, "unknown"));
            client.updateJobInfo(sessionId, updates);
            if (passed) {
                client.jobPassed(sessionId);
            } else {
                client.jobFailed(sessionId);
            }
            Thread.sleep(Integer.parseInt(System.getProperty(SAUCE_REST_API_DELAY_MS, "5000")));
            this.downloadResults(className, testName);
        }
    }

    private String curlSaveResourceString(String className, String testName, String resource) {
        return "curl -o " + this.deriveResourceBaseNames(className, testName, resource) + " -u " + this.authentication.getUsername() + ":" + this.authentication.getAccessKey() + " " + this.resourceUrl(resource);
    }

    private String resourceUrl(String resource) {
        return "http://saucelabs.com/rest/" + this.authentication.getUsername() + "/jobs/" + this.sessionId + "/results/" + resource;
    }

    private String deriveResourceBaseNames(String className, String testName, String resource) {
        return className + "." + testName + "-" + System.getProperty(SAUCE_PLATFORM_PROPERTY, Platform.UNIX.toString()) + "-" + System.getProperty(SAUCE_BROWSER_PROPERTY) + "-" + System.getProperty(SAUCE_VERSION_PROPERTY) + "-" + System.getProperty("remote.public.user", "admin") + "-" + System.getProperty(SAUCE_BUILD_PROPERTY, "unknown_build") + "-" + AutomatedFunctionalTestUtils.DTS + "-" + resource;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private String wgetnSaveResourceString(String className, String testName) {
        String dir = this.determineSaveDir(className, testName);
        return "wgetn https://saucelabs.com/" + this.sessionId + "/%04dscreenshot.png 0 50";
    }

    private String determineSaveDir(String className, String testName) {
        String dir = this.deriveResourceBaseNames(className, testName, "");
        dir = dir.substring(0, dir.length() - 1);
        return dir;
    }

    private void writeFile(String fileName, String content) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.flush();
        bw.close();
    }
}

