/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.kuali.rice.testtools.selenium.WebDriverLegacyITBase;
import org.openqa.selenium.By;

public abstract class WebDriverFileResourceAftBase
extends WebDriverLegacyITBase {
    protected List<File> fileUploadList;

    protected String[] getResourceListing(Class clazz, String pathStartsWith) throws Exception {
        String classPath = clazz.getName().replace(".", "/") + ".class";
        URL dirUrl = clazz.getClassLoader().getResource(classPath);
        if (!"jar".equals(dirUrl.getProtocol())) {
            throw new UnsupportedOperationException("Cannot list files for URL " + dirUrl);
        }
        String jarPath = dirUrl.getPath().substring(5, dirUrl.getPath().indexOf("!"));
        JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        HashSet<String> result = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String entry = entries.nextElement().getName();
            if (!entry.startsWith(pathStartsWith) || entry.endsWith("/")) continue;
            result.add(entry);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void setUpFiles(String path, String fileExtension) throws Exception {
        this.fileUploadList = new ArrayList<File>();
        File dir = new File(path);
        if (dir != null && dir.listFiles().length > 0) {
            Integer i = 1;
            for (File file : dir.listFiles()) {
                if (file.getName().endsWith(fileExtension)) {
                    this.fileUploadList.add(file);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        } else {
            throw new Exception("----Resources not found----");
        }
        Collections.sort(this.fileUploadList);
    }

    protected void setUpResourceDir(String resourceDir) {
        this.setUpResourceDir(resourceDir, "txt");
    }

    protected void setUpResourceDir(String resourceDir, String fileExtension) {
        try {
            this.setUpFiles("src/test/resources/" + resourceDir, fileExtension);
        }
        catch (Exception e) {
            System.out.println("Problem loading files from filesystem ( " + e.getMessage() + "). If running from Intellij make sure working directory is " + "rice-framework/krad-sampleapp/web attempt to load as resource.");
            try {
                this.setUpResourceFiles(resourceDir);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.jiraAwareFail("Problems loading files as resources " + e1.getMessage());
            }
        }
    }

    protected void setUpResourceFiles(String resourceDir) throws Exception {
        String[] resources = this.getResourceListing(this.getClass(), resourceDir);
        this.fileUploadList = new ArrayList<File>();
        for (String resource : resources) {
            InputStream inputStream = this.getClass().getResourceAsStream(resource);
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + resource);
            FileOutputStream outputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            this.fileUploadList.add(file);
        }
        Collections.sort(this.fileUploadList);
    }

    protected void fileIngesterBy(By by) {
        if (this.fileUploadList != null && this.fileUploadList.size() > 0) {
            for (File file : this.fileUploadList) {
                String path = file.getAbsolutePath().toString();
                this.driver.findElement(by).sendKeys(new CharSequence[]{path});
            }
        }
    }

    protected void fileIngesterByName(String name) {
        this.fileIngesterBy(By.name((String)name));
    }

    protected void fileIngesterCollection() throws Exception {
        this.fileIngesterBy(By.xpath((String)"//div[@data-label='Attached File']/fieldset/div/div/input[@type='file']"));
    }
}

