/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.kuali.rice.testtools.common.JiraAwareFailable;
import org.kuali.rice.testtools.common.JiraAwareFailureUtils;
import org.kuali.rice.testtools.common.PropertiesUtils;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.kuali.rice.testtools.selenium.WebDriverAftBase;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

@Deprecated
public abstract class WebDriverLegacyITBase
extends WebDriverAftBase {
    public static final String ADMINISTRATION_LINK_TEXT = "Administration";
    public static final String AGENDA_LOOKUP_LINK_TEXT = "Agenda Lookup";
    public static final String BACKDOOR_ID_TEXT = "backdoorId";
    public static final String BACKDOOR_LOGIN_BUTTON_XPATH = "//input[@title='Click to login.']";
    public static final String BLANKET_APPROVE_NAME = "methodToCall.blanketApprove";
    public static final String CANCEL_NAME = "methodToCall.cancel";
    public static final String CANCEL2_XPATH = "//a[contains(text(), 'ancel')]";
    public static final String CANCEL3_XPATH = "//a[@title='cancel']";
    public static final String CLOSE_WINDOW_XPATH_TITLE = "//*[@title='close this window']";
    public static final String COLLECTIONS_LINK_TEXT = "Collections";
    public static final String CONFIGURATION_VIEW_WINDOW_TITLE = "Kuali :: Configuration Test View";
    public static final String CONFIGURATION_VIEW_XPATH = "(//a[contains(text(),'Configuration Test View')])";
    public static final String COPY_LINK_TEXT = "copy";
    public static final String CREATE_NEW_DOCUMENT_NOT_SUBMITTED_SUCCESSFULLY_MESSAGE_TEXT = "New Document not submitted successfully";
    public static final String CREATE_NEW_XPATH = "//img[@alt='create new']";
    public static final String CREATE_NEW_XPATH2 = "//a[@title='Create a new record']";
    public static final String DATA_TABLE_TR_CSS = "div.dataTables_wrapper tbody tr";
    public static final String DIV_ERROR_LOCATOR = "//div[@class='error']";
    public static final String DIV_ERROR_LOCATOR_KRAD = "//div[@class='alert alert-danger']/ul";
    public static final String DIV_EXCOL_LOCATOR = "//div[@class='msg-excol']";
    public static final String DIV_LEFT_ERRMSG = "//div[@class='left-errmsg-tab']/div/div";
    public static final String DOC_CODE_XPATH = "//input[@id='document.newMaintainableObject.code']";
    public static final String DOC_ID_XPATH = "//div[@id='headerarea']/div/table/tbody/tr[1]/td[1]";
    public static final String DOC_ID_KRAD_XPATH = "//div[@data-label=\"Document Number\"]";
    public static final String DOC_ID_XPATH_2 = "//table[@id='row']/tbody/tr[1]/td[1]";
    public static final String DOC_ID_XPATH_3 = "//table[@id='row']/tbody/tr[1]/td[1]/a";
    public static final String DOC_DESCRIPTION_XPATH = "//input[@id='document.documentHeader.documentDescription']";
    public static final String DOC_INITIATOR_XPATH = "//div[@id='headerarea']/div/table/tbody/tr[2]/td[1]";
    public static final String DOC_SEARCH_XPATH = "//img[@alt='doc search']";
    public static final String DOC_SEARCH_XPATH_TITLE = "//a[@title='Document Search']";
    public static final String DOC_STATUS_ENROUTE = "ENROUTE";
    public static final String DOC_STATUS_FINAL = "FINAL";
    public static final String DOC_STATUS_SAVED = "SAVED";
    public static final String DOC_STATUS_XPATH = "//table[@class='headerinfo']//tr[1]/td[2]";
    public static final String DOC_STATUS_XPATH_2 = "//table[@id='row']/tbody/tr[1]/td[4]";
    public static final String DOC_SUBMIT_SUCCESS_MSG_XPATH = "//div[contains(div,'Document was successfully submitted.')]";
    public static final String EDIT_LINK_TEXT = "edit";
    public static final String IFRAMEPORTLET_NAME = "iframeportlet";
    public static final String KITCHEN_SINK_XPATH = "(//a[contains(text(),'Uif Components (Kitchen Sink)')])";
    public static final String KRAD_XPATH = "KRAD";
    public static final String KUALI_COLLECTION_TOTALLING_WINDOW_XPATH = "Kuali :: Collection Totaling";
    public static final String KUALI_COLLECTION_TOTALLING_XPATH = "//a[text()='Collection Totaling']";
    public static final String KUALI_UIF_COMPONENTS_WINDOW_XPATH = "Kuali :: Uif Components";
    public static final String KUALI_VIEW_WINDOW_TITLE = "Kuali :: View Title";
    public static final String LABEL_KUALI_KUALI_SYSTEMS = "KUALI - Kuali Systems";
    public static final String LABEL_KUALI_DEFAULT = "KUALI : Default";
    public static final String LOGOUT_XPATH = "//input[@name='imageField' and @value='Logout']";
    public static final String MAIN_MENU_LINK_TEXT = "Main Menu";
    public static final String RICH_MESSAGES_WINDOW_TITLE = "Kuali :: Rich Messages";
    public static final String SAVE_SUCCESSFUL_XPATH = "//div[contains(div,'Document was successfully saved.')]";
    public static final String SAVE_XPATH = "//input[@name='methodToCall.save' and @alt='save']";
    public static final String SAVE_XPATH_2 = "//*[@name='methodToCall.save' and @alt='save']";
    public static final String RELOAD_XPATH = "//*[@name='methodToCall.reload' and @alt='reload']";
    public static final String SAVE_XPATH_3 = "//input[@title='search' and @name='methodToCall.search']";
    public static final String SEARCH = "Search";
    public static final String SEARCH_XPATH = "//input[@name='methodToCall.search' and @value='search']";
    public static final String SEARCH_XPATH_2 = "//input[@value='search']";
    public static final String SEARCH_SECOND = "(//input[@name='methodToCall.search'])[2]";
    public static final String SUBMIT_XPATH = "//input[@name='methodToCall.route' and @alt='submit']";
    public static final String APPROVE_XPATH = "//input[@name='methodToCall.approve' and @alt='approve']";
    public static final String DISAPPROVE_XPATH = "//input[@name='methodToCall.disapprove' and @alt='disapprove']";
    public static final String ACKNOWLEDGE_XPATH = "//input[@name='methodToCall.acknowledge' and @alt='acknowledge']";
    public static final String CLOSE_XPATH = "//input[@name='methodToCall.close' and @alt='close']";
    public static final String TRAVEL_ACCOUNT_LOOKUP_LINK_TEXT = "Travel Account Lookup";
    public static final String UIF_COMPONENTS_KITCHEN_SINK_LINK_TEXT = "Uif Components (Kitchen Sink)";
    public static final String VALIDATION_FRAMEWORK_DEMO_XPATH = "(//a[contains(text(),'Validation Framework Demo')])";
    public static final String XML_INGESTER_LINK_TEXT = "XML Ingester";
    public static final String FISCAL_OFFICER_INFO_MAINTENANCE_NEW_XPATH = "//a[@title='FiscalOfficerInfo Maintenance (New)']";
    protected String namespaceCode = "KR-WKFLW";
    protected String uiFramework = "KNS";
    private static final Map<String, String> actionRequestLabelMap;
    private static Map<String, String> actionRequestButtonMap;

    @Override
    @Before
    public void testSetUp() {
        super.testSetUp();
    }

    @Override
    protected String getTestUrl() {
        String testUrl = super.getTestUrl();
        if (testUrl.contains("&hideReturnLink=true") && !testUrl.contains("&showMaintenanceLinks=true")) {
            testUrl = testUrl + "&showMaintenanceLinks=true";
        }
        return testUrl;
    }

    protected void impersonateUser(String user) throws InterruptedException {
        this.waitAndTypeByName(BACKDOOR_ID_TEXT, user);
        this.jGrowl("Click Backdoor Login");
        this.waitAndClickByXpath(BACKDOOR_LOGIN_BUTTON_XPATH);
    }

    protected void addAdHocRecipientsGroup(String[] adHocRecipients) throws InterruptedException {
        this.addAdHocRecipientsGroup(new String[][]{adHocRecipients});
    }

    protected void addAdHocRecipientsGroup(String[][] adHocRecipients) throws InterruptedException {
        String today = this.getDateToday();
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.add(1, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String nextYear = sdf.format(nextYearCal.getTime());
        this.waitAndClickByName("methodToCall.toggleTab.tabAdHocRecipients");
        int s = adHocRecipients.length;
        for (int i = 0; i < s; ++i) {
            this.selectOptionByName("newAdHocRouteWorkgroup.actionRequested", adHocRecipients[i][1]);
            this.waitAndTypeByName("newAdHocRouteWorkgroup.recipientName", adHocRecipients[i][0]);
            this.waitAndTypeByName("newAdHocRouteWorkgroup.recipientNamespaceCode", adHocRecipients[i][2]);
            WebDriverUtils.jGrowl(this.getDriver(), "Click Add Group", false, "Click Add Group");
            this.waitAndClickByName("methodToCall.insertAdHocRouteWorkgroup");
        }
    }

    protected void addAdHocRecipientsPerson(String[] adHocRecipients) throws InterruptedException {
        this.addAdHocRecipientsPerson(new String[][]{adHocRecipients});
    }

    protected void addAdHocRecipientsPerson(String[][] adHocRecipients) throws InterruptedException {
        String today = this.getDateToday();
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.add(1, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String nextYear = sdf.format(nextYearCal.getTime());
        if (!this.isVisible(By.name((String)"newAdHocRoutePerson.actionRequested"))) {
            this.waitAndClickByName("methodToCall.toggleTab.tabAdHocRecipients");
        }
        int s = adHocRecipients.length;
        for (int i = 0; i < s; ++i) {
            this.selectOptionByName("newAdHocRoutePerson.actionRequested", adHocRecipients[i][1]);
            this.waitAndTypeByName("newAdHocRoutePerson.id", adHocRecipients[i][0]);
            WebDriverUtils.jGrowl(this.getDriver(), "Click Add Person", false, "Click Add Person");
            this.waitAndClickByName("methodToCall.insertAdHocRoutePerson");
        }
    }

    protected void agendaLookupAssertions() throws Exception {
        this.testLookUp();
        this.assertTextPresent("Rules");
        this.waitAndClickCancelByText();
    }

    protected void assertActionList(String docId, String actionListOptionValue, String state) throws InterruptedException {
        this.selectTopFrame();
        this.waitAndClickActionList();
        this.selectFrameIframePortlet();
        while (!this.waitForIsTextPresent(docId)) {
            this.waitAndClickByLinkText("Next");
        }
        WebElement docIdTr = this.findElement(By.xpath((String)("//table/tbody/tr/td/a[contains(text(), '" + docId + "')]/../..")));
        this.assertTrue(docIdTr.getText() + " does not contain " + docId, docIdTr.getText().contains(docId));
        this.assertTrue(docIdTr.getText() + " does not contain " + state, docIdTr.getText().contains(state));
        this.assertTrue(docIdTr.getText() + " does not contain " + actionRequestLabelMap.get(actionListOptionValue), docIdTr.getText().contains(actionRequestLabelMap.get(actionListOptionValue)));
        this.waitAndClickLinkContainingText(docId);
        this.selectChildWindow();
        this.waitAndClickByName(actionRequestButtonMap.get(actionListOptionValue));
        if ("D".equals(actionListOptionValue)) {
            this.waitAndTypeByName("reason", "disapproved for AFT");
            this.jGrowl("Click yes button");
            this.waitAndClickByName("methodToCall.processAnswer.button0");
        } else if ("C".equals(actionListOptionValue) || "CR".equals(actionListOptionValue)) {
            this.waitAndClickByName("methodToCall.close");
        }
        this.waitForTextNotPresent(docId);
    }

    protected void assertNotInActionList(String docId) throws InterruptedException {
        this.selectTopFrame();
        this.waitAndClickActionList();
        this.selectFrameIframePortlet();
        this.waitForTextNotPresent(docId);
        while (this.isElementPresentByLinkText("Next")) {
            this.waitAndClickByLinkText("Next");
            this.waitForTextNotPresent(docId);
        }
    }

    protected void assertOutbox(String docId, String state) throws InterruptedException {
        this.waitAndClickLinkContainingText("Outbox");
        while (!this.waitForIsTextPresent(docId)) {
            this.waitAndClickByLinkText("Next");
        }
        WebElement docIdTr = this.findElement(By.xpath((String)("//table/tbody/tr/td/a[contains(text(), '" + docId + "')]/../..")));
        this.assertTrue("Outbox items " + docIdTr.getText() + " does not contain " + docId, docIdTr.getText().contains(docId));
        this.assertTrue("Outbox items " + docIdTr.getText() + " state is incorrect " + state, docIdTr.getText().contains(state));
        this.waitForTextPresent(docId);
    }

    protected void assertBlanketApproveButtonsPresent() {
        this.assertElementPresentByName("methodToCall.route");
        this.assertElementPresentByName("methodToCall.save");
        this.assertElementPresentByName(BLANKET_APPROVE_NAME, "Blanket Approve button not present does " + this.user + " have permssion?");
        this.assertElementPresentByName("methodToCall.close");
        this.assertElementPresentByName(CANCEL_NAME);
    }

    protected void assertDocFinal(String docId) throws InterruptedException {
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
    }

    protected void assertDocSearch(String docId, String docStatus) throws InterruptedException {
        this.docSearch(docId);
        this.waitForElementPresentByXpath(DOC_ID_XPATH_3);
        this.jGrowl("Is doc status for docId: " + docId + " " + docStatus + "?");
        this.acceptAlertIfPresent();
        this.assertEquals(docId, this.getTextByXpath(DOC_ID_XPATH_3));
        this.assertEquals(docStatus, this.getTextByXpath(DOC_STATUS_XPATH_2));
    }

    protected void docSearch(String docId) throws InterruptedException {
        this.selectParentWindow();
        this.selectTopFrame();
        this.waitAndClickDocSearchTitle();
        this.acceptAlertIfPresent();
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("documentId", docId);
        this.waitAndClickSearch();
    }

    protected void assertDocSearchNoResults(String docId) throws InterruptedException {
        this.docSearch(docId);
        this.waitForTextPresent("No values match this search.");
    }

    protected void assertRouteStatus(String status) throws InterruptedException {
        this.waitForElementPresentByXpath("//th[contains(.,'Route Status')]/../following-sibling::*/td[contains(.,'" + status + "')]");
    }

    protected void assertTableLayout() throws Exception {
        this.waitForTextPresent("Actions");
        String pageSource = this.driver.getPageSource();
        this.assertTrue(pageSource.contains("Table Layout"));
        this.assertTrue(pageSource.contains("Field 1"));
        this.assertTrue(pageSource.contains("Field 2"));
        this.assertTrue(pageSource.contains("Field 3"));
        this.assertTrue(pageSource.contains("Field 4"));
        this.assertTrue(pageSource.contains("Actions"));
    }

    protected void blanketApproveAssert(String docId) throws InterruptedException {
        this.checkForDocError();
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
    }

    protected void blanketApproveCheck() throws InterruptedException {
        this.waitAndClickBlanketApproveKns();
        this.checkForIncidentReport();
    }

    public static String blanketApprovalCleanUpErrorText(String errorText) {
        errorText = errorText.replace("* required field", "").replace("\n", " ").trim();
        return errorText;
    }

    protected void blanketApproveTest(String docId) throws InterruptedException {
        this.jGrowl("Click Blanket Approve");
        this.waitAndClickBlanketApproveKns();
        Thread.sleep(2000L);
        this.checkForIncidentReport();
        this.blanketApproveAssert(docId);
    }

    protected void blanketApproveSuccessfully() throws InterruptedException {
        this.waitAndClickBlanketApprove();
        this.waitAndClickConfirmBlanketApproveOk();
        this.acceptAlertIfPresent();
        this.waitForProgressLoading();
        this.checkForDocErrorKrad();
        this.waitForTextPresent("Document was successfully approved.");
    }

    protected void failOnErrorMessageItem() {
        this.failOnErrorMessageItem(this.getClass().getName());
    }

    protected void failOnErrorMessageItem(String message) {
        String error_locator = "//li[@class='uif-errorMessageItem']";
        if (this.findElements(By.xpath((String)"//li[@class='uif-errorMessageItem']")).size() > 0) {
            String errorText = null;
            try {
                errorText = this.getTextByXpath("//li[@class='uif-errorMessageItem']");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (errorText != null && errorText.contains("errors")) {
                this.jiraAwareFail((errorText + " " + message).trim());
            }
        }
    }

    public void checkForDocError() {
        if (this.hasDocError()) {
            String errorText = this.extractErrorText();
            this.jiraAwareFail(errorText);
        }
    }

    public void checkForDocErrorKrad() {
        if (this.hasDocErrorKrad()) {
            String errorText = this.extractErrorTextKrad();
            this.jiraAwareFail(errorText);
        }
    }

    protected String extractErrorText() {
        String errorText = this.driver.findElement(By.xpath((String)DIV_ERROR_LOCATOR)).getText();
        errorText = WebDriverLegacyITBase.blanketApprovalCleanUpErrorText(errorText);
        if (this.driver.findElements(By.xpath((String)DIV_EXCOL_LOCATOR)).size() > 0) {
            errorText = WebDriverLegacyITBase.blanketApprovalCleanUpErrorText(this.driver.findElement(By.xpath((String)DIV_EXCOL_LOCATOR)).getText());
        }
        if (this.driver.findElements(By.xpath((String)DIV_LEFT_ERRMSG)).size() > 0) {
            errorText = errorText + WebDriverLegacyITBase.blanketApprovalCleanUpErrorText(this.driver.findElement(By.xpath((String)DIV_LEFT_ERRMSG)).getText());
        }
        return errorText;
    }

    protected String extractErrorTextKrad() {
        return this.driver.findElement(By.xpath((String)DIV_ERROR_LOCATOR_KRAD)).getText();
    }

    public boolean hasDocError() {
        String errorText;
        this.acceptAlertIfPresent();
        return this.driver.findElements(By.xpath((String)DIV_ERROR_LOCATOR)).size() > 0 && (errorText = this.driver.findElement(By.xpath((String)DIV_ERROR_LOCATOR)).getText()) != null && errorText.contains("error(s) found on page.");
    }

    public boolean hasDocErrorKrad() {
        String errorText;
        return this.driver.findElements(By.xpath((String)DIV_ERROR_LOCATOR_KRAD)).size() > 0 && (errorText = this.driver.findElement(By.xpath((String)DIV_ERROR_LOCATOR_KRAD)).getText()) != null && !errorText.equals("");
    }

    public boolean hasDocError(String errorTextToMatch) {
        WebElement errorDiv;
        String errorText;
        if (this.driver.findElements(By.xpath((String)DIV_ERROR_LOCATOR)).size() > 0 && (errorText = this.driver.findElement(By.xpath((String)DIV_ERROR_LOCATOR)).getText()) != null && errorText.contains("error(s) found on page.") && (errorDiv = this.driver.findElement(By.xpath((String)"//div[@class='left-errmsg']/div[2]/div"))) != null) {
            errorText = errorDiv.getText();
            return errorText != null && errorText.contains(errorTextToMatch);
        }
        return false;
    }

    protected String configNameSpaceBlanketApprove() throws Exception {
        String docId = this.waitForDocId();
        String dtsPlusTwoChars = AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Validation Test Namespace " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomCharsNot9Digits());
        this.assertBlanketApproveButtonsPresent();
        this.waitAndTypeByXpath(DOC_CODE_XPATH, "VTN" + dtsPlusTwoChars);
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.name']", "Validation Test NameSpace " + dtsPlusTwoChars);
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.applicationId']", "RICE");
        return docId;
    }

    protected void contextLookupAssertions() throws Exception {
        this.testLookUp();
        this.assertTextPresent("Notes and Attachments");
        this.jGrowl("Click Cancel");
        this.waitAndClickByXpath("//button[@data-performDirtyValidation=\"true\"]");
    }

    protected void expandColapseByXpath(String clickLocator, String visibleLocator) throws InterruptedException {
        this.waitAndClickByXpath(clickLocator);
        this.waitIsVisibleByXpath(visibleLocator);
        this.waitAndClickByXpath(clickLocator);
        this.waitNotVisibleByXpath(visibleLocator);
    }

    protected String getDocStatus() {
        return this.findElement(By.xpath((String)DOC_STATUS_XPATH_2)).getText();
    }

    protected void gotoNestedFrame() {
        this.driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        this.driver.switchTo().defaultContent();
        String iframeXpath = "//iframe";
        this.gotoIframeByXpath("//iframe");
        this.gotoIframeByXpath("//iframe");
        this.driver.manage().timeouts().implicitlyWait((long)this.waitSeconds, TimeUnit.SECONDS);
    }

    @Override
    protected void logout() throws InterruptedException {
        this.selectTopFrame();
        if (this.isElementPresentByXpath(LOGOUT_XPATH)) {
            this.waitAndClickLogout(this);
        }
    }

    protected void lookupDocByWildcardedUniqueStringName() throws InterruptedException {
        this.open(this.getBaseUrlString() + this.getBookmarkUrl());
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("name", "*" + this.uniqueString);
        this.waitAndClickSearch();
    }

    protected boolean noAffilication() {
        return !this.isElementPresentByName("document.affiliations[0].dflt");
    }

    protected void recall(boolean cancel) throws InterruptedException {
        this.waitAndClickByName("methodToCall.recall");
        this.waitForTextPresent("the reason below");
        this.waitAndTypeByName("reason", "Recall " + this.uniqueString);
        if (cancel) {
            this.waitAndClickByName("methodToCall.processAnswer.button1");
            this.waitForTextPresent("RECALLED");
            this.waitAndClickByName("methodToCall.close");
        } else {
            this.waitAndClickByName("methodToCall.processAnswer.button0");
            this.waitForTextPresent(DOC_STATUS_SAVED);
            this.waitAndClickByName("methodToCall.close");
            this.waitAndClickByName("methodToCall.processAnswer.button1");
        }
    }

    protected void saveSuccessfully() throws InterruptedException {
        this.saveSuccessfully(WebDriverUtils.configuredImplicityWait() * 4);
    }

    protected void saveSuccessfully(int secondsToWait) throws InterruptedException {
        this.waitAndClickSaveByText();
        this.waitForProgressSaving(secondsToWait);
        this.checkForDocErrorKrad();
        this.waitForTextPresent("Document was successfully saved.");
    }

    protected void selectFrameIframePortlet() {
        this.selectFrame(IFRAMEPORTLET_NAME);
    }

    protected void selectFrame(String locator) {
        if (IFRAMEPORTLET_NAME.equals(locator)) {
            this.gotoNestedFrame();
        } else {
            WebDriverUtils.selectFrameSafe(this.driver, locator);
        }
    }

    protected void submitSuccessfully() throws InterruptedException {
        this.submitSuccessfully(WebDriverUtils.configuredImplicityWait() * 4);
    }

    protected void submitSuccessfully(int loadingSeconds) throws InterruptedException {
        this.waitAndClickSubmitByText();
        this.waitAndClickConfirmSubmitOk();
        this.waitForProgressLoading(loadingSeconds);
        Thread.sleep(500L);
        this.checkForDocError();
        this.checkForDocErrorKrad();
        this.waitForTextPresent("Document was successfully submitted.");
    }

    protected void testAddingBrownGroup() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.waitForDocId();
        String random = org.apache.commons.lang.RandomStringUtils.randomNumeric((int)4);
        String organizationDocumentNumber = "ORD" + random;
        String groupDescription = "GD" + random;
        String groupName = "BrownGroup " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        String nameSpace = "KR-IDM";
        String today = this.getDateToday();
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.add(1, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String nextYear = sdf.format(nextYearCal.getTime());
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Adding Brown Group");
        this.waitAndTypeByName("document.documentHeader.explanation", "I want to add Brown Group to test KIM");
        this.waitAndTypeByName("document.documentHeader.organizationDocumentNumber", organizationDocumentNumber);
        this.selectOptionByName("document.groupNamespace", nameSpace);
        this.waitAndTypeByName("document.groupName", groupName);
        this.waitAndTypeByName("document.groupDescription", groupDescription);
        this.checkByName("document.active");
        this.waitAndClickByXpath(SAVE_XPATH_2);
        this.waitForTextPresent("Document was successfully saved.");
    }

    protected void testAddingBrownGroupSubmit() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.waitForDocId();
        String random = org.apache.commons.lang.RandomStringUtils.randomNumeric((int)4);
        String organizationDocumentNumber = "ORD" + random;
        String groupDescription = "GD" + random;
        String groupName = "BrownGroup " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        String nameSpace = "KR-IDM";
        String today = this.getDateToday();
        this.acceptAlertIfPresent();
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.add(1, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String nextYear = sdf.format(nextYearCal.getTime());
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Adding Brown Group");
        this.waitAndTypeByName("document.documentHeader.explanation", "I want to add Brown Group to test KIM");
        this.waitAndTypeByName("document.documentHeader.organizationDocumentNumber", organizationDocumentNumber);
        this.selectOptionByName("document.groupNamespace", nameSpace);
        this.waitAndTypeByName("document.groupName", groupName);
        this.waitAndTypeByName("document.groupDescription", groupDescription);
        this.checkByName("document.active");
        this.waitAndClickByXpath(SUBMIT_XPATH);
    }

    protected void testAddingBrownGroupSaveSubmit() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.waitForDocId();
        String random = org.apache.commons.lang.RandomStringUtils.randomNumeric((int)4);
        String organizationDocumentNumber = "ORD" + random;
        String groupDescription = "GD" + random;
        String groupName = "BrownGroup " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        String nameSpace = "KR-IDM";
        String today = this.getDateToday();
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.add(1, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String nextYear = sdf.format(nextYearCal.getTime());
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Adding Brown Group");
        this.waitAndTypeByName("document.documentHeader.explanation", "I want to add Brown Group to test KIM");
        this.waitAndTypeByName("document.documentHeader.organizationDocumentNumber", organizationDocumentNumber);
        this.selectOptionByName("document.groupNamespace", nameSpace);
        this.waitAndTypeByName("document.groupName", groupName);
        this.waitAndTypeByName("document.groupDescription", groupDescription);
        this.waitAndClickByXpath(SAVE_XPATH_2);
        this.waitForTextPresent("Document was successfully saved.");
        this.waitAndClickByXpath(SUBMIT_XPATH);
        this.waitForTextPresent("Document was successfully submitted.");
    }

    protected void testAttributeDefinitionLookUp() throws Exception {
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//button[contains(.,'earch')]");
        Thread.sleep(3000L);
        this.waitForPageToLoad();
        this.findElement(By.tagName((String)"body")).getText().contains("Actions");
        this.waitAndClickByLinkText("1000");
        this.waitForPageToLoad();
        this.findElement(By.tagName((String)"body")).getText().contains("Attribute Inquiry");
        this.findElement(By.tagName((String)"body")).getText().contains("KRMS Attributes");
        this.findElement(By.tagName((String)"body")).getText().contains("Attribute Label");
        this.findElement(By.tagName((String)"body")).getText().contains("1000");
        this.findElement(By.tagName((String)"body")).getText().contains("peopleFlowId");
        this.findElement(By.tagName((String)"body")).getText().contains("KR-RULE");
        this.findElement(By.tagName((String)"body")).getText().contains("PeopleFlow");
        this.passed();
    }

    protected String testBlanketApprove() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.assertBlanketApproveButtonsPresent();
        this.createNewLookupDetails();
        this.jGrowl("Click Blanket Approve");
        this.waitAndClickBlanketApproveKns();
        int attempts = 0;
        while (this.hasDocError() && this.extractErrorText().contains("a record with the same primary key already exists.") && ++attempts <= 3) {
            this.uniqueString = null;
            this.jGrowl("record with the same primary key already exists");
            this.createNewEnterDetails();
            this.jGrowl("Click Blanket Approve");
            this.waitAndClickBlanketApproveKns();
        }
        this.checkForIncidentReport();
        this.blanketApproveAssert(docId);
        return docId;
    }

    protected void waitAndClickBlanketApproveKns() throws InterruptedException {
        this.waitAndClickByName(BLANKET_APPROVE_NAME, "No blanket approve button does the user " + this.getUserName() + " have permission?");
        this.waitForProgressLoading();
    }

    protected void testCancelConfirmation() throws InterruptedException {
        this.waitAndCancelConfirmation();
    }

    protected void testCreateDocType() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        this.assertElementPresentByXpath("//*[@name='methodToCall.route' and @alt='submit']", "submit button does not exist on the page");
        String docId = this.waitForDocId();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Creating new Document Type");
        String parentDocType = "//input[@name='methodToCall.performLookup.(!!org.kuali.rice.kew.doctype.bo.DocumentType!!).(((name:document.newMaintainableObject.parentDocType.name,documentTypeId:document.newMaintainableObject.docTypeParentId,))).((`document.newMaintainableObject.parentDocType.name:name,`)).((<>)).(([])).((**)).((^^)).((&&)).((//)).((~~)).(::::;" + this.getBaseUrlString() + "/kr/lookup.do;::::).anchor4']";
        this.waitAndClickByXpath(parentDocType);
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        this.waitAndClickSearch();
        this.waitAndClickReturnValue();
        String docTypeName = "TestDocType" + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitForElementPresentByXpath("//input[@id='document.newMaintainableObject.name']");
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.name']", docTypeName);
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.unresolvedDocHandlerUrl']", "${kr.url}/maintenance.do?methodToCall=docHandler");
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.label']", "Label for " + docTypeName);
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.unresolvedHelpDefinitionUrl']", "default.htm?turl=WordDocuments%2Fdocumenttype.htm");
        this.jGrowl("Click Submit button");
        this.waitAndClickByXpath("//*[@name='methodToCall.route' and @alt='submit']");
        this.checkForIncidentReport();
        this.waitForPageToLoad();
        this.driver.switchTo().defaultContent();
        this.waitAndClickDocSearchTitle();
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("documentId", docId);
        this.waitAndClickSearch();
        this.assertEquals(docId, this.waitForElementPresent(By.xpath((String)DOC_ID_XPATH_2)).getText());
    }

    protected String testCreateNew() throws InterruptedException {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.createNewEnterDetails();
        return docId;
    }

    protected String testCreateNewCancel() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.createNewEnterDetails();
        this.testCancelConfirmation();
        this.assertDocSearchNoResults(docId);
        return docId;
    }

    protected void testCreateNewRequired() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        this.waitAndClickSubmit();
        this.assertTrue(this.waitForElementVisibleBy(By.xpath((String)DIV_ERROR_LOCATOR)).getText().contains(" error(s) found on page."));
    }

    protected String testCreateNewSave() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.createNewEnterDetails();
        this.waitAndClickSave();
        int attempts = 0;
        while (this.hasDocError() && this.extractErrorText().contains("a record with the same primary key already exists.") && ++attempts <= 3) {
            this.uniqueString = null;
            this.jGrowl("record with the same primary key already exists");
            this.createNewEnterDetails();
            this.waitAndClickSave();
        }
        this.checkForDocError();
        this.waitForSuccessfulSaveMessage();
        this.assertDocSearch(docId, DOC_STATUS_SAVED);
        this.waitAndClickRouteLogIcon();
        this.assertRouteStatus(DOC_STATUS_SAVED);
        this.back();
        return docId;
    }

    protected void waitForSuccessfulSaveMessage() throws InterruptedException {
        this.waitForElementVisibleBy(By.xpath((String)SAVE_SUCCESSFUL_XPATH));
    }

    protected String testCreateNewSubmit() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.createNewEnterDetails();
        this.waitAndClickSubmit();
        int attempts = 0;
        while (this.hasDocError() && this.extractErrorText().contains("a record with the same primary key already exists.") && ++attempts <= 3) {
            this.uniqueString = null;
            this.jGrowl("record with the same primary key already exists");
            this.createNewEnterDetails();
            this.waitAndClickSubmit();
        }
        this.checkForDocError();
        this.waitForSuccessfulSubmitMessage();
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.waitAndClickRouteLogIcon();
        this.assertRouteStatus(DOC_STATUS_FINAL);
        this.back();
        return docId;
    }

    protected void waitForSuccessfulSubmitMessage() throws InterruptedException {
        this.waitForElementVisibleBy(By.xpath((String)DOC_SUBMIT_SUCCESS_MSG_XPATH));
    }

    protected String testCreateNewSaveSubmit() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.verifyDocInitiated();
        this.createNewEnterDetails();
        this.waitAndClickSave();
        int attempts = 0;
        while (this.hasDocError() && this.extractErrorText().contains("a record with the same primary key already exists.") && ++attempts <= 3) {
            this.uniqueString = null;
            this.jGrowl("record with the same primary key already exists");
            this.createNewEnterDetails();
            this.waitAndClickSave();
        }
        this.checkForDocError();
        this.waitForSuccessfulSaveMessage();
        this.waitAndClickSubmit();
        this.checkForDocError();
        this.waitForSuccessfulSubmitMessage();
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.waitAndClickRouteLogIcon();
        this.assertRouteStatus(DOC_STATUS_FINAL);
        this.back();
        return docId;
    }

    protected String verifyDocInitiated() throws InterruptedException {
        String docId = this.waitForDocId();
        this.assertEquals("INITIATED", this.waitForDocStatus());
        this.assertEquals(this.getUserName(), this.waitForDocInitiator());
        return docId;
    }

    protected List<String> testCreateNewParameter(String docId, String parameterName) throws Exception {
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Adding Test Parameter");
        this.selectOptionByName("document.newMaintainableObject.namespaceCode", "KR-WKFLW");
        this.waitAndTypeByName("document.newMaintainableObject.componentCode", "ActionList");
        this.waitAndTypeByName("document.newMaintainableObject.applicationId", "KUALI");
        parameterName = "TestIndicator" + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", parameterName);
        this.waitAndTypeByName("document.newMaintainableObject.value", "Y");
        this.waitAndTypeByName("document.newMaintainableObject.description", "for testing");
        this.selectOptionByName("document.newMaintainableObject.parameterTypeCode", "HELP");
        this.waitAndClickByXpath("//input[@name='document.newMaintainableObject.evaluationOperatorCode' and @value='A']");
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterName);
        return params;
    }

    protected List<String> testCreateNewParameterType(String docId, String parameterType, String parameterCode) throws Exception {
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Adding Test Parameter Type");
        parameterCode = org.apache.commons.lang.RandomStringUtils.randomAlphabetic((int)4).toLowerCase();
        this.waitAndTypeByName("document.newMaintainableObject.code", parameterCode);
        parameterType = "testing " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", parameterType);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterType);
        params.add(parameterCode);
        return params;
    }

    protected void testCreateNewSearchReturnValueCancelConfirmation() throws InterruptedException, Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        this.waitAndClickSearch2();
        this.waitAndClickReturnValue();
        this.waitAndCancelConfirmation();
        this.passed();
    }

    protected List<String> testCopyParameter(String docId, String parameterName) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickCopy();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Copying Test Parameter");
        this.selectOptionByName("document.newMaintainableObject.namespaceCode", "KR-WKFLW");
        this.waitAndTypeByName("document.newMaintainableObject.componentCode", "ActionList");
        this.waitAndTypeByName("document.newMaintainableObject.applicationId", "KUALI");
        parameterName = "TestIndicator" + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", parameterName);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterName);
        return params;
    }

    protected List<String> testCopyParameterType(String docId, String parameterType, String parameterCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickCopy();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Copying Test Parameter");
        parameterCode = org.apache.commons.lang.RandomStringUtils.randomAlphabetic((int)4).toLowerCase();
        this.waitAndTypeByName("document.newMaintainableObject.code", parameterCode);
        this.clearTextByName("document.newMaintainableObject.name");
        parameterType = "testing " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", parameterType);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterType);
        params.add(parameterCode);
        return params;
    }

    protected void testDemoCustomRuleEventAndDocumentEventMethodInvocationAccountTypeChec() throws InterruptedException {
        String randomCode = RandomStringUtils.randomAlphabetic((int)9).toUpperCase();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Travel Account Maintenance New Test Document " + randomCode);
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.number", randomCode);
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.name", "Test Account Name " + randomCode);
        this.waitAndClickByXpath("//button[contains(text(),'Submit')]");
        this.assertTravelAccountTypeCodeRequired();
    }

    protected void assertTravelAccountTypeCodeRequired() throws InterruptedException {
        this.waitForTextPresent("Travel Account Type Code: Required");
        this.fireEvent("document.newMaintainableObject.dataObject.accountTypeCode", "focus");
        this.waitForElementVisibleBy(By.xpath((String)"//div[@class='popover top in uif-tooltip-error-cs']"));
        this.fireEvent("document.newMaintainableObject.dataObject.accountTypeCode", "blur");
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.number", "a");
        if (this.isVisibleByXpath("//div[@class='popover top in uif-tooltip-error-cs']")) {
            JiraAwareFailureUtils.fail("Required popup still present", this);
        }
    }

    protected void testDocTypeLookup() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//input[@title='Search Parent Name']");
        this.waitAndClickByXpath(SAVE_XPATH_3);
        this.waitAndClickByXpath("//table[@id='row']/tbody/tr[contains(td[3],'RiceDocument')]/td[1]/a");
        this.waitAndClickByXpath(SAVE_XPATH_3);
        this.assertEquals("RiceDocument", this.getTextByXpath("//table[@id='row']/tbody/tr/td[4]/a"));
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("name", "Kuali*D");
        this.waitAndClickByXpath(SAVE_XPATH_3);
        this.assertElementPresentByXpath("//table[@id='row']/tbody/tr[contains(td[3], 'KualiDocument')]");
        String docIdOld = this.getTextByXpath("//table[@id='row']/tbody/tr[contains(td[3], 'KualiDocument')]/td[2]/a");
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("label", "KualiDocument");
        this.waitAndClickByXpath(SAVE_XPATH_3);
        this.assertElementPresentByXpath("//table[@id='row']/tbody/tr[contains(td[5], 'KualiDocument')]");
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("documentTypeId", docIdOld);
        this.waitAndClickByXpath(SAVE_XPATH_3);
        this.assertElementPresentByXpath("//table[@id='row']/tbody/tr[contains(td[2], '" + docIdOld + "')]");
    }

    protected void testEditCopy(String docId) throws InterruptedException {
        String desc = this.getDescriptionUnique();
        this.jiraAwareTypeByName("document.documentHeader.documentDescription", desc);
        String thisDocId = this.verifyDocInitiated();
        this.assertFalse("Document id should not be the same as original (" + docId + ").", docId.equals(thisDocId));
        this.waitAndClickSave();
        this.waitForSuccessfulSaveMessage();
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.waitAndClickRouteLogIcon();
        this.assertRouteStatus(DOC_STATUS_FINAL);
        this.waitForElementPresentByXpath("//th[contains(.,'Title')]/../following-sibling::*/td[contains(.,'" + desc + "')]");
    }

    protected List<String> testEditParameterType(String docId, String parameterType, String parameterCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickEdit();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Editing Test Parameter");
        this.clearTextByName("document.newMaintainableObject.name");
        parameterType = "testing " + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", parameterType);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterType);
        params.add(parameterCode);
        return params;
    }

    protected List<String> testEditParameter(String docId, String parameterName) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickEdit();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Editing Test Parameter");
        this.clearTextByName("document.newMaintainableObject.value");
        this.waitAndTypeByName("document.newMaintainableObject.value", "N");
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterName);
        return params;
    }

    protected void testEditRouteRulesDelegation() throws Exception {
        this.waitForPageToLoad();
        Thread.sleep(3000L);
        this.assertEquals("Kuali Portal Index", this.getTitle());
        this.selectFrameIframePortlet();
        this.waitAndClickSearch();
        this.waitAndClickEdit();
        this.waitForPageToLoad();
        Thread.sleep(3000L);
        this.assertTrue(this.isElementPresentByName(CANCEL_NAME));
        this.waitAndClickCancel();
        this.waitAndClickByName("methodToCall.processAnswer.button0");
        this.waitForPageToLoad();
        this.passed();
    }

    protected void testFiscalOfficerInfoMaintenanceNew() throws Exception {
        this.selectFrameIframePortlet();
        this.checkForIncidentReport();
        String docId = this.getTextByXpath("//*[@id='u13_control']");
        this.waitAndTypeByXpath("//input[@name='document.documentHeader.documentDescription']", "New FO Doc");
        this.waitAndTypeByXpath("//input[@name='document.newMaintainableObject.dataObject.id']", "5");
        this.waitAndTypeByXpath("//input[@name='document.newMaintainableObject.dataObject.userName']", "Jigar");
        this.waitAndClickByXpath("//button[@id='usave']");
        Integer docIdInt = (int)Integer.valueOf(docId);
        this.waitAndClickActionList();
        this.selectFrameIframePortlet();
        if (this.isElementPresentByLinkText("Last")) {
            this.waitAndClickByLinkText("Last");
            this.waitAndClickByLinkText(docIdInt.toString());
        } else {
            this.waitAndClickByLinkText(docIdInt.toString());
        }
    }

    protected void testIdentityPersonBlanketApprove() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        String docId = this.waitForDocId();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Validation Test Person");
        this.assertBlanketApproveButtonsPresent();
        this.waitAndTypeByXpath("//input[@id='document.principalName']", "principal" + org.apache.commons.lang.RandomStringUtils.randomAlphabetic((int)3).toLowerCase());
        this.selectByName("newAffln.affiliationTypeCode", "Affiliate");
        this.selectByName("newAffln.campusCode", "BX - BLGTN OFF CAMPUS");
        this.selectByName("newAffln.campusCode", "BL - BLOOMINGTON");
        this.assertElementPresentByName("newAffln.dflt");
        this.waitAndClickByName("newAffln.dflt");
        this.waitAndClickByName("methodToCall.addAffln.anchor");
        this.waitAndClickByName("methodToCall.toggleTab.tabContact");
        this.selectByName("newName.namePrefix", "Mr");
        this.waitAndTypeByName("newName.firstName", "First");
        this.waitAndTypeByName("newName.lastName", "Last");
        this.selectByName("newName.nameSuffix", "Mr");
        this.waitAndClickByName("newName.dflt");
        this.waitAndClickByName("methodToCall.addName.anchor");
        this.waitForPageToLoad();
        this.blanketApproveTest(docId);
    }

    protected void testIdentityRoleSaveAndReload() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickSearch2();
        this.waitAndClickByXpath("//a[@title='edit Role withRole=63 ']");
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Test Save and Reload Role ");
        this.assertBlanketApproveButtonsPresent();
        this.waitAndClickByXpath(SAVE_XPATH_2);
        this.waitForTextPresent("Document was successfully saved.");
        this.waitAndClickByXpath(RELOAD_XPATH);
        this.waitForTextPresent("Document was successfully reloaded.");
        this.findElement(By.xpath((String)"//div[@class='tab-container']")).getText().contains("Members:");
        this.passed();
    }

    protected void testIdentityRoleBlanketApprove() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndCreateNew();
        this.waitAndClickByXpath(SEARCH_XPATH, "No search button to click.");
        this.waitAndClickReturnValue();
        String docId = this.waitForDocId();
        String dtsTwo = AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomCharsNot9Digits();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Validation Test Role " + dtsTwo);
        this.assertBlanketApproveButtonsPresent();
        this.selectByXpath("//select[@id='document.roleNamespace']", LABEL_KUALI_KUALI_SYSTEMS);
        this.waitAndTypeByXpath("//input[@id='document.roleName']", "Validation Test Role " + dtsTwo, "No Role Name input to type in.");
        this.waitAndClickByName("methodToCall.performLookup.(!!org.kuali.rice.kim.impl.identity.PersonImpl!!).(((principalId:member.memberId,principalName:member.memberName))).((``)).((<>)).(([])).((**)).((^^)).((&&)).((//)).((~~)).(::::;;::::).anchorAssignees");
        this.waitAndClickByXpath(SEARCH_XPATH, "No search button to click.");
        this.waitAndClickReturnValue();
        this.waitAndClickByName("methodToCall.addMember.anchorAssignees");
        this.waitForPageToLoad();
        this.blanketApproveTest(docId);
    }

    protected void finishBlanketApprovalTest(String docId) throws InterruptedException {
        this.assertBlanketApproveButtonsPresent();
        this.blanketApproveCheck();
        if (!this.hasDocError("same primary key already exists")) {
            this.blanketApproveAssert(docId);
        }
    }

    protected void testLookUp() throws Exception {
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndClick(By.xpath((String)"//button[contains(text(),'earch')]"));
        this.waitAndClickByLinkText(EDIT_LINK_TEXT, "edit button not present does user " + this.user + " have permission?");
        this.waitForTextPresent("ubmit");
        this.assertTextPresent("ave");
        this.assertTextPresent("pprove");
        this.assertTextPresent("lose");
        this.assertTextPresent("ancel");
    }

    protected void testReferenceCampusTypeBlanketApprove() throws Exception {
        this.selectFrameIframePortlet();
        String randomCode = this.searchForAvailableCode(1);
        this.waitAndCreateNew();
        String docId = this.waitForDocId();
        String dtsTwo = AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomCharsNot9Digits();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Validation Test Campus Type " + randomCode + " " + dtsTwo);
        this.waitAndTypeByXpath(DOC_CODE_XPATH, randomCode);
        this.waitAndTypeByXpath("//input[@id='document.newMaintainableObject.name']", "Indianapolis" + randomCode + dtsTwo);
        this.finishBlanketApprovalTest(docId);
    }

    protected void performParameterInquiry(String parameterField) throws Exception {
        this.waitAndTypeByName("name", parameterField);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(parameterField);
        this.waitAndClickByLinkText(parameterField);
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        this.switchToWindow("Kuali :: Inquiry");
        Thread.sleep(2000L);
    }

    protected List<String> testLookUpParameterType(String docId, String parameterType, String parameterCode) throws Exception {
        this.performParameterInquiry(parameterType);
        this.assertEquals(parameterCode, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='code.div']").trim().toLowerCase());
        this.assertEquals(parameterType, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim().toLowerCase());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterType);
        params.add(parameterCode);
        return params;
    }

    protected List<String> testLookUpParameter(String docId, String parameterName) throws Exception {
        this.performParameterInquiry(parameterName);
        this.assertEquals(parameterName, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim());
        this.assertEquals("Y", this.getTextByXpath("//div[@class='tab-container']/table//span[@id='value.div']").trim());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterName);
        return params;
    }

    protected void testTermLookupAssertions() throws Exception {
        this.testLookUp();
        this.assertTextPresent("Term Parameters");
        this.waitAndClick(By.xpath((String)CANCEL2_XPATH));
        this.passed();
    }

    protected void testTermSpecificationLookupAssertions() throws Exception {
        this.testLookUp();
        this.assertTextPresent("Context");
        this.waitAndClickCancelByText();
        this.passed();
    }

    protected List<String> testVerifyModifiedParameter(String docId, String parameterName) throws Exception {
        this.performParameterInquiry(parameterName);
        this.assertEquals(parameterName, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim());
        this.assertEquals("N", this.getTextByXpath("//div[@class='tab-container']/table//span[@id='value.div']").trim());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterName);
        return params;
    }

    protected List<String> testVerifyCopyParameterType(String docId, String parameterType, String parameterCode) throws Exception {
        this.performParameterInquiry(parameterType);
        this.assertEquals(parameterType, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim().toLowerCase());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(parameterType);
        params.add(parameterCode);
        return params;
    }

    protected List<String> testCreateNewPermission(String docId, String permissionName) throws Exception {
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        docId = this.waitForDocId();
        this.waitAndClickSave();
        this.waitForElementPresentByXpath("//div[contains(.,'Document Description (Description) is a required field.')]/img[@alt='error']");
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Adding Permission removeme");
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DIV_ERROR_LOCATOR);
        this.assertElementPresentByXpath("//div[contains(.,'Template (Template) is a required field.')]/img[@alt='error']");
        this.assertElementPresentByXpath("//div[contains(.,'Permission Namespace (Permission Namespace) is a required field.')]/img[@alt='error']");
        this.assertElementPresentByXpath("//div[contains(.,'Permission Name (Permission Name) is a required field.')]/img[@alt='error']");
        this.selectOptionByName("document.newMaintainableObject.templateId", "36");
        this.selectOptionByName("document.newMaintainableObject.namespaceCode", "KR-SYS");
        permissionName = "removeme" + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.newMaintainableObject.name", permissionName);
        this.waitAndTypeByName("document.newMaintainableObject.description", "namespaceCode=KR*");
        this.checkByName("document.newMaintainableObject.active");
        this.waitAndClickSave();
        this.waitForElementPresentByXpath(SAVE_SUCCESSFUL_XPATH);
        this.assertEquals(DOC_STATUS_SAVED, this.getTextByXpath(DOC_STATUS_XPATH));
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertEquals(DOC_STATUS_ENROUTE, this.getTextByXpath(DOC_STATUS_XPATH));
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(permissionName);
        return params;
    }

    protected List<String> testLookUpPermission(String docId, String permissionName) throws Exception {
        this.waitAndTypeByName("name", permissionName);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(permissionName);
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(permissionName);
        return params;
    }

    protected List<String> testEditPermission(String docId, String permissionName) throws Exception {
        this.waitAndClickEdit();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Editing Permission removeme");
        this.uncheckByName("document.newMaintainableObject.active");
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(permissionName);
        return params;
    }

    protected List<String> testVerifyPermission(String docId, String permissionName) throws Exception {
        this.waitAndTypeByName("name", permissionName);
        this.waitAndClickByXpath("//input[@title='Active Indicator - No']");
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(permissionName);
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(permissionName);
        return params;
    }

    protected List<String> testCreateNewPerson(String docId, String personName) throws Exception {
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByXpath(DOC_DESCRIPTION_XPATH, "Adding Charlie Brown");
        this.waitAndTypeByName("document.documentHeader.explanation", "I want to add Charlie Brown to test KIM");
        personName = "cbrown" + AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars();
        this.waitAndTypeByName("document.principalName", personName);
        this.waitAndClickSave();
        this.waitForElementPresentByXpath(SAVE_SUCCESSFUL_XPATH);
        this.assertEquals(DOC_STATUS_SAVED, this.getTextByXpath(DOC_STATUS_XPATH));
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath("//div[contains(.,'At least one affiliation must be entered.')]/img[@alt='error']");
        this.assertElementPresentByXpath("//div[contains(.,'At least one name must be entered.')]/img[@alt='error']");
        this.selectOptionByName("newAffln.affiliationTypeCode", "STDNT");
        this.selectOptionByName("newAffln.campusCode", "BL");
        this.checkByName("newAffln.dflt");
        this.waitAndClickByName("methodToCall.addAffln.anchor");
        this.waitAndSelectByName("newName.nameCode", "PRM");
        this.selectOptionByName("newName.namePrefix", "Mr");
        this.waitAndTypeByName("newName.firstName", "Charlie");
        this.waitAndTypeByName("newName.lastName", "Brown");
        this.checkByName("newName.dflt");
        this.waitAndClickByName("methodToCall.addName.anchor");
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertEquals(DOC_STATUS_ENROUTE, this.getTextByXpath(DOC_STATUS_XPATH));
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(personName);
        return params;
    }

    protected List<String> testLookUpPerson(String docId, String personName) throws Exception {
        this.waitAndTypeByName("principalName", personName);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(personName);
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("firstName", "Charlie");
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(personName);
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("lastName", "Brown");
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(personName);
        this.waitAndClickByName("methodToCall.clearValues");
        this.waitAndTypeByName("campusCode", "BL");
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(personName);
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(personName);
        return params;
    }

    protected List<String> testVerifyPerson(String docId, String personName) throws Exception {
        this.waitAndClickByLinkText(personName);
        this.waitForPageToLoad();
        Thread.sleep(5000L);
        this.switchToWindow("Kuali :: Person");
        Thread.sleep(2000L);
        this.assertEquals(personName, this.getTextByXpath("//div[@class='tab-container']/table//tr[2]/td[1]/div").trim());
        this.assertEquals("BL - BLOOMINGTON", this.getTextByXpath("//div[@class='tab-container']/table[3]//tr[2]/td[2]/div").trim());
        this.assertEquals("Student", this.getTextByXpath("//select/option[@selected]").trim());
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='close Overview']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Contact']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Privacy Preferences']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Membership']");
        this.waitAndClickByName("methodToCall.showAllTabs");
        this.waitForElementPresentByXpath("//table[@class='tab']//input[@title='close Overview']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='close Contact']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='close Privacy Preferences']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='close Membership']");
        this.waitAndClickByName("methodToCall.hideAllTabs");
        this.waitForElementPresentByXpath("//table[@class='tab']//input[@title='open Overview']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Contact']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Privacy Preferences']");
        this.assertElementPresentByXpath("//table[@class='tab']//input[@title='open Membership']");
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList<String> params = new ArrayList<String>();
        params.add(docId);
        params.add(personName);
        return params;
    }

    protected void testConfigurationTestView(String idPrefix) throws Exception {
        this.waitForElementPresentByXpath("//label[@id='" + idPrefix + "TextInputField_label']");
        String styleValue = this.waitAndGetAttributeByXpath("//label[@id='" + idPrefix + "TextInputField_label']", "style");
        this.assertTrue(idPrefix + "textInputField label does not contain expected style", styleValue.replace(" ", "").contains("color:red"));
        String refreshTextSelectLocator = "//select[@id='" + idPrefix + "RefreshTextField_control']";
        String[] options1 = this.getSelectOptionsByXpath(refreshTextSelectLocator);
        String dropDownSelectLocator = "//select[@id='" + idPrefix + "DropDown_control']";
        this.selectByXpath(dropDownSelectLocator, "Vegetables");
        Thread.sleep(3000L);
        String[] options2 = this.getSelectOptionsByXpath(refreshTextSelectLocator);
        this.assertFalse("Field 1 selection did not change Field 2 options https://jira.kuali.org/browse/KULRICE-8163 Configuration Test View Conditional Options doesn't change Field 2 options based on Field 1 selection", options1[options1.length - 1].equalsIgnoreCase(options2[options2.length - 1]));
        this.selectByXpath(dropDownSelectLocator, "None");
        Thread.sleep(3000L);
        this.assertEquals("true", this.waitAndGetAttributeByXpath(refreshTextSelectLocator, "disabled"));
    }

    protected void testCategoryLookUp() throws Exception {
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//button[contains(.,'earch')]");
        Thread.sleep(3000L);
        this.waitForPageToLoad();
        this.findElement(By.tagName((String)"body")).getText().contains("Actions");
    }

    protected void testCreateSampleEDocLite() throws Exception {
        this.waitForPageToLoad();
        Thread.sleep(3000L);
        this.assertEquals("Kuali Portal Index", this.getTitle());
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//input[@name='methodToCall.search' and @alt='search']");
        this.waitForPageToLoad();
        this.waitAndClickByLinkText("Create Document");
        this.waitForPageToLoad();
        Thread.sleep(3000L);
        String docId = this.getTextByXpath("//table/tbody/tr[4]/td[@class='datacell1']");
        this.waitAndTypeByName("userName", "Viral Chauhan");
        this.waitAndTypeByName("rqstDate", "12/03/2020");
        this.checkByName("fundedBy");
        this.waitAndTypeByName("addText", "Note Added.");
        this.waitAndClickByXpath("//td[@class='datacell']/div/img");
        this.waitAndClickByXpath("//input[@value='submit']");
        this.assertEquals(Boolean.FALSE, this.isElementPresentByXpath("//input[@value='submit']"));
        this.assertEquals(Boolean.FALSE, this.isElementPresentByXpath("//input[@value='save']"));
        this.assertEquals(Boolean.FALSE, this.isElementPresentByXpath("//input[@value='cancel']"));
        this.waitForPageToLoad();
        this.selectTopFrame();
        this.waitAndClickDocSearch();
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//input[@name='methodToCall.search' and @alt='search']");
        this.waitForElementPresent(By.linkText((String)docId));
    }

    protected void testTermLookUp() throws Exception {
        this.testLookUp();
        this.assertTextPresent("Term Parameters");
        this.waitAndClickCancelByText();
        this.passed();
    }

    protected void testCreateNewRRDTravelRequestDestRouting() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClick("img[alt=\"create new\"]");
        this.waitAndClickByName("methodToCall.performLookup.(!!org.kuali.rice.kew.rule.RuleBaseValues!!).(((id:parentRuleId))).((``)).((<>)).(([])).((**)).((^^)).((&&)).((//)).((~~)).(::::;;::::).anchor");
        this.waitAndClickByXpath("//td[@class='infoline']/input[@name='methodToCall.search']");
        this.waitAndClick("a[title=\"return valueRule Id=1046 \"]");
        this.waitAndClickByName("parentResponsibilityId");
        this.waitAndClickByName("methodToCall.createDelegateRule");
        this.waitAndClickCancel();
        this.waitAndClickByName("methodToCall.processAnswer.button0");
        this.waitForPageToLoad();
        this.driver.switchTo().defaultContent();
        this.waitAndClickByXpath("(//input[@name='imageField'])[2]");
        this.passed();
    }

    protected void testWorkFlowRouteRulesCreateNew() throws Exception {
        this.waitForPageToLoad();
        Thread.sleep(5000L);
        this.assertEquals("Kuali Portal Index", this.getTitle());
        this.selectFrameIframePortlet();
        this.waitAndClickCreateNew();
        this.waitAndClickByName(CANCEL_NAME, "https://jira.kuali.org/browse/KULRICE-8161 Work Flow Route Rules cancel new yields 404 not found");
        this.waitAndClickByName("methodToCall.processAnswer.button0");
        this.passed();
    }

    protected void testWorkFlowRouteRulesEditRouteRules() throws Exception {
        this.waitForPageToLoad();
        this.assertEquals("Kuali Portal Index", this.getTitle());
        this.selectFrameIframePortlet();
        this.waitAndClickSearch();
        this.waitAndClickEdit();
        this.waitForPageToLoad();
        this.selectFrameIframePortlet();
        this.waitAndClickCancel();
        this.waitAndClickByName("methodToCall.processAnswer.button0");
        this.passed();
    }

    protected void createNewEnterDetails() throws InterruptedException {
        this.fail("createNewEnterDetails must be implemented by test class");
    }

    protected void createNewLookupDetails() throws InterruptedException {
        this.fail("createNewLookupDetails must be implemented by test class");
    }

    protected void waitAndClickActionList() throws InterruptedException {
        WebDriverUtils.jGrowl(this.driver, "Click Action List", false, "Click Action List");
        this.selectTopFrame();
        this.waitAndClickByXpath("//img[@alt='action list']");
    }

    protected void testLookUpComponent(String docId, String componentName, String componentCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("name", componentName);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(componentName);
        this.waitAndClickByLinkText(componentName);
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        this.switchToWindow("Kuali :: Inquiry");
        Thread.sleep(2000L);
        this.assertEquals(componentName, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim());
        this.assertEquals(componentCode, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='code.div']").trim());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
    }

    protected void testEditComponent(String docId, String componentName, String componentCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickEdit();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Editing Test Component");
        this.clearTextByName("document.newMaintainableObject.name");
        this.waitAndTypeByName("document.newMaintainableObject.name", componentName);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
    }

    protected void testCopyComponent(String docId, String componentName, String componentCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickCopy();
        this.waitForPageToLoad();
        docId = this.waitForDocId();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Copying Test Component");
        this.selectOptionByName("document.newMaintainableObject.namespaceCode", "KR-IDM");
        this.waitAndTypeByName("document.newMaintainableObject.code", componentCode);
        this.clearTextByName("document.newMaintainableObject.name");
        this.waitAndTypeByName("document.newMaintainableObject.name", componentName);
        this.waitAndClickSave();
        this.waitAndClickSubmit();
        this.waitForPageToLoad();
        this.checkForDocError();
        this.waitForElementPresentByXpath(DOC_SUBMIT_SUCCESS_MSG_XPATH, "Document is not submitted successfully");
        this.assertDocSearch(docId, DOC_STATUS_FINAL);
        this.selectTopFrame();
    }

    protected void testVerifyCopyComponent(String docId, String componentName, String componentCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("name", componentName);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(componentName);
        this.waitAndClickByLinkText(componentName);
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        this.switchToWindow("Kuali :: Inquiry");
        Thread.sleep(2000L);
        this.assertEquals(componentName, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim());
        this.assertEquals(componentCode, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='code.div']").trim());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
    }

    protected void testMultiValueSelectAllPages() throws InterruptedException {
        this.waitAndClickButtonByText(SEARCH);
        this.assertButtonDisabledByText("return selected");
        this.waitAndClickDropDown("select all items");
        if (!this.areAllMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("select all items failure", this);
        }
        this.assertButtonEnabledByText("return selected");
        boolean anotherPageOfResults = false;
        if (Integer.parseInt(this.multiValueResultCount()) > 10) {
            anotherPageOfResults = true;
        }
        if (!anotherPageOfResults) {
            JiraAwareFailureUtils.fail("select all items server side paging failure not enough results for next page", this);
        }
        this.waitAndClickByLinkText("Next");
        if (!this.areAllMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("select all items server side paging failure", this);
        }
        this.assertButtonEnabledByText("return selected");
        this.waitAndClickDropDown("deselect all items");
        if (!this.areNoMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("deselect all items failure", this);
        }
        this.assertButtonDisabledByText("return selected");
        this.waitAndClickByLinkText("Previous");
        if (!this.areNoMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("deselect all items failure", this);
        }
        this.assertButtonDisabledByText("return selected");
    }

    protected void acceptAlert() {
        if (!WebDriverUtils.isAlertPresent(this.driver)) {
            this.fail("Alert expected but not present for " + this.getClass().getName());
        }
        WebDriverUtils.alertAccept(this.driver);
    }

    protected void testMultiValueSelectAllThisPage() throws InterruptedException {
        this.waitAndClickButtonByText(SEARCH);
        this.assertButtonDisabledByText("return selected");
        this.assertMultiValueSelectAllThisPage();
        boolean anotherPageOfResults = false;
        if (Integer.parseInt(this.multiValueResultCount()) > 5) {
            anotherPageOfResults = true;
        }
        this.waitAndClickByLinkText("Next");
        if (!this.areNoMultiValueSelectsChecked()) {
            if (anotherPageOfResults) {
                JiraAwareFailureUtils.fail("select all items on this page failure", this);
            } else {
                JiraAwareFailureUtils.fail("select all items on this page failure not enough results for next page", this);
            }
        }
        this.assertButtonEnabledByText("return selected");
        this.waitAndClickByLinkText("Previous");
        if (!this.areAllMultiValueSelectsChecked()) {
            JiraAwareFailureUtils.fail("select all items on previous page failure", this);
        }
        this.assertMultiValueDeselectAllThisPage();
    }

    protected void testExternalHelp2() throws Exception {
        this.assertPopUpWindowUrl(By.cssSelector((String)"input[title=\"Help for External Help\"]"), "HelpWindow", "http://www.kuali.org/?section");
        this.assertPopUpWindowUrl(By.xpath((String)"//div[@id='field-label-left-external-help']/fieldset/input[@title='Help for Field Label']"), "HelpWindow", "http://www.kuali.org/?label_left");
        this.assertPopUpWindowUrl(By.xpath((String)"//div[@id='field-label-right-external-help']/fieldset/input[@title='Help for Field Label']"), "HelpWindow", "http://www.kuali.org/?label_right");
        this.assertPopUpWindowUrl(By.xpath((String)"//div[@id='field-label-top-external-help']/fieldset/input[@title='Help for Field Label']"), "HelpWindow", "http://www.kuali.org/?system_parm");
        this.assertPopUpWindowUrl(By.id((String)"standalone-external-help"), "HelpWindow", "http://www.kuali.org/?widget_only");
    }

    protected void testDisplayOnlyExternalHelp2() throws Exception {
        this.assertPopUpWindowUrl(By.cssSelector((String)"input[title=\"Help for Display only fields\"]"), "HelpWindow", "http://www.kuali.org/?sub_section");
        this.assertPopUpWindowUrl(By.xpath((String)"//div[@id='display-field-external-help']/fieldset/input[@title='Help for Field Label']"), "HelpWindow", "http://www.kuali.org/?display_field");
    }

    protected void testMissingExternalHelp2() throws Exception {
        this.assertFalse(this.isElementPresent(By.cssSelector((String)"input[title=\"Help for Missing External Help\"]")));
        this.assertFalse(this.isElementPresentByXpath("//div[@id='external-help-externalHelpUrl-empty']/*[@class='uif-helpImage']"));
        this.assertFalse(this.isElementPresentByXpath("//div[@id='external-help-helpdefinition-empty']/*[@class='uif-helpImage']"));
        this.assertFalse(this.isElementPresentByXpath("//div[@id='external-help-system-parm-missing']/*[@class='uif-helpImage']"));
        this.assertFalse(this.isElementPresentByXpath("//div[@id='standalone-external-help-missing']"));
    }

    private String searchForAvailableCode(int codeLength) throws InterruptedException {
        String randomCode = org.apache.commons.lang.RandomStringUtils.randomAlphabetic((int)codeLength).toUpperCase();
        this.waitAndTypeByName("code", randomCode);
        this.waitAndClickSearch();
        int attemptCount = 1;
        this.waitForTextPresent("You have entered the primary key for this table");
        while (!this.isTextPresent("No values match this search.").booleanValue() && attemptCount < 25) {
            randomCode = Character.toString((char)(randomCode.toCharArray()[0] + attemptCount++));
            this.clearTextByName("code");
            this.waitAndTypeByName("code", randomCode);
            this.waitAndClickSearch();
            this.waitForTextPresent("You have entered the primary key for this table");
        }
        return randomCode;
    }

    protected void testSearchEditCancel() throws InterruptedException {
        this.selectFrameIframePortlet();
        this.waitAndClickSearch2();
        this.waitAndClickEdit();
        this.testCancelConfirmation();
    }

    protected void testServerErrorsIT() throws Exception {
        this.waitAndClickByXpath("//button[contains(.,'Get Error Messages')]");
        this.waitForElementPresent("div[data-messages_for=\"Demo-ValidationLayout-SectionsPage\"] .uif-errorMessageItem-field");
        this.waitIsVisibleByXpath("//header[@data-header_for='Demo-ValidationLayout-Section1']");
        this.assertElementPresentByXpath("//*[@data-messageitemfor='Demo-ValidationLayout-Section1' and @class='uif-errorMessageItem']");
        this.assertElementPresent("div[data-role=\"InputField\"] img[alt=\"Error\"]");
        this.assertElementPresentByXpath("//a[contains(.,'Section 1 Title')]");
        this.fireMouseOverEventByXpath("//a[contains(.,'Field 1')]");
        this.assertElementPresent(".uif-errorMessageItem-field");
        this.waitAndClickByXpath("//a[contains(.,'Field 1')]");
        this.waitIsVisible(".popover");
        this.waitIsVisible(".popover-content > .uif-serverMessageItems");
        this.waitIsVisible(".popover-content > .uif-serverMessageItems .uif-errorMessageItem-field");
        this.waitAndTypeByName("field1", "");
        this.fireEvent("field1", "blur");
        this.fireEvent("field1", "focus");
        this.waitIsVisible(".popover");
        this.waitIsVisible(".popover-content > .uif-serverMessageItems .uif-errorMessageItem-field");
        this.waitIsVisible(".popover-content > .uif-clientMessageItems");
        this.waitIsVisible(".popover-content > .uif-clientMessageItems  .uif-errorMessageItem-field");
        this.waitAndTypeByName("field1", "t");
        int second = 0;
        while (true) {
            if (second >= this.waitSeconds) {
                this.jiraAwareFail("timeout");
            }
            try {
                if (!this.isElementPresent(".popover-content > .uif-clientMessageItems")) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(1000L);
            ++second;
        }
        this.waitIsVisible(".popover-content > .uif-serverMessageItems .uif-errorMessageItem-field");
        this.assertFalse(this.isElementPresent(".popover-content > .uif-clientMessageItems"));
    }

    protected void testServerInfoIT() throws Exception {
        this.waitAndClickByXpath("//button[contains(.,'Get Info Messages')]");
        this.waitIsVisibleByXpath("//div[@data-messages_for='Demo-ValidationLayout-SectionsPage']");
        this.waitForProgressLoading();
        this.assertTrue(this.isVisibleByXpath("//div[@data-messages_for='Demo-ValidationLayout-SectionsPage']"));
        this.assertTrue(this.isElementPresent("div[data-messages_for=\"Demo-ValidationLayout-SectionsPage\"] .uif-infoMessageItem"));
        this.assertTrue(this.isVisible("div[data-messages_for=\"Demo-ValidationLayout-Section1\"]"));
        this.assertTrue(this.isElementPresent("div[data-messages_for=\"Demo-ValidationLayout-Section1\"] .uif-infoMessageItem"));
        this.assertTrue(this.isElementPresentByXpath("//div[@data-role='InputField']//img[@alt='Information']"));
        this.fireMouseOverEventByXpath("//a[contains(.,'Field 1')]");
        this.assertTrue(this.isElementPresent(".uif-infoHighlight"));
        this.waitAndClickByXpath("//a[contains(.,'Field 1')]");
        this.waitForElementPresentByXpath("//div[@class='popover top in uif-tooltip-info-ss']");
        this.waitAndTypeByName("field1", "");
        this.fireEvent("field1", "blur");
        this.fireEvent("field1", "focus");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-info-ss top in uif-tooltip-error-ss']");
        this.waitAndTypeByName("field1", "b");
        this.fireEvent("field1", "blur");
        this.fireEvent("field1", "focus");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-error-ss top in uif-tooltip-info-ss']");
        this.fireEvent("field1", "focus");
        this.clearTextByName("field1");
        this.fireEvent("field1", "blur");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-info-ss top in uif-tooltip-error-ss']");
    }

    protected void testServerWarningsIT() throws Exception {
        this.waitAndClickByXpath("//button[contains(.,'Get Warning Messages')]");
        this.waitForElementPresentByXpath("//div[@id='Demo-ValidationLayout-SectionsPage_messages']");
        this.waitForElementPresentByXpath("//div[@id='Demo-ValidationLayout-Section1_messages']");
        this.waitForElementPresentByXpath("//a[contains(.,'Field 1')]");
        this.fireMouseOverEventByXpath("//a[contains(.,'Field 1')]");
        this.waitForElementPresentByXpath("//div[@class='uif-inputField uif-boxLayoutHorizontalItem uif-hasWarning uif-warningHighlight']");
        this.waitAndClickByXpath("//a[contains(.,'Field 1')]");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-warning-ss top in uif-tooltip-error-ss']");
        this.waitAndTypeByName("field1", "");
        this.fireEvent("field1", "blur");
        this.fireMouseOverEventByName("field1");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-warning-ss top in uif-tooltip-error-ss']");
        this.waitAndTypeByName("field1", "b");
        this.fireEvent("field1", "blur");
        this.fireMouseOverEventByName("field1");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-warning-ss top in uif-tooltip-error-ss']");
        this.clearTextByName("field1");
        this.fireEvent("field1", "blur");
        this.fireMouseOverEventByName("field1");
        this.waitForElementPresentByXpath("//div[@class='popover uif-tooltip-warning-ss top in uif-tooltip-error-ss']");
        this.passed();
    }

    protected void testViewHelp2() throws Exception {
        if (this.isElementPresentByXpath("//td[@class='jquerybubblepopup-innerHtml']")) {
            this.assertFalse(this.findElement(By.cssSelector((String)"td.jquerybubblepopup-innerHtml")).isDisplayed());
        }
        this.fireMouseOverEventByXpath("//h1/span[@class='uif-headerText-span']");
        Thread.sleep(2000L);
        this.assertTrue(this.isVisibleByXpath("//td[contains(text(),'View help')]"));
        this.assertPopUpWindowUrl(By.cssSelector((String)"input[title=\"Help for Configuration Test View\"]"), "HelpWindow", "http://www.kuali.org/");
    }

    protected void testVerifyAddDeleteFiscalOfficerLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("document.documentHeader.documentDescription", AutomatedFunctionalTestUtils.createUniqueDtsPlusTwoRandomChars());
        this.waitAndTypeByName("newCollectionLines['document.newMaintainableObject.dataObject.fiscalOfficer.accounts'].number", "1234567890");
        this.waitAndTypeByName("newCollectionLines['document.newMaintainableObject.dataObject.fiscalOfficer.accounts'].foId", "2");
        this.waitAndClickByXpath("//button[@data-loadingmessage='Adding Line...']");
        this.waitForElementPresentByName("document.newMaintainableObject.dataObject.fiscalOfficer.accounts[0].number");
        this.assertEquals("1234567890", this.waitAndGetAttributeByName("document.newMaintainableObject.dataObject.fiscalOfficer.accounts[0].number", "value"));
        this.assertEquals("2", this.waitAndGetAttributeByName("document.newMaintainableObject.dataObject.fiscalOfficer.accounts[0].foId", "value"));
        this.waitAndClickByXpath("//button[@data-loadingmessage='Deleting Line...']");
        Thread.sleep(3000L);
        this.assertEquals(Boolean.FALSE, this.isElementPresentByName("document.newMaintainableObject.dataObject.fiscalOfficer.accounts[0].number"));
        this.passed();
    }

    protected void testVerifyAddDeleteNoteLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClick("div.tableborders.wrap.uif-boxLayoutVerticalItem.clearfix  span.uif-headerText-span > img.uif-disclosure-image");
        this.waitForElementPresent("button[title='Add a Note'].uif-action.uif-primaryActionButton.uif-smallActionButton");
        this.waitAndClickByName("newCollectionLines['document.notes'].noteText");
        this.waitAndTypeByName("newCollectionLines['document.notes'].noteText", "Test note");
        this.waitAndClick("button[title='Add a Note'].uif-action.uif-primaryActionButton.uif-smallActionButton");
        this.assertEquals("Test note", this.getTextByXpath("//pre"));
        this.waitAndClick("button[title='Delete a Note'].uif-action.uif-primaryActionButton.uif-smallActionButton");
        this.assertEquals(Boolean.FALSE, this.isElementPresentByName("document.notes[0].noteText"));
        this.passed();
    }

    protected void testVerifyAdHocRecipientsLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickByLinkText("Fiscal Officer Accounts");
        this.assertElementPresentByXpath("//select[@name=\"newCollectionLines['document.adHocRoutePersons'].actionRequested\"]");
        this.assertElementPresentByXpath("//input[@name=\"newCollectionLines['document.adHocRoutePersons'].name\" and @type=\"text\"]");
        this.assertElementPresentByXpath("//select[@name=\"newCollectionLines['document.adHocRouteWorkgroups'].actionRequested\"]");
        this.assertElementPresentByXpath("//input[@name=\"newCollectionLines['document.adHocRouteWorkgroups'].recipientNamespaceCode\" and @type='text']");
        this.assertElementPresentByXpath("//input[@name=\"newCollectionLines['document.adHocRouteWorkgroups'].recipientName\" and @type='text']");
        this.passed();
    }

    protected void testVerifyButtonsLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//button[contains(.,'ubmit')]");
        this.assertElementPresentByXpath("//button[contains(.,'ave')]");
        this.assertElementPresentByXpath("//button[contains(.,'lanket approve')]");
        this.assertElementPresentByXpath("//button[contains(.,'lose')]");
        this.assertElementPresentByXpath("//a[contains(.,'ancel')]");
        this.passed();
    }

    protected void testVerifyConstraintText() throws Exception {
        this.selectFrameIframePortlet();
        this.assertEquals("* indicates required field", this.getText("div.uif-boxLayout.uif-horizontalBoxLayout.clearfix > span.uif-message.uif-requiredInstructionsMessage.uif-boxLayoutHorizontalItem"));
        this.assertEquals("Must not be more than 10 characters", this.getText("div.uif-group.uif-gridGroup.uif-gridSection.uif-disclosure.uif-boxLayoutVerticalItem.clearfix div[data-label='Travel Account Number'].uif-field.uif-inputField span.uif-message.uif-constraintMessage"));
        this.assertEquals("Must not be more than 10 characters", this.getText("div.uif-group.uif-gridGroup.uif-gridSection.uif-disclosure.uif-boxLayoutVerticalItem.clearfix div[data-label='Travel Sub Account Number'].uif-field.uif-inputField span.uif-message.uif-constraintMessage"));
        this.assertEquals("Must not be more than 10 characters", this.getText("div.uif-group.uif-gridGroup.uif-collectionItem.uif-gridCollectionItem.uif-collectionAddItem div[data-label='Travel Account Number'].uif-field.uif-inputField span.uif-message.uif-constraintMessage"));
        this.passed();
    }

    protected void testVerifyEditedComponent(String docId, String componentName, String componentCode) throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("name", componentName);
        this.waitAndClickSearch();
        this.isElementPresentByLinkText(componentName);
        this.waitAndClickByLinkText(componentName);
        this.waitForPageToLoad();
        Thread.sleep(2000L);
        this.switchToWindow("Kuali :: Inquiry");
        Thread.sleep(2000L);
        this.assertEquals(componentName, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='name.div']").trim());
        this.assertEquals(componentCode, this.getTextByXpath("//div[@class='tab-container']/table//span[@id='code.div']").trim());
        this.waitAndClickCloseWindow();
        this.switchToWindow("null");
        ArrayList parameterList = new ArrayList();
    }

    protected void testVerifyDisclosures() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//span[contains(text(),'Document Overview')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Document Overview')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Account Information')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Fiscal Officer Accounts')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Notes and Attachments')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Ad Hoc Recipients')]");
        this.assertElementPresentByXpath("//span[contains(text(),'Route Log')]");
        this.colapseExpandByXpath("//span[contains(text(),'Document Overview')]//img", "//label[contains(text(),'Organization Document Number')]");
        this.colapseExpandByXpath("//span[contains(text(),'Account Information')]//img", "//label[contains(text(),'Travel Account Type Code')]");
        this.colapseExpandByXpath("//span[contains(text(),'Fiscal Officer Accounts')]//img", "//a[contains(text(),'Lookup/Add Multiple Lines')]");
        this.expandColapseByXpath("//span[contains(text(),'Notes and Attachments')]//img", "//label[contains(text(),'Note Text')]");
        this.expandColapseByXpath("//span[contains(text(),'Ad Hoc Recipients')]", "//span[contains(text(),'Ad Hoc Group Requests')]");
        this.waitAndClickByXpath("//span[contains(text(),'Route Log')]//img");
        this.selectFrame("routeLogIFrame");
        this.waitIsVisibleByXpath("//img[@alt='refresh']");
        this.selectTopFrame();
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//span[contains(text(),'Route Log')]//img");
        this.selectFrame("routeLogIFrame");
        this.waitNotVisibleByXpath("//img[@alt='refresh']");
        this.passed();
    }

    protected void testVerifyDocumentOverviewLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertTextPresent("Document Overview");
        this.assertElementPresentByXpath("//input[@name='document.documentHeader.documentDescription']");
        this.assertElementPresentByXpath("//input[@name='document.documentHeader.organizationDocumentNumber']");
        this.assertElementPresentByXpath("//textarea[@name='document.documentHeader.explanation']");
        this.passed();
    }

    protected void testVerifyExpandCollapse() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//button[contains(@class, 'uif-expandDisclosuresButton')]");
        this.assertElementPresentByXpath("//button[contains(@class, 'uif-collapseDisclosuresButton')]");
        this.passed();
    }

    protected void testVerifyFieldsLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.number' and @type='text' and @size=10 and @maxlength=10]");
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.extension.accountTypeCode' and @type='text' and @size=2 and @maxlength=3]");
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.subAccount' and @type='text' and @size=10 and @maxlength=10]");
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.subsidizedPercent' and @type='text' and @size=6 and @maxlength=20]");
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.foId' and @type='text' and @size=5 and @maxlength=10]");
        this.assertElementPresentByXpath("//input[@name=\"newCollectionLines['document.newMaintainableObject.dataObject.fiscalOfficer.accounts'].number\" and @type='text' and @size=10 and @maxlength=10]");
        this.assertElementPresentByXpath("//input[@name=\"newCollectionLines['document.newMaintainableObject.dataObject.fiscalOfficer.accounts'].foId\" and @type='text' and @size=5 and @maxlength=10]");
        this.passed();
    }

    protected void testVerifyHeaderFieldsLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//div[contains(@class, 'uif-documentNumber')]");
        this.assertElementPresentByXpath("//div[contains(@class, 'uif-documentInitiatorNetworkId')]");
        this.assertElementPresentByXpath("//div[contains(@class, 'uif-documentStatus')]");
        this.assertElementPresentByXpath("//div[contains(@class, 'uif-documentCreateDate')]");
        this.passed();
    }

    protected void testVerifyLookupAddMultipleLinesLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//a[contains(text(),'Lookup/Add Multiple Lines')]");
        this.passed();
    }

    protected void testVerifyNotesAndAttachments() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickByXpath("//span[contains(text(),'Notes and Attachments')]");
        this.waitForElementPresentByXpath("//button[@title='Add a Note']");
        this.assertElementPresentByXpath("//span[contains(text(),'Notes and Attachments')]");
        this.assertElementPresentByXpath("//textarea[@name=\"newCollectionLines['document.notes'].noteText\"]");
        this.assertElementPresentByXpath("//input[@name='attachmentFile']");
        this.passed();
    }

    protected void testVerifyQuickfinderIconsLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertTextPresent("Document Overview");
        this.assertElementPresentByXpath("//*[@id='quickfinder1']");
        this.assertElementPresentByXpath("//*[@id='quickfinder2']");
        this.assertElementPresentByXpath("//*[@id='quickfinder3']");
        this.assertElementPresentByXpath("//*[@id='quickfinder4_add']");
        this.passed();
    }

    protected void testVerifyRouteLog() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndClickByLinkText("Route Log");
        this.waitForElementPresent("//iframe[contains(@src,'RouteLog.do')]");
        this.passed();
    }

    protected void testVerifySave() throws Exception {
        this.selectFrameIframePortlet();
        this.waitAndTypeByName("document.documentHeader.documentDescription", "Test Document " + AutomatedFunctionalTestUtils.DTS);
        this.waitAndClickByName("document.newMaintainableObject.dataObject.number");
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.number", "1234567890");
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.extension.accountTypeCode", "EAT");
        this.waitAndTypeByName("document.newMaintainableObject.dataObject.subAccount", "a1");
        this.waitAndClick("button[data-loadingmessage='Saving...'].uif-action.uif-primaryActionButton.uif-boxLayoutHorizontalItem");
        Thread.sleep(2000L);
        this.passed();
    }

    protected void testVerifySubsidizedPercentWatermarkLegacy() throws Exception {
        this.selectFrameIframePortlet();
        this.assertElementPresentByXpath("//input[@name='document.newMaintainableObject.dataObject.subsidizedPercent']");
        this.passed();
    }

    protected void typeEnter() {
        this.jGrowl("Press Enter");
        this.driver.switchTo().activeElement().sendKeys(new CharSequence[]{Keys.ENTER});
    }

    protected void typeTab() {
        this.jGrowl("Press Tab");
        this.driver.switchTo().activeElement().sendKeys(new CharSequence[]{Keys.TAB});
    }

    @Override
    protected void uncheck(By by) throws InterruptedException {
        WebElement element = this.findElement(by);
        if (element.isSelected()) {
            element.click();
        }
    }

    @Override
    protected void uncheckByName(String name) throws InterruptedException {
        this.uncheck(By.name((String)name));
    }

    @Override
    protected void uncheckByXpath(String locator) throws InterruptedException {
        this.uncheck(By.xpath((String)locator));
    }

    protected void verifyRichMessagesValidationBasicFunctionality() throws Exception {
        this.assertTrue(this.isElementPresentByXpath("//input[@type='text' and @name='field1']"));
        this.assertTrue(this.isElementPresentByXpath("//a[contains(text(), 'Kuali')]"));
        this.assertTrue(this.isElementPresentByXpath("//input[@type='checkbox' and @name='field2']"));
        Thread.sleep(3000L);
    }

    protected void verifyRichMessagesValidationAdvancedFunctionality() throws Exception {
        this.assertTrue(this.isElementPresentByXpath("//span[@style='color: green;']"));
        this.assertTrue(this.isElementPresentByXpath("//span[@style='color: blue;']"));
        this.assertTrue(this.isElementPresentByXpath("//span[@class='uif-text-underline uif-text-larger']"));
        this.assertTrue(this.isElementPresentByXpath("//input[@type='text' and @name='field3']"));
        this.assertTrue(this.isElementPresentByXpath("//select[@name='field4']"));
        this.assertTrue(this.isElementPresentByXpath("//button[contains(text(), 'Action Button')]"));
        this.assertTrue(this.isElementPresentByXpath("//label[contains(., 'Label With')]/span[contains(., 'Color')]"));
        this.assertTrue(this.isElementPresentByXpath("//label[contains(., 'Label With')]/i/b[contains(., 'Html')]"));
        this.assertTrue(this.isElementPresentByXpath("//label[contains(., 'Label With')]/img[@class='uif-image inlineBlock']"));
        Thread.sleep(3000L);
    }

    protected void verifyRichMessagesValidationLettersNumbersValidation() throws Exception {
        this.assertTrue(this.isElementPresentByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']"));
        this.waitAndTypeByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']", "abc");
        this.assertFalse(this.isElementPresentByXpath("//div[@class='uif-field uif-inputField uif-inputField-labelTop inlineBlock uif-hasError']"));
        this.clearTextByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']");
        this.waitAndTypeByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']", "abc12");
        this.waitAndTypeByXpath("//input[@name= 'field6']", "");
        this.waitForElementPresentByXpath("//div[@class='uif-inputField inlineBlock uif-hasError']");
        Thread.sleep(3000L);
        this.clearTextByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']");
        this.waitAndTypeByXpath("//div[@data-parent='Demo-AdvancedMessagesSection']/div/input[@type='text' and @name='field5']", "abc");
        this.waitAndTypeByXpath("//input[@name= 'field6']", "");
        this.waitAndTypeByXpath("//input[@name= 'field6']", "123");
        this.assertFalse(this.isElementPresentByXpath("//div[@class='uif-field uif-inputField uif-inputField-labelTop inlineBlock uif-hasError']"));
        this.clearTextByXpath("//input[@name='field6']");
        this.waitAndTypeByXpath("//input[@name='field6']", "123ab");
        this.fireEvent("field6", "blur");
        this.waitForElementPresentByXpath("//div[@class='uif-inputField inlineBlock uif-hasError']");
    }

    protected void verifyRichMessagesValidationRadioAndCheckBoxGroupFunctionality() throws Exception {
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalRadioFieldset']/span/input[@type='radio' and @name='field24' and @value='1']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalRadioFieldset']/span/input[@type='radio' and @name='field24' and @value='2']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalRadioFieldset']/span/input[@type='radio' and @name='field24' and @value='3']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalRadioFieldset']/span/input[@type='radio' and @name='field24' and @value='4']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalCheckboxesFieldset']/span/input[@type='checkbox' and @name='field115' and @value='1']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalCheckboxesFieldset']/span/input[@type='checkbox' and @name='field115' and @value='2']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalCheckboxesFieldset']/span/input[@type='checkbox' and @name='field115' and @value='3']"));
        this.assertTrue(this.isElementPresentByXpath("//fieldset[@class='uif-verticalCheckboxesFieldset']/span/label/div/select[@name='field4']"));
        this.assertTrue(this.isElementPresentByXpath("//input[@type='checkbox' and @name='bField1']"));
        this.assertTrue(this.isElementPresentByXpath("//input[@type='text' and @name='field103']"));
    }

    protected void verifyRichMessagesValidationLinkDeclarationsFunctionality() throws Exception {
        this.waitAndClickByLinkText("Kuali Site");
        Thread.sleep(9000L);
        this.switchToWindow("Open Source Software | www.kuali.org");
        this.switchToWindow(RICH_MESSAGES_WINDOW_TITLE);
        this.waitAndClickByXpath("//p[contains(., 'Testing methodToCall action')]/a");
        Thread.sleep(3000L);
        this.assertTrue(this.isElementPresentByXpath("//div[@class='alert alert-danger']"));
        this.waitAndClickByXpath("//p[contains(., 'Testing methodToCall action (no client validation check)')]/a");
        this.assertTrue(this.isElementPresentByXpath("//div[@id='Demo-BasicMessagesSection_messages' and @class='alert alert-danger']"));
        this.assertTrue(this.isElementPresentByXpath("//div[@id='Demo-AdvancedMessagesSection_messages' and @class='alert alert-danger']"));
        Thread.sleep(3000L);
    }

    protected void waitAndClickAdministration() throws InterruptedException {
        this.waitAndClickByLinkText(ADMINISTRATION_LINK_TEXT, this);
    }

    protected void waitAndClickClearValues() throws InterruptedException {
        this.waitAndClickButtonByText("Clear Values");
    }

    private void waitAndClickAdministration(JiraAwareFailable failable) throws InterruptedException {
        this.waitAndClickByLinkText(ADMINISTRATION_LINK_TEXT, failable);
    }

    protected void waitAndCancelConfirmation() throws InterruptedException {
        this.waitAndClickCancel();
        this.waitAndClickByName("methodToCall.processAnswer.button0");
    }

    protected void waitAndClickAdHocPersonAdd() throws InterruptedException {
        this.jGrowl("Click AdHoc Person add");
        this.waitAndClickByXpath("//button[@id='Uif-AdHocPersonCollection_add']");
    }

    protected void waitAndClickAdHocPersonAddQuickFinder() throws InterruptedException {
        this.jGrowl("Click AdHoc Person quickfinder");
        this.waitAndClickByXpath("//div[@data-parent='Uif-AdHocPersonCollection']/div/div/button");
    }

    protected void waitAndClickAdHocGroupAddQuickFinder() throws InterruptedException {
        this.jGrowl("Click AdHoc Group quickfinder");
        this.waitAndClickByXpath("//div[@data-parent='CollectionGroup_AdHocWorkgroup']/div/div/button");
    }

    protected void waitAndClickBlanketApprove() throws InterruptedException {
        this.waitAndClickButtonByText("Blanket Approve");
    }

    protected void waitAndClickCancel() throws InterruptedException {
        this.waitAndClickByName(CANCEL_NAME);
    }

    protected void waitAndClickCancelByText() throws InterruptedException {
        this.waitAndClickButtonByText("Cancel");
    }

    protected void waitAndClickCloseWindow() throws InterruptedException {
        this.waitAndClickByXpath(CLOSE_WINDOW_XPATH_TITLE);
    }

    protected void waitAndClickCopy() throws InterruptedException {
        this.waitAndClickByLinkText(COPY_LINK_TEXT);
    }

    protected void waitAndClickDemoLink() throws InterruptedException {
        this.jGrowl("Click Demo Link");
        this.waitAndClickById("Demo-DemoLink", "");
    }

    protected void waitAndClickDocSearch() throws InterruptedException {
        this.waitAndClickByXpath(DOC_SEARCH_XPATH);
    }

    protected void waitAndClickDocSearchTitle() throws InterruptedException {
        this.waitAndClickByXpath(DOC_SEARCH_XPATH_TITLE);
    }

    protected void waitAndClickLibraryLink() throws InterruptedException {
        this.jGrowl("Click Library Link");
        this.waitAndClickById("Demo-LibraryLink", "");
    }

    protected void waitAndClickLogout() throws InterruptedException {
        this.waitAndClickLogout(this);
    }

    protected void waitAndClickLogout(JiraAwareFailable failable) throws InterruptedException {
        this.jGrowl("Logging out");
        this.selectTopFrame();
        this.waitAndClickByXpath(LOGOUT_XPATH, failable);
    }

    protected void waitAndClickMainMenu() throws InterruptedException {
        this.waitAndClickByLinkText(MAIN_MENU_LINK_TEXT, this);
    }

    private void waitAndClickMainMenu(JiraAwareFailable failable) throws InterruptedException {
        this.waitAndClickByLinkText(MAIN_MENU_LINK_TEXT, failable);
    }

    protected void waitAndClickRouteLogIcon() throws InterruptedException {
        this.jGrowl("Click Route Log link");
        this.waitAndClickByXpath("//img[@alt=\"Route Log for Document\"]");
    }

    protected void waitAndClickSave() throws InterruptedException {
        this.waitAndClickByXpath(SAVE_XPATH);
    }

    protected void waitAndClickSaveByText() throws InterruptedException {
        this.waitAndClickButtonByText("Save");
    }

    protected void waitAndClickSubmit() throws InterruptedException {
        this.jGrowl("Click Submit");
        this.waitAndClickByXpath(SUBMIT_XPATH);
    }

    protected void waitAndClickSubmitByText() throws InterruptedException {
        this.waitAndClickButtonByText("Submit");
    }

    protected void waitAndClickApprove() throws InterruptedException {
        this.jGrowl("Click Approve");
        this.waitAndClickByXpath(APPROVE_XPATH);
    }

    protected void waitAndClickApproveByText() throws InterruptedException {
        this.waitAndClickButtonByText("Approve");
    }

    protected void waitAndClickDisapprove() throws InterruptedException {
        this.jGrowl("Click Disapprove");
        this.waitAndClickByXpath(DISAPPROVE_XPATH);
    }

    protected void waitAndClickDisapproveByText() throws InterruptedException {
        this.waitAndClickButtonByText("Disapprove");
    }

    protected void waitAndClickAcknowledge() throws InterruptedException {
        this.jGrowl("Click Acknowledge");
        this.waitAndClickByXpath(ACKNOWLEDGE_XPATH);
    }

    protected void waitAndClickAcknowledgeByText() throws InterruptedException {
        this.waitAndClickButtonByText("Acknowledge");
    }

    protected void waitAndClickClose() throws InterruptedException {
        this.jGrowl("Click Close");
        this.waitAndClickByXpath(CLOSE_XPATH);
    }

    protected void waitAndClickCloseByText() throws InterruptedException {
        this.waitAndClickButtonByText("Close");
    }

    protected void waitAndClickXMLIngester(JiraAwareFailable failable) throws InterruptedException {
        this.waitAndClickByLinkText(XML_INGESTER_LINK_TEXT, failable);
    }

    protected void waitAndCreateNew() throws InterruptedException {
        this.waitAndCreateNew(this.getClass().toString());
    }

    protected void waitAndCreateNew(String message) throws InterruptedException {
        this.selectFrameIframePortlet();
        this.jGrowl("Create New");
        this.waitAndClickCreateNew(message);
    }

    protected void waitAndClickCreateNew() throws InterruptedException {
        this.waitAndClickCreateNew(this.getClass().toString());
    }

    protected void waitAndClickCreateNew(String message) throws InterruptedException {
        this.jGrowl("Click Create New");
        if (WebDriverUtils.waitFors(this.driver, By.xpath((String)CREATE_NEW_XPATH)).size() > 0) {
            this.waitAndClickByXpath(CREATE_NEW_XPATH, message);
        } else {
            System.out.println("waitAndClickByXpath(//img[@alt='create new']) wasn't found trying //a[@title='Create a new record']");
            this.waitAndClickByXpath(CREATE_NEW_XPATH2, message);
        }
    }

    protected void waitAndClickEdit() throws InterruptedException {
        this.waitAndClickByLinkText(EDIT_LINK_TEXT);
    }

    protected void waitAndClickSearch() throws InterruptedException {
        this.jGrowl("Click Search");
        this.waitAndClickByXpath(SEARCH_XPATH);
    }

    protected void waitAndClickSearch2() throws InterruptedException {
        this.jGrowl("Click Search");
        this.waitAndClickByXpath(SEARCH_XPATH_2);
    }

    protected void waitAndClickSearchSecond() throws InterruptedException {
        this.jGrowl("Click Search");
        this.waitAndClickByXpath(SEARCH_SECOND);
    }

    protected void waitAndClickSearchByText() throws InterruptedException {
        this.waitAndClickButtonByText(SEARCH);
    }

    protected String waitForAgendaDocId() throws InterruptedException {
        String docId = this.waitForElementPresentByXpath(DOC_ID_KRAD_XPATH).getText();
        this.jGrowl("Document Number is " + docId);
        return docId;
    }

    protected String waitForDocId() throws InterruptedException {
        this.checkForDocError();
        this.waitForElementPresentByXpath(DOC_ID_XPATH);
        String docId = this.findElement(By.xpath((String)DOC_ID_XPATH)).getText();
        this.jGrowl("Document Number is " + docId);
        return docId;
    }

    protected String waitForDocIdKrad() throws InterruptedException {
        this.failOnErrorMessageItem();
        this.waitForElementPresentByXpath(DOC_ID_KRAD_XPATH);
        String docId = this.findElement(By.xpath((String)DOC_ID_KRAD_XPATH)).getText();
        this.jGrowl("Document Number is " + docId);
        return docId;
    }

    protected String waitForDocInitiator() throws InterruptedException {
        this.waitForElementPresentByXpath(DOC_INITIATOR_XPATH);
        return this.findElement(By.xpath((String)DOC_INITIATOR_XPATH)).getText();
    }

    protected String waitForDocStatus() throws InterruptedException {
        this.waitForElementPresentByXpath(DOC_STATUS_XPATH);
        return this.findElement(By.xpath((String)DOC_STATUS_XPATH)).getText();
    }

    protected void waitForTitleToEqualKualiPortalIndex() throws InterruptedException {
        this.waitForTitleToEqualKualiPortalIndex(this.getClass().toString());
    }

    protected void waitForToolTipTextPresent(String tooltipText) throws InterruptedException {
        this.assertEquals("ToolTip text not as expected", tooltipText, this.waitForToolTipPresent().getText());
    }

    protected WebElement waitForToolTipPresent() throws InterruptedException {
        this.waitForElementPresent(".popover.top.in");
        WebElement tooltip = this.findElement(By.cssSelector((String)".popover.top.in"));
        this.jGrowl("ToolTip " + tooltip.getText());
        return tooltip;
    }

    protected void waitForTitleToEqualKualiPortalIndex(String message) throws InterruptedException {
        Thread.sleep(2000L);
    }

    protected void waitAndClickKRAD() throws InterruptedException {
        this.waitAndClickByLinkText(KRAD_XPATH);
    }

    protected boolean isKrad() {
        return KRAD_XPATH.equalsIgnoreCase(this.getUiFramework());
    }

    public String getUiFramework() {
        return this.uiFramework;
    }

    public void setUiFramework(String uiFramework) {
        this.uiFramework = uiFramework;
    }

    public void pressEnterByName(String locator) {
        this.pressEnter(By.name((String)locator));
    }

    public void pressEnterByXpath(String locator) {
        this.pressEnter(By.xpath((String)locator));
    }

    public void pressEnter(By by) {
        this.findElement(by).sendKeys(new CharSequence[]{Keys.ENTER});
    }

    static {
        if (System.getProperty("remote.property.file") != null) {
            PropertiesUtils propUtils = new PropertiesUtils();
            try {
                propUtils.loadPropertiesWithSystemAndOverridesIntoSystem(System.getProperty("remote.property.file"));
            }
            catch (IOException ioe) {
                System.out.println("Exception opening " + System.getProperty("remote.property.file") + " " + ioe.getMessage());
            }
        }
        actionRequestLabelMap = new HashMap<String, String>();
        actionRequestLabelMap.put("A", "APPROVE");
        actionRequestLabelMap.put("F", "FYI");
        actionRequestLabelMap.put("C", "COMPLETE");
        actionRequestLabelMap.put("CR", "COMPLETE");
        actionRequestLabelMap.put("K", "ACKNOWLEDGE");
        actionRequestLabelMap.put("D", "APPROVE");
        actionRequestButtonMap = new HashMap<String, String>();
        actionRequestButtonMap.put("A", "methodToCall.approve");
        actionRequestButtonMap.put("F", "methodToCall.fyi");
        actionRequestButtonMap.put("C", "methodToCall.complete");
        actionRequestButtonMap.put("CR", "methodToCall.route");
        actionRequestButtonMap.put("K", "methodToCall.acknowledge");
        actionRequestButtonMap.put("D", "methodToCall.disapprove");
    }
}

