<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="Include.jsp"%>

<html lang="en">
<head>
<title>Kuali Enterprise Notification - Send a Simple Notification</title>
<meta name="Author" content="Aaron Godert (ag266 at cornell dot edu)">
<link href="css/notification.css" rel="stylesheet" type="text/css" />
<script language="JavaScript" type="text/javascript" src="scripts/jscalendar-1.0/calendar.js"></script>
<script language="JavaScript" type="text/javascript" src="scripts/jscalendar-1.0/lang/calendar-en.js"></script>
<script language="JavaScript" type="text/javascript" src="scripts/jscalendar-1.0/calendar-setup.js"></script>
<style type="text/css">@import url(scripts/jscalendar-1.0/calendar-win2k-1.css);</style>
</head>
<body>

		<div style="padding: 5px">						
        <div class="title">Send a Simple Notification</div>
       
       	<c:forEach var="error" items="${errors.errors}">
        	 <div><font color="red"><b><c:out value="${error}" /></b></font></div>
        </c:forEach>
		
		<form name="SendSimpleNotificationMessage" action="SubmitSimpleNotificationMessage.form">
			<input type="hidden" name="originalDateTime"  value="${originalDateTime}"/>
            <table  border="0" cellpadding="0" cellspacing="0"
				class="bord-all" width="60%">
				<tr>
					<td class="thnormal"><label for="channelName"><strong>Channel:</strong></label></td>
					<td class="thnormal">
						<%@ include file="util/channel_dropdown_fragment.jsp" %>
						<img src="images/transparent_002.gif" height="1" width="5">
						<i>(choose the channel that this message will be sent on behalf of)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="priorityName"><strong>Priority:</strong></label></td>
					<td class="thnormal">
						<select id="priorityName" name="priorityName" aria-label="Priority">
							<c:forEach var="priority" items="${priorities}">
								<c:choose>
									<c:when test="${priority.name eq priorityName}">
										<option value="${priority.name}" selected="selected">${priority.name}</option>
									</c:when>
									<c:otherwise>
										<option value="${priority.name}">${priority.name}</option>
									</c:otherwise>
								</c:choose>
							</c:forEach>
						</select>
						<img src="images/transparent_002.gif" height="1" width="5">
						<i>(select the system defined priority that matches the importance of this message)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="senderNames"><strong>Senders:</strong></label></td>
					<td class="thnormal">
						<c:choose>
							<c:when test="${! empty senderNames}">
								<input type="text" id="senderNames" name="senderNames" value="${senderNames}" aria-label="Senders"/>
							</c:when>
							<c:otherwise>
								<input type="text" id="senderNames" name="senderNames" value="${defaultSender}" aria-label="Senders" />
							</c:otherwise>
						</c:choose>
						
						<img src="images/transparent_002.gif" height="1" width="5">
						<i>(separate names using a comma - i.e. John Doe, Joe Schmoe, ...)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><strong>Type:</strong></td>
					<td class="thnormal">
						<c:choose>
							<c:when test="${deliveryType eq 'ACK'}">
								<input type="radio" id="deliveryTypeFyi" name="deliveryType" value="FYI" aria-label="FYI"/><label for="deliveryTypeFyi">FYI</label>
								<img src="images/transparent_002.gif" height="1" width="4"/>
								<input type="radio" id="deliveryTypeAck" name="deliveryType" value="ACK" aria-label="Acknowledge" checked="checked"/><label for="deliveryTypeAck">Acknowledge</label>
							</c:when>
							<c:otherwise>
								<input type="radio" id="deliveryTypeFyi" name="deliveryType" value="FYI" aria-label="FYI" checked="checked"/><label for="deliveryTypeFyi">FYI</label>
								<img src="images/transparent_002.gif" height="1" width="4"/>
								<input type="radio" id="deliveryTypeAck" name="deliveryType" value="ACK" aria-label="Acknowledge"/><label for="deliveryTypeAck">Acknowledge</label>
							</c:otherwise>
						</c:choose>
						<img src="images/transparent_002.gif" height="1" width="5"/>
						<i>(choose whether you want the recipients to have to view the details and acknowledge the message or not)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="send_date_time"><strong>Send Date/Time:</strong></label></td>
					<td class="thnormal">
						<input type="text" name="sendDateTime" id="send_date_time" value="${sendDateTime}" aria-label="Send Date/Time"/>
						<img src="images/cal.gif" id="send_date_time_trigger" title="Date/time selector" />
						<script type="text/javascript">
						    Calendar.setup({
						        inputField     :    "send_date_time",     // id of the input field
						        ifFormat       :    "%m/%d/%Y %I:%M %p",     // format of the input field (even if hidden, this format will be honored)
						        button         :    "send_date_time_trigger", // the button or image that triggers this
						        showsTime      :    true,            // will display a time selector
						        daFormat       :    "%A, %B %d, %Y",// format of the displayed date
						        singleClick    :    true,
						        step           :    1
						    });
						</script>
						<img src="images/transparent_002.gif" height="1" width="5">
						<i>(choose whether you want the message to be sent at a given point in time)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="auto_remove_date_time"><strong>Auto-Remove Date/Time:</strong></label></td>
					<td class="thnormal">
						<input type="text" name="autoRemoveDateTime" id="auto_remove_date_time" value="${autoRemoveDateTime}" aria-label="Auto-Remove Date/Time"/>
						<img src="images/cal.gif" id="auto_remove_date_time_trigger" title="Date/time selector" />
						<script type="text/javascript">
						    Calendar.setup({
						        inputField     :    "auto_remove_date_time",     // id of the input field
						        ifFormat       :    "%m/%d/%Y %I:%M %p",     // format of the input field (even if hidden, this format will be honored)
						        button         :    "auto_remove_date_time_trigger", // the button or image that triggers this
						        showsTime      :    true,            // will display a time selector
						        daFormat       :    "%A, %B %d, %Y",// format of the displayed date
						        singleClick    :    true,
						        step           :    1
						    });
						</script>
						<img src="images/transparent_002.gif" height="1" width="5">
						<i>(choose whether you want the message to be auto-removed from peoples' notification lists at a given point in time)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="userRecipients"><strong>User Recipients:</strong></label></td>
					<td class="thnormal">
						<input type="text" id="userRecipients" name="userRecipients" value="${userRecipients}" aria-label="User Recipients"/>
                        <img src="images/transparent_002.gif" height="1" width="5">
                        <i>(separate names using a comma - i.e. John Doe, Joe Schmoe, ...)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal"><label for="workgroupRecipients"><strong>Group Recipients:</strong></label></td>
					<td class="thnormal">
						<input type="text" id="workgroupRecipients" name="workgroupRecipients" value="${workgroupRecipients}" aria-label="Group Recipients"/>
                        <img src="images/transparent_002.gif" height="1" width="5">
                        <i>(separate names using a comma - i.e. GroupA, GroupB, ...)</i>
					</td>
				</tr>
				<tr>
                    <td class="thnormal"><label for="workgroupNamespaceCodes"><strong>Group Namespace Codes:</strong></label></td>
                    <td class="thnormal">
						<input type="text" id="workgroupNamespaceCodes" name="workgroupNamespaceCodes" value="${workgroupNamespaceCodes}" aria-label="Group Namespace Codes"/>
                        <img src="images/transparent_002.gif" height="1" width="5">
                        <i>(separate namespace codes using a comma, corresponding them with the group names above - i.e. NamespaceA, NamespaceB, ...)</i>
                    </td>
                </tr>
                <tr>
                    <td class="thnormal"><label for="title"><strong>Title:</strong></label></td>
                    <td class="thnormal">
                        <input type="text" id="title" name="title" maxlength="255" size="50" value="${title}" aria-label="Title"/>
                        <img src="images/transparent_002.gif" height="1" width="5">
                        <i>(required)</i>
                    </td>
                </tr>
				<tr>
					<td class="thnormal"><label for="message"><strong>Message:</strong></label></td>
					<td class="thnormal">
						<textarea id="message" name="message" rows="5" cols="50" aria-label="Message">${message}</textarea>
						<img src="images/transparent_002.gif" height="1" width="5"> 
						<i>(required)</i>
					</td>
				</tr>
				<tr>
					<td class="thnormal" colspan="2">
						<input type="image" src="images/buttonsmall_submit.gif" value="submit" alt="Submit message." name="submit"/>  
					</td>
				</tr>
			</table>
		</form> 								
		</div>

</body>
</html>
