<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Css Grid Layout Manager

    This is a layout that uses divs instead of a table to achieve a table look and feel.  This is done through the
    use of css with divs which represent "rows" and "cells" of the layout.  Two variations can be achieved through
    this layout, either a fluid version (stretches and reacts to resizing the window) or fixed (does not change
    the size of the "cells").
 -->
<#include "../components/element/label.ftl"/>

<#macro uif_cssGrid items manager container>
    <#local cellIndex = 0/>

    <#list manager.cellItems as item>
        <div class="${manager.cellCssClassAttributes[cellIndex]}">
            <@krad.template component=item/>
        </div>
        <#local cellIndex = cellIndex + 1/>
    </#list>

</#macro>
