/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;

public class ExecuteSqlCommand
extends AbstractCommand {
    private Database database;
    private String sql;
    private String sqlFile;
    private String delimiter = ";";

    @Override
    public String getName() {
        return "executeSql";
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSqlFile() {
        return this.sqlFile;
    }

    public void setSqlFile(String sqlFile) {
        this.sqlFile = sqlFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public CommandValidationErrors validate() {
        CommandValidationErrors commandValidationErrors = new CommandValidationErrors(this);
        return commandValidationErrors;
    }

    protected CommandResult run() throws Exception {
        String[] sqlStrings;
        String sqlText;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        if (this.sqlFile == null) {
            sqlText = this.sql;
        } else {
            File file = new File(this.sqlFile);
            if (!file.exists()) {
                throw new LiquibaseException(String.format("The file '%s' does not exist", file.getCanonicalPath()));
            }
            sqlText = FileUtil.getContents(file);
        }
        String out = "";
        for (String sql : sqlStrings = StringUtil.processMutliLineSQL(sqlText, true, true, this.delimiter)) {
            if (sql.toLowerCase().matches("\\s*select .*")) {
                List<Map<String, ?>> rows = executor.queryForList(new RawSqlStatement(sql));
                out = out + "Output of " + sql + ":\n";
                if (rows.isEmpty()) {
                    out = out + "-- Empty Resultset --\n";
                } else {
                    TreeSet<String> keys = new TreeSet<String>();
                    for (Map<String, ?> row : rows) {
                        keys.addAll(row.keySet());
                    }
                    out = out + StringUtil.join(keys, " | ") + " |\n";
                    for (Map<String, ?> row : rows) {
                        for (String key : keys) {
                            out = out + row.get(key) + " | ";
                        }
                        out = out + "\n";
                    }
                }
            } else {
                executor.execute(new RawSqlStatement(sql));
                out = out + "Successfully Executed: " + sql + "\n";
            }
            out = out + "\n";
        }
        this.database.commit();
        return new CommandResult(out.trim());
    }
}

