/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.DatabaseConnection;
import liquibase.database.core.AbstractDb2Database;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.util.StringUtil;

public class Db2zDatabase
extends AbstractDb2Database {
    public Db2zDatabase() {
        super.setCurrentDateTimeFunction("CURRENT TIMESTAMP");
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.sequenceCurrentValueFunction = "PREVIOUS VALUE FOR %s";
        this.unquotedObjectsAreUppercased = true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getDatabaseProductName().startsWith("DB2") && StringUtil.startsWith(conn.getDatabaseProductVersion(), "DSN");
    }

    @Override
    public String getShortName() {
        return "db2z";
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return false;
    }

    @Override
    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        return objectName;
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        boolean isSystemIndex = example instanceof Index && example.getName() != null && example.getName().contains("_#_");
        boolean isSystemColumn = example instanceof Column && StringUtil.startsWith(example.getName(), "DB2_GENERATED");
        return isSystemIndex || isSystemColumn || super.isSystemObject(example);
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "DB2/z";
    }
}

