/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import liquibase.ContextExpression;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Labels;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.IncludeAllFilter;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownChangeLogParameterException;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.exception.ValidationFailedException;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Conditional;
import liquibase.precondition.Precondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.util.StringUtil;

public class DatabaseChangeLog
implements Comparable<DatabaseChangeLog>,
Conditional {
    private static final ThreadLocal<DatabaseChangeLog> ROOT_CHANGE_LOG = new ThreadLocal();
    private static final ThreadLocal<DatabaseChangeLog> PARENT_CHANGE_LOG = new ThreadLocal();
    private static final Logger LOG = Scope.getCurrentScope().getLog(DatabaseChangeLog.class);
    private static final Pattern SLASH_PATTERN = Pattern.compile("^/");
    private static final Pattern NON_CLASSPATH_PATTERN = Pattern.compile("^classpath:");
    private static final Pattern DOUBLE_BACK_SLASH_PATTERN = Pattern.compile("\\\\");
    private static final Pattern DOUBLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final Pattern SLASH_DOT_SLASH_PATTERN = Pattern.compile("/\\./");
    private static final Pattern NO_LETTER_PATTERN = Pattern.compile("^[a-zA-Z]:");
    private static final Pattern DOT_SLASH_PATTERN = Pattern.compile("^\\.?/");
    private PreconditionContainer preconditionContainer = new GlobalPreconditionContainer();
    private String physicalFilePath;
    private String logicalFilePath;
    private String changeLogId;
    private ObjectQuotingStrategy objectQuotingStrategy;
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();
    private ChangeLogParameters changeLogParameters;
    private RuntimeEnvironment runtimeEnvironment;
    private DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
    private DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
    private ContextExpression contextFilter;
    private ContextExpression includeContextFilter;
    private Labels includeLabels;
    private boolean includeIgnore;

    public DatabaseChangeLog() {
    }

    public DatabaseChangeLog(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public void setRootChangeLog(DatabaseChangeLog rootChangeLog) {
        this.rootChangeLog = rootChangeLog;
    }

    public DatabaseChangeLog getRootChangeLog() {
        return this.rootChangeLog != null ? this.rootChangeLog : this;
    }

    public void setParentChangeLog(DatabaseChangeLog parentChangeLog) {
        this.parentChangeLog = parentChangeLog;
    }

    public DatabaseChangeLog getParentChangeLog() {
        return this.parentChangeLog;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    @Override
    public PreconditionContainer getPreconditions() {
        return this.preconditionContainer;
    }

    @Override
    public void setPreconditions(PreconditionContainer precond) {
        this.preconditionContainer.addNestedPrecondition(precond);
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public void setChangeLogParameters(ChangeLogParameters changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public String getChangeLogId() {
        return this.changeLogId;
    }

    public void setChangeLogId(String changeLogId) {
        this.changeLogId = changeLogId;
    }

    public String getLogicalFilePath() {
        String returnPath = this.logicalFilePath;
        if (this.logicalFilePath == null) {
            returnPath = this.physicalFilePath;
        }
        if (returnPath == null) {
            return null;
        }
        String path = DOUBLE_BACK_SLASH_PATTERN.matcher(returnPath).replaceAll("/");
        return SLASH_PATTERN.matcher(path).replaceFirst("");
    }

    public void setLogicalFilePath(String logicalFilePath) {
        this.logicalFilePath = logicalFilePath;
    }

    public String getFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.getLogicalFilePath();
    }

    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.objectQuotingStrategy;
    }

    public void setObjectQuotingStrategy(ObjectQuotingStrategy objectQuotingStrategy) {
        this.objectQuotingStrategy = objectQuotingStrategy;
    }

    public ContextExpression getContexts() {
        return this.getContextFilter();
    }

    public void setContexts(ContextExpression contexts) {
        this.setContextFilter(contexts);
    }

    public ContextExpression getContextFilter() {
        return this.contextFilter;
    }

    public void setContextFilter(ContextExpression contextFilter) {
        this.contextFilter = contextFilter;
    }

    public ContextExpression getIncludeContextFilter() {
        return this.includeContextFilter;
    }

    public void setIncludeLabels(LabelExpression labels) {
        this.includeLabels = new Labels(labels.toString());
    }

    public void setIncludeLabels(Labels labels) {
        this.includeLabels = labels;
    }

    public Labels getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeIgnore(boolean ignore) {
        this.includeIgnore = ignore;
    }

    public boolean isIncludeIgnore() {
        return this.includeIgnore;
    }

    public void setIncludeContexts(ContextExpression includeContexts) {
        this.setIncludeContextFilter(includeContexts);
    }

    public void setIncludeContextFilter(ContextExpression includeContextFilter) {
        this.includeContextFilter = includeContextFilter;
    }

    public String toString() {
        return this.getFilePath();
    }

    @Override
    public int compareTo(DatabaseChangeLog o) {
        return this.getFilePath().compareTo(o.getFilePath());
    }

    public ChangeSet getChangeSet(String path, String author, String id) {
        List<ChangeSet> possibleChangeSets = this.getChangeSets(path, author, id);
        if (possibleChangeSets.isEmpty()) {
            return null;
        }
        return possibleChangeSets.get(0);
    }

    public List<ChangeSet> getChangeSets(String path, String author, String id) {
        ArrayList<ChangeSet> changeSetsToReturn = new ArrayList<ChangeSet>();
        for (ChangeSet changeSet : this.changeSets) {
            String normalizedPath = DatabaseChangeLog.normalizePath(changeSet.getFilePath());
            if (normalizedPath == null || !normalizedPath.equalsIgnoreCase(DatabaseChangeLog.normalizePath(path)) || !changeSet.getAuthor().equalsIgnoreCase(author) || !changeSet.getId().equalsIgnoreCase(id) || !this.isDbmsMatch(changeSet.getDbmsSet())) continue;
            changeSetsToReturn.add(changeSet);
        }
        return changeSetsToReturn;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void addChangeSet(ChangeSet changeSet) {
        if (changeSet.getRunOrder() == null) {
            ListIterator<ChangeSet> it = this.changeSets.listIterator(this.changeSets.size());
            boolean added = false;
            while (it.hasPrevious() && !added) {
                if ("last".equals(it.previous().getRunOrder())) continue;
                it.next();
                it.add(changeSet);
                added = true;
            }
            if (!added) {
                it.add(changeSet);
            }
        } else if ("first".equals(changeSet.getRunOrder())) {
            ListIterator<ChangeSet> it = this.changeSets.listIterator();
            boolean added = false;
            while (it.hasNext() && !added) {
                if ("first".equals(it.next().getRunOrder())) continue;
                it.previous();
                it.add(changeSet);
                added = true;
            }
            if (!added) {
                this.changeSets.add(changeSet);
            }
        } else if ("last".equals(changeSet.getRunOrder())) {
            this.changeSets.add(changeSet);
        } else {
            throw new UnexpectedLiquibaseException("Unknown runOrder: " + changeSet.getRunOrder());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseChangeLog that = (DatabaseChangeLog)o;
        return this.getFilePath().equals(that.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public void validate(Database database, String ... contexts) throws LiquibaseException {
        this.validate(database, new Contexts(contexts), new LabelExpression());
    }

    public void validate(Database database, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        database.setObjectQuotingStrategy(this.objectQuotingStrategy);
        ChangeLogIterator logIterator = new ChangeLogIterator(this, new DbmsChangeSetFilter(database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression));
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(database.getRanChangeSetList());
        validatingVisitor.validate(database, this);
        logIterator.run(validatingVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        for (String message : validatingVisitor.getWarnings().getMessages()) {
            log.warning(message);
        }
        if (!validatingVisitor.validationPassed()) {
            throw new ValidationFailedException(validatingVisitor);
        }
    }

    public ChangeSet getChangeSet(RanChangeSet ranChangeSet) {
        ChangeSet changeSet = this.getChangeSet(ranChangeSet.getChangeLog(), ranChangeSet.getAuthor(), ranChangeSet.getId());
        if (changeSet != null) {
            changeSet.setStoredFilePath(ranChangeSet.getStoredChangeLog());
        }
        return changeSet;
    }

    public List<ChangeSet> getChangeSets(RanChangeSet ranChangeSet) {
        return this.getChangeSets(ranChangeSet.getChangeLog(), ranChangeSet.getAuthor(), ranChangeSet.getId());
    }

    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        this.setChangeLogId(parsedNode.getChildValue((String)null, "changeLogId", String.class));
        this.setLogicalFilePath(parsedNode.getChildValue((String)null, "logicalFilePath", String.class));
        String context = parsedNode.getChildValue((String)null, "contextFilter", String.class);
        if (context == null) {
            context = parsedNode.getChildValue((String)null, "context", String.class);
        }
        this.setContextFilter(new ContextExpression(context));
        String nodeObjectQuotingStrategy = parsedNode.getChildValue((String)null, "objectQuotingStrategy", String.class);
        if (nodeObjectQuotingStrategy != null) {
            this.setObjectQuotingStrategy(ObjectQuotingStrategy.valueOf(nodeObjectQuotingStrategy));
        }
        for (ParsedNode childNode : parsedNode.getChildren()) {
            this.handleChildNode(childNode, resourceAccessor, new HashMap<String, Object>());
        }
    }

    protected void expandExpressions(ParsedNode parsedNode) throws UnknownChangeLogParameterException {
        if (this.changeLogParameters == null) {
            return;
        }
        try {
            List<ParsedNode> children;
            Object value = parsedNode.getValue();
            if (value != null && value instanceof String) {
                parsedNode.setValue(this.changeLogParameters.expandExpressions(parsedNode.getValue(String.class), this));
            }
            if ((children = parsedNode.getChildren()) != null) {
                for (ParsedNode child : children) {
                    this.expandExpressions(child);
                }
            }
        }
        catch (ParsedNodeException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected void handleChildNode(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        this.handleChildNode(node, resourceAccessor, new HashMap<String, Object>());
    }

    /*
     * Unable to fully structure code
     */
    protected void handleChildNode(ParsedNode node, ResourceAccessor resourceAccessor, Map<String, Object> nodeScratch) throws ParsedNodeException, SetupException {
        this.expandExpressions(node);
        var5_5 = nodeName = node.getName();
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case 1455248018: {
                if (!var5_5.equals("changeSet")) break;
                var6_6 = 0;
                break;
            }
            case 2017342587: {
                if (!var5_5.equals("modifyChangeSets")) break;
                var6_6 = 1;
                break;
            }
            case 1942574248: {
                if (!var5_5.equals("include")) break;
                var6_6 = 2;
                break;
            }
            case 840141785: {
                if (!var5_5.equals("includeAll")) break;
                var6_6 = 3;
                break;
            }
            case -1006692933: {
                if (!var5_5.equals("preConditions")) break;
                var6_6 = 4;
                break;
            }
            case -993141291: {
                if (!var5_5.equals("property")) break;
                var6_6 = 5;
            }
        }
        switch (var6_6) {
            case 0: {
                if (!this.isDbmsMatch(node.getChildValue((String)null, "dbms", String.class))) break;
                this.addChangeSet(this.createChangeSet(node, resourceAccessor));
                break;
            }
            case 1: {
                modifyChangeSets = new ModifyChangeSets((String)node.getChildValue(null, "runWith"));
                nodeScratch = new HashMap<String, Object>();
                nodeScratch.put("modifyChangeSets", modifyChangeSets);
                for (ParsedNode modifyChildNode : node.getChildren()) {
                    this.handleChildNode(modifyChildNode, resourceAccessor, nodeScratch);
                }
                nodeScratch.remove("modifyChangeSets");
                break;
            }
            case 2: {
                path = node.getChildValue((String)null, "file", String.class);
                if (path == null) {
                    throw new UnexpectedLiquibaseException("No 'file' attribute on 'include'");
                }
                path = path.replace('\\', '/');
                includeContextFilter = new ContextExpression(node.getChildValue((String)null, "contextFilter", String.class));
                if (includeContextFilter.isEmpty()) {
                    includeContextFilter = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                }
                labels = new Labels(node.getChildValue((String)null, "labels", String.class));
                ignore = node.getChildValue((String)null, "ignore", Boolean.class);
                try {
                    this.include(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceAccessor, includeContextFilter, labels, ignore, OnUnknownFileFormat.FAIL, (ModifyChangeSets)nodeScratch.get("modifyChangeSets"));
                    break;
                }
                catch (LiquibaseException e) {
                    throw new SetupException(e);
                }
            }
            case 3: {
                path = node.getChildValue((String)null, "path", String.class);
                resourceFilterDef = node.getChildValue((String)null, "filter", String.class);
                if (resourceFilterDef == null) {
                    resourceFilterDef = node.getChildValue((String)null, "resourceFilter", String.class);
                }
                resourceFilter = null;
                if (resourceFilterDef != null) {
                    try {
                        resourceFilter = (IncludeAllFilter)Class.forName(resourceFilterDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new SetupException(e);
                    }
                }
                resourceComparatorDef = node.getChildValue((String)null, "resourceComparator", String.class);
                resourceComparator = null;
                if (resourceComparatorDef == null) {
                    resourceComparator = this.getStandardChangeLogComparator();
                } else {
                    try {
                        resourceComparator = (Comparator<String>)Class.forName(resourceComparatorDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("no resourceComparator defined - taking default implementation");
                        resourceComparator = this.getStandardChangeLogComparator();
                    }
                }
                includeContextFilter = new ContextExpression(node.getChildValue((String)null, "contextFilter", String.class));
                if (includeContextFilter.isEmpty()) {
                    includeContextFilter = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                }
                labels = new Labels(node.getChildValue((String)null, "labels", String.class));
                ignore = node.getChildValue((String)null, "ignore", Boolean.class);
                if (ignore == null) {
                    ignore = false;
                }
                this.includeAll(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceFilter, node.getChildValue(null, "errorIfMissingOrEmpty", true), resourceComparator, resourceAccessor, includeContextFilter, labels, ignore, (ModifyChangeSets)nodeScratch.get("modifyChangeSets"));
                break;
            }
            case 4: {
                parsedContainer = new PreconditionContainer();
                parsedContainer.load(node, resourceAccessor);
                this.preconditionContainer.addNestedPrecondition(parsedContainer);
                break;
            }
            case 5: {
                try {
                    contextFilter = node.getChildValue((String)null, "contextFilter", String.class);
                    if (StringUtil.isEmpty(contextFilter)) {
                        contextFilter = node.getChildValue((String)null, "context", String.class);
                    }
                    dbms = node.getChildValue((String)null, "dbms", String.class);
                    labels = node.getChildValue((String)null, "labels", String.class);
                    global = node.getChildValue((String)null, "global", Boolean.class);
                    if (global == null) {
                        global = true;
                    }
                    if ((file = node.getChildValue((String)null, "file", String.class)) == null) {
                        name = node.getChildValue((String)null, "name", String.class);
                        value = node.getChildValue((String)null, "value", String.class);
                        this.changeLogParameters.set(name, (Object)value, contextFilter, labels, dbms, (boolean)global, this);
                        ** break;
                    }
                    props = new Properties();
                    resource = resourceAccessor.get(file);
                    if (resource == null) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("Could not open properties file " + file);
                        ** break;
                    }
                    propertiesStream = resource.openInputStream();
                    var16_37 = null;
                    props.load(propertiesStream);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        this.changeLogParameters.set(entry.getKey().toString(), (Object)entry.getValue().toString(), contextFilter, labels, dbms, (boolean)global, this);
                    }
                    if (propertiesStream == null) break;
                    if (var16_37 == null) ** GOTO lbl132
                    try {
                        propertiesStream.close();
                    }
                    catch (Throwable var17_39) {
                        var16_37.addSuppressed(var17_39);
                    }
                    break;
lbl132:
                    // 1 sources

                    propertiesStream.close();
                    ** break;
                    catch (Throwable var17_40) {
                        try {
                            var16_37 = var17_40;
                            throw var17_40;
                        }
                        catch (Throwable var19_42) {
                            if (propertiesStream != null) {
                                if (var16_37 != null) {
                                    try {
                                        propertiesStream.close();
                                    }
                                    catch (Throwable var20_43) {
                                        var16_37.addSuppressed(var20_43);
                                    }
                                } else {
                                    propertiesStream.close();
                                }
                            }
                            throw var19_42;
lbl149:
                            // 3 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new ParsedNodeException(e);
                }
            }
            default: {
                if (node.getChildren() == null || node.getChildren().isEmpty()) break;
                throw new ParsedNodeException("Unexpected node found under databaseChangeLog: " + nodeName);
            }
        }
    }

    public boolean isDbmsMatch(String dbmsList) {
        return this.isDbmsMatch(DatabaseList.toDbmsSet(dbmsList));
    }

    public boolean isDbmsMatch(Set<String> dbmsSet) {
        return dbmsSet == null || this.changeLogParameters == null || this.changeLogParameters.getValue("database.typeName", this) == null || DatabaseList.definitionMatches(dbmsSet, this.changeLogParameters.getValue("database.typeName", this).toString(), true);
    }

    @Deprecated
    public void includeAll(String pathName, boolean isRelativeToChangelogFile, IncludeAllFilter resourceFilter, boolean errorIfMissingOrEmpty, Comparator<String> resourceComparator, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, LabelExpression labelExpression, boolean ignore) throws SetupException {
        Labels labels = null;
        if (labelExpression != null && !labelExpression.isEmpty()) {
            labels = new Labels(labelExpression.toString());
        }
        this.includeAll(pathName, isRelativeToChangelogFile, resourceFilter, errorIfMissingOrEmpty, resourceComparator, resourceAccessor, includeContextFilter, labels, ignore);
    }

    public void includeAll(String pathName, boolean isRelativeToChangelogFile, IncludeAllFilter resourceFilter, boolean errorIfMissingOrEmpty, Comparator<String> resourceComparator, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, Labels labels, boolean ignore) throws SetupException {
        this.includeAll(pathName, isRelativeToChangelogFile, resourceFilter, errorIfMissingOrEmpty, resourceComparator, resourceAccessor, includeContextFilter, labels, ignore, new ModifyChangeSets(null));
    }

    public void includeAll(String pathName, boolean isRelativeToChangelogFile, IncludeAllFilter resourceFilter, boolean errorIfMissingOrEmpty, Comparator<String> resourceComparator, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, Labels labels, boolean ignore, ModifyChangeSets modifyChangeSets) throws SetupException {
        try {
            List<Resource> unsortedResources;
            block13: {
                if (pathName == null) {
                    throw new SetupException("No path attribute for includeAll");
                }
                String relativeTo = null;
                if (isRelativeToChangelogFile) {
                    relativeTo = this.getPhysicalFilePath();
                }
                unsortedResources = null;
                try {
                    String path;
                    if (relativeTo == null) {
                        path = pathName;
                    } else {
                        path = resourceAccessor.get(relativeTo).resolveSibling(pathName).getPath();
                        path = Paths.get(path, new String[0]).normalize().toString().replace("\\", "/");
                    }
                    path = path.replace("\\", "/");
                    if (StringUtil.isNotEmpty(path) && !path.endsWith("/")) {
                        path = path + '/';
                    }
                    LOG.fine("includeAll for " + pathName);
                    LOG.fine("Using file opener for includeAll: " + resourceAccessor.toString());
                    unsortedResources = resourceAccessor.search(path, true);
                }
                catch (IOException e) {
                    if (!errorIfMissingOrEmpty) break block13;
                    throw e;
                }
            }
            TreeSet<Resource> resources = new TreeSet<Resource>((o1, o2) -> resourceComparator.compare(o1.getPath(), o2.getPath()));
            if (unsortedResources != null) {
                for (Resource resourcePath : unsortedResources) {
                    if (resourceFilter != null && !resourceFilter.include(resourcePath.getPath())) continue;
                    resources.add(resourcePath);
                }
            }
            if (resources.isEmpty() && errorIfMissingOrEmpty) {
                throw new SetupException("Could not find directory or directory was empty for includeAll '" + pathName + "'");
            }
            for (Resource resource : resources) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Reading resource: " + resource);
                this.include(resource.getPath(), false, resourceAccessor, includeContextFilter, labels, ignore, OnUnknownFileFormat.WARN, modifyChangeSets);
            }
        }
        catch (Exception e) {
            throw new SetupException(e);
        }
    }

    @Deprecated
    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, LabelExpression labelExpression, Boolean ignore, boolean logEveryUnknownFileFormat) throws LiquibaseException {
        Labels labels = null;
        if (labelExpression != null && !labelExpression.isEmpty()) {
            labels = new Labels(labelExpression.getLabels());
        }
        return this.include(fileName, isRelativePath, resourceAccessor, includeContextFilter, labels, ignore, logEveryUnknownFileFormat);
    }

    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, Labels labels, Boolean ignore, boolean logEveryUnknownFileFormat) throws LiquibaseException {
        return this.include(fileName, isRelativePath, resourceAccessor, includeContextFilter, labels, ignore, logEveryUnknownFileFormat ? OnUnknownFileFormat.WARN : OnUnknownFileFormat.SKIP);
    }

    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, Labels labels, Boolean ignore, OnUnknownFileFormat onUnknownFileFormat) throws LiquibaseException {
        return this.include(fileName, isRelativePath, resourceAccessor, includeContextFilter, labels, ignore, onUnknownFileFormat, new ModifyChangeSets(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContextFilter, Labels labels, Boolean ignore, OnUnknownFileFormat onUnknownFileFormat, ModifyChangeSets modifyChangeSets) throws LiquibaseException {
        DatabaseChangeLog changeLog;
        if (".svn".equalsIgnoreCase(fileName) || "cvs".equalsIgnoreCase(fileName)) {
            return false;
        }
        if (isRelativePath) {
            try {
                fileName = resourceAccessor.get(this.getPhysicalFilePath()).resolveSibling(fileName).getPath();
                fileName = Paths.get(fileName, new String[0]).normalize().toString().replace("\\", "/");
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        try {
            DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
            if (rootChangeLog == null) {
                ROOT_CHANGE_LOG.set(this);
            }
            DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
            PARENT_CHANGE_LOG.set(this);
            try {
                ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(fileName, resourceAccessor);
                changeLog = parser.parse(fileName, this.changeLogParameters, resourceAccessor);
                changeLog.setIncludeContextFilter(includeContextFilter);
                changeLog.setIncludeLabels(labels);
                changeLog.setIncludeIgnore(ignore != null ? ignore : false);
            }
            finally {
                if (rootChangeLog == null) {
                    ROOT_CHANGE_LOG.remove();
                }
                if (parentChangeLog == null) {
                    PARENT_CHANGE_LOG.remove();
                } else {
                    PARENT_CHANGE_LOG.set(parentChangeLog);
                }
            }
        }
        catch (UnknownChangelogFormatException e) {
            if (onUnknownFileFormat == OnUnknownFileFormat.FAIL) {
                throw e;
            }
            boolean matchesFileExtension = StringUtil.trimToEmpty(fileName).matches("\\.\\w+$");
            if (matchesFileExtension || onUnknownFileFormat == OnUnknownFileFormat.WARN) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("included file " + fileName + "/" + fileName + " is not a recognized file type");
            }
            return false;
        }
        PreconditionContainer preconditions = changeLog.getPreconditions();
        if (preconditions != null) {
            if (null == this.getPreconditions()) {
                this.setPreconditions(new PreconditionContainer());
            }
            this.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            if (changeSet.getRunWith() == null) {
                changeSet.setRunWith(modifyChangeSets != null ? modifyChangeSets.getRunWith() : null);
            }
            this.addChangeSet(changeSet);
        }
        return true;
    }

    protected ChangeSet createChangeSet(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ChangeSet changeSet = new ChangeSet(this);
        changeSet.setChangeLogParameters(this.getChangeLogParameters());
        changeSet.load(node, resourceAccessor);
        return changeSet;
    }

    protected Comparator<String> getStandardChangeLogComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.replace("WEB-INF/classes/", "").compareTo(o2.replace("WEB-INF/classes/", ""));
            }
        };
    }

    public static String normalizePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        String noClassPathReplaced = NON_CLASSPATH_PATTERN.matcher(filePath).replaceFirst("");
        String doubleBackSlashReplaced = DOUBLE_BACK_SLASH_PATTERN.matcher(noClassPathReplaced).replaceAll("/");
        String doubleSlashReplaced = DOUBLE_SLASH_PATTERN.matcher(doubleBackSlashReplaced).replaceAll("/");
        String slashDotSlashReplaced = SLASH_DOT_SLASH_PATTERN.matcher(doubleSlashReplaced).replaceAll("/");
        String noLetterReplaced = NO_LETTER_PATTERN.matcher(slashDotSlashReplaced).replaceFirst("");
        return DOT_SLASH_PATTERN.matcher(noLetterReplaced).replaceFirst("");
    }

    public void clearCheckSums() {
        for (ChangeSet changeSet : this.getChangeSets()) {
            changeSet.clearCheckSum();
        }
    }

    public static enum OnUnknownFileFormat {
        SKIP,
        WARN,
        FAIL;

    }

    @LiquibaseService(skip=true)
    private static class GlobalPreconditionContainer
    extends PreconditionContainer {
        private GlobalPreconditionContainer() {
        }

        @Override
        public PreconditionContainer.OnSqlOutputOption getOnSqlOutput() {
            return PreconditionContainer.OnSqlOutputOption.TEST;
        }

        @Override
        public void addNestedPrecondition(Precondition precondition) {
            super.addNestedPrecondition(precondition);
        }
    }

    private static class ModifyChangeSets {
        private final String runWith;

        public ModifyChangeSets(String runWith) {
            this.runWith = runWith;
        }

        public String getRunWith() {
            return this.runWith;
        }
    }
}

