/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.CommandBatchCursorHelper;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorResourceManager;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class CommandBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final MongoNamespace namespace;
    private final long maxTimeMS;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private int batchSize;
    private CommandCursorResult<T> commandCursorResult;
    @Nullable
    private List<T> nextBatch;

    CommandBatchCursor(BsonDocument commandCursorDocument, int batchSize, long maxTimeMS, Decoder<T> decoder, @Nullable BsonValue comment, ConnectionSource connectionSource, Connection connection) {
        ConnectionDescription connectionDescription = connection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", commandCursorDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = batchSize;
        this.maxTimeMS = maxTimeMS;
        this.decoder = decoder;
        this.comment = comment;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        Connection connectionToPin = connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? connection : null;
        this.resourceManager = new ResourceManager(this.namespace, connectionSource, connectionToPin, this.commandCursorResult.getServerCursor());
    }

    @Override
    public boolean hasNext() {
        return Assertions.assertNotNull(this.resourceManager.execute("Cursor has been closed", this::doHasNext));
    }

    private boolean doHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        while (this.resourceManager.getServerCursor() != null) {
            this.getMore();
            if (!this.resourceManager.operable()) {
                throw new IllegalStateException("Cursor has been closed");
            }
            if (this.nextBatch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        return Assertions.assertNotNull(this.resourceManager.execute("Iterator has been closed", this::doNext));
    }

    @Override
    public int available() {
        return !this.resourceManager.operable() || this.nextBatch == null ? 0 : this.nextBatch.size();
    }

    @Nullable
    private List<T> doNext() {
        if (!this.doHasNext()) {
            throw new NoSuchElementException();
        }
        List<T> retVal = this.nextBatch;
        this.nextBatch = null;
        return retVal;
    }

    boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Override
    @Nullable
    public List<T> tryNext() {
        return this.resourceManager.execute("Cursor has been closed", () -> {
            if (!this.tryHasNext()) {
                return null;
            }
            return this.doNext();
        });
    }

    private boolean tryHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        if (this.resourceManager.getServerCursor() != null) {
            this.getMore();
        }
        return this.nextBatch != null;
    }

    @Override
    @Nullable
    public ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.commandCursorResult.getServerAddress();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void getMore() {
        ServerCursor serverCursor = Assertions.assertNotNull(this.resourceManager.getServerCursor());
        this.resourceManager.executeWithConnection(connection -> {
            ServerCursor nextServerCursor;
            try {
                this.commandCursorResult = this.toCommandCursorResult(connection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(connection.command(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), connection.getDescription(), this.namespace, this.batchSize, this.maxTimeMS, this.comment), CommandBatchCursorHelper.NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), Assertions.assertNotNull((ConnectionSource)this.resourceManager.getConnectionSource()))));
                nextServerCursor = this.commandCursorResult.getServerCursor();
            }
            catch (MongoCommandException e) {
                throw CommandBatchCursorHelper.translateCommandException(e, serverCursor);
            }
            this.resourceManager.setServerCursor(nextServerCursor);
        });
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String fieldNameContainingBatch, BsonDocument commandCursorDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, fieldNameContainingBatch, commandCursorDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        this.nextBatch = commandCursorResult.getResults().isEmpty() ? null : commandCursorResult.getResults();
        return commandCursorResult;
    }

    @ThreadSafe
    private static final class ResourceManager
    extends CursorResourceManager<ConnectionSource, Connection> {
        ResourceManager(MongoNamespace namespace, ConnectionSource connectionSource, @Nullable Connection connectionToPin, @Nullable ServerCursor serverCursor) {
            super(namespace, connectionSource, connectionToPin, serverCursor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        <R> R execute(String exceptionMessageIfClosed, Supplier<R> operation) throws IllegalStateException {
            if (!this.tryStartOperation()) {
                throw new IllegalStateException(exceptionMessageIfClosed);
            }
            try {
                R r = operation.get();
                return r;
            }
            finally {
                this.endOperation();
            }
        }

        @Override
        void markAsPinned(Connection connectionToPin, Connection.PinningMode pinningMode) {
            connectionToPin.markAsPinned(pinningMode);
        }

        @Override
        void doClose() {
            block8: {
                if (this.isSkipReleasingServerResourcesOnClose()) {
                    this.unsetServerCursor();
                }
                try {
                    if (this.getServerCursor() == null) break block8;
                    Connection connection = this.getConnection();
                    try {
                        this.releaseServerResources(connection);
                    }
                    finally {
                        connection.release();
                    }
                }
                catch (MongoException mongoException) {
                }
                finally {
                    this.unsetServerCursor();
                    this.releaseClientResources();
                }
            }
        }

        void executeWithConnection(Consumer<Connection> action) {
            Connection connection = this.getConnection();
            try {
                action.accept(connection);
            }
            catch (MongoSocketException e) {
                this.onCorruptedConnection(connection, e);
                throw e;
            }
            finally {
                connection.release();
            }
        }

        private Connection getConnection() {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            Connection pinnedConnection = (Connection)this.getPinnedConnection();
            if (pinnedConnection == null) {
                return Assertions.assertNotNull((ConnectionSource)this.getConnectionSource()).getConnection();
            }
            return pinnedConnection.retain();
        }

        private void releaseServerResources(Connection connection) {
            try {
                ServerCursor localServerCursor = this.getServerCursor();
                if (localServerCursor != null) {
                    this.killServerCursor(this.getNamespace(), localServerCursor, connection);
                }
            }
            finally {
                this.unsetServerCursor();
            }
        }

        private void killServerCursor(MongoNamespace namespace, ServerCursor localServerCursor, Connection localConnection) {
            localConnection.command(namespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(namespace, localServerCursor), CommandBatchCursorHelper.NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), new BsonDocumentCodec(), Assertions.assertNotNull((ConnectionSource)this.getConnectionSource()));
        }
    }
}

