/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.MetadataDbTypeManager;
import org.mule.db.commons.internal.domain.type.StaticDbTypeManager;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;

public abstract class AbstractDbConnector
implements Initialisable {
    @DefaultEncoding
    protected String encoding;
    protected Charset charset;
    protected DbTypeManager typeManager;

    public void initialise() throws InitialisationException {
        this.typeManager = this.createBaseTypeManager();
        this.charset = Charset.forName(this.encoding);
    }

    public DbTypeManager getTypeManager() {
        return this.typeManager;
    }

    public Charset getCharset() {
        return this.charset;
    }

    protected DbTypeManager createBaseTypeManager() {
        ArrayList<DbTypeManager> typeManagers = new ArrayList<DbTypeManager>();
        typeManagers.add(new MetadataDbTypeManager());
        typeManagers.add(new StaticDbTypeManager(JdbcType.getAllTypes()));
        return new CompositeDbTypeManager(typeManagers);
    }
}

