/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.api;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.mule.extension.file.common.api.AbstractFileAttributes;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class LocalFileAttributes
extends AbstractFileAttributes {
    @Parameter
    private LocalDateTime lastModifiedTime;
    @Parameter
    private LocalDateTime lastAccessTime;
    @Parameter
    private LocalDateTime creationTime;
    @Parameter
    private long size;
    @Parameter
    private boolean regularFile;
    @Parameter
    private boolean directory;
    @Parameter
    private boolean symbolicLink;

    public LocalFileAttributes(Path path) {
        super(path);
        this.initAttributes(this.getAttributes(path));
    }

    public LocalFileAttributes(Path path, BasicFileAttributes attributes) {
        super(path);
        this.initAttributes(attributes);
    }

    protected void initAttributes(BasicFileAttributes attributes) {
        this.lastModifiedTime = this.asDateTime(attributes.lastModifiedTime());
        this.lastAccessTime = this.asDateTime(attributes.lastAccessTime());
        this.creationTime = this.asDateTime(attributes.creationTime());
        this.size = attributes.size();
        this.regularFile = attributes.isRegularFile();
        this.directory = attributes.isDirectory();
        this.symbolicLink = Files.isSymbolicLink(Paths.get(this.getPath(), new String[0]));
    }

    public LocalDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LocalDateTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isRegularFile() {
        return this.regularFile;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }

    private BasicFileAttributes getAttributes(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not read attributes for file " + path)), (Throwable)e);
        }
    }

    private LocalDateTime asDateTime(FileTime fileTime) {
        return LocalDateTime.ofInstant(fileTime.toInstant(), ZoneId.systemDefault());
    }
}

