/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.api;

import java.time.LocalDateTime;
import java.util.function.Predicate;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.common.api.matcher.FileMatcher;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Alias(value="matcher")
@TypeDsl(allowTopLevelDefinition=true)
public class LocalFileMatcher
extends FileMatcher<LocalFileMatcher, LocalFileAttributes> {
    @Parameter
    @Optional
    private LocalDateTime createdSince;
    @Parameter
    @Optional
    private LocalDateTime createdUntil;
    @Parameter
    @Optional
    private LocalDateTime updatedSince;
    @Parameter
    @Optional
    private LocalDateTime updatedUntil;
    @Parameter
    @Optional
    private LocalDateTime accessedSince;
    @Parameter
    @Optional
    private LocalDateTime accessedUntil;

    protected Predicate<LocalFileAttributes> addConditions(Predicate<LocalFileAttributes> predicate) {
        if (this.createdSince != null) {
            predicate = predicate.and(attributes -> FILE_TIME_SINCE.apply(this.createdSince, attributes.getCreationTime()));
        }
        if (this.createdUntil != null) {
            predicate = predicate.and(attributes -> FILE_TIME_UNTIL.apply(this.createdUntil, attributes.getCreationTime()));
        }
        if (this.updatedSince != null) {
            predicate = predicate.and(attributes -> FILE_TIME_SINCE.apply(this.updatedSince, attributes.getLastModifiedTime()));
        }
        if (this.updatedUntil != null) {
            predicate = predicate.and(attributes -> FILE_TIME_UNTIL.apply(this.updatedUntil, attributes.getLastModifiedTime()));
        }
        if (this.accessedSince != null) {
            predicate = predicate.and(attributes -> FILE_TIME_SINCE.apply(this.accessedSince, attributes.getLastAccessTime()));
        }
        if (this.accessedUntil != null) {
            predicate = predicate.and(attributes -> FILE_TIME_SINCE.apply(this.accessedUntil, attributes.getLastAccessTime()));
        }
        return predicate;
    }

    public LocalFileMatcher setCreatedSince(LocalDateTime createdSince) {
        this.createdSince = createdSince;
        return this;
    }

    public LocalFileMatcher setCreatedUntil(LocalDateTime createdUntil) {
        this.createdUntil = createdUntil;
        return this;
    }

    public LocalFileMatcher setUpdatedSince(LocalDateTime updatedSince) {
        this.updatedSince = updatedSince;
        return this;
    }

    public LocalFileMatcher setUpdatedUntil(LocalDateTime updatedUntil) {
        this.updatedUntil = updatedUntil;
        return this;
    }

    public LocalFileMatcher setAccessedSince(LocalDateTime accessedSince) {
        this.accessedSince = accessedSince;
        return this;
    }

    public LocalFileMatcher setAccessedUntil(LocalDateTime accessedUntil) {
        this.accessedUntil = accessedUntil;
        return this;
    }

    public LocalDateTime getCreatedSince() {
        return this.createdSince;
    }

    public LocalDateTime getCreatedUntil() {
        return this.createdUntil;
    }

    public LocalDateTime getUpdatedSince() {
        return this.updatedSince;
    }

    public LocalDateTime getUpdatedUntil() {
        return this.updatedUntil;
    }

    public LocalDateTime getAccessedSince() {
        return this.accessedSince;
    }

    public LocalDateTime getAccessedUntil() {
        return this.accessedUntil;
    }
}

