/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal;

import java.io.InputStream;
import java.util.List;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.api.LocalFileMatcher;
import org.mule.extension.file.common.api.BaseFileSystemOperations;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.exceptions.FileCopyErrorTypeProvider;
import org.mule.extension.file.common.api.exceptions.FileDeleteErrorTypeProvider;
import org.mule.extension.file.common.api.exceptions.FileListErrorTypeProvider;
import org.mule.extension.file.common.api.exceptions.FileReadErrorTypeProvider;
import org.mule.extension.file.common.api.exceptions.FileRenameErrorTypeProvider;
import org.mule.extension.file.common.api.exceptions.FileWriteErrorTypeProvider;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class FileOperations
extends BaseFileSystemOperations {
    @Summary(value="List all the files from given directory")
    @Throws(value={FileListErrorTypeProvider.class})
    public List<Result<InputStream, LocalFileAttributes>> list(@Config FileConnectorConfig config, @Connection LocalFileSystem fileSystem, @Path(type=PathModel.Type.DIRECTORY, location=PathModel.Location.EXTERNAL) String directoryPath, @Optional(defaultValue="false") boolean recursive, @Optional @DisplayName(value="File Matching Rules") @Summary(value="Matcher to filter the listed files") LocalFileMatcher matcher) {
        List result = this.doList(config, (FileSystem)fileSystem, directoryPath, recursive, matcher);
        return result;
    }

    @Summary(value="Obtains the content and metadata of a file at a given path")
    @Throws(value={FileReadErrorTypeProvider.class})
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, LocalFileAttributes> read(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @DisplayName(value="File Path") @Path(type=PathModel.Type.FILE, location=PathModel.Location.EXTERNAL) String path, @Optional(defaultValue="false") @Placement(tab="Advanced") boolean lock) {
        Result result = this.doRead(config, fileSystem, path, lock);
        return result;
    }

    @Summary(value="Writes the given \"Content\" in the file pointed by \"Path\"")
    @Throws(value={FileWriteErrorTypeProvider.class})
    public void write(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @Path(type=PathModel.Type.FILE, location=PathModel.Location.EXTERNAL) String path, @Content @Summary(value="Content to be written into the file") InputStream content, @Optional @Summary(value="Encoding when trying to write a String file. If not set, defaults to the configuration one or the Mule default") @Placement(tab="Advanced") String encoding, @Optional(defaultValue="true") boolean createParentDirectories, @Optional(defaultValue="false") @Placement(tab="Advanced") boolean lock, @Optional(defaultValue="OVERWRITE") @Summary(value="How the file is going to be written") @DisplayName(value="Write Mode") FileWriteMode mode) {
        super.doWrite(config, fileSystem, path, content, encoding, createParentDirectories, lock, mode);
    }

    @Summary(value="Copies a file")
    @Throws(value={FileCopyErrorTypeProvider.class})
    public void copy(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @Path(location=PathModel.Location.EXTERNAL) String sourcePath, @Path(location=PathModel.Location.EXTERNAL) String targetPath, @Optional(defaultValue="true") boolean createParentDirectories, @Optional(defaultValue="false") boolean overwrite, @Optional String renameTo) {
        super.doCopy(config, fileSystem, sourcePath, targetPath, createParentDirectories, overwrite, renameTo);
    }

    @Summary(value="Moves a file")
    @Throws(value={FileCopyErrorTypeProvider.class})
    public void move(@Config FileConnectorConfig config, @Connection FileSystem fileSystem, @Path(location=PathModel.Location.EXTERNAL) String sourcePath, @Path(type=PathModel.Type.DIRECTORY, location=PathModel.Location.EXTERNAL) String targetPath, @Optional(defaultValue="true") boolean createParentDirectories, @Optional(defaultValue="false") boolean overwrite, @Optional String renameTo) {
        super.doMove(config, fileSystem, sourcePath, targetPath, createParentDirectories, overwrite, renameTo);
    }

    @Summary(value="Deletes a file")
    @Throws(value={FileDeleteErrorTypeProvider.class})
    public void delete(@Connection FileSystem fileSystem, @Path(location=PathModel.Location.EXTERNAL) String path) {
        super.doDelete(fileSystem, path);
    }

    @Summary(value="Renames a file")
    @Throws(value={FileRenameErrorTypeProvider.class})
    public void rename(@Connection FileSystem fileSystem, @Path(location=PathModel.Location.EXTERNAL) String path, @DisplayName(value="New Name") String to, @Optional(defaultValue="false") boolean overwrite) {
        super.doRename(fileSystem, path, to, overwrite);
    }

    @Summary(value="Creates a new directory")
    @Throws(value={FileRenameErrorTypeProvider.class})
    public void createDirectory(@Connection FileSystem fileSystem, @Path(type=PathModel.Type.DIRECTORY, location=PathModel.Location.EXTERNAL) String directoryPath) {
        super.doCreateDirectory(fileSystem, directoryPath);
    }
}

