/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.mule.extension.file.api.exception.FileConnectionException;
import org.mule.extension.file.common.api.FileSystemProvider;
import org.mule.extension.file.common.api.exceptions.FileError;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="Local FileSystem Connection")
public final class LocalFileConnectionProvider
extends FileSystemProvider<LocalFileSystem>
implements CachedConnectionProvider<LocalFileSystem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileConnectionProvider.class);
    @Parameter
    @Optional
    @DisplayName(value="Working Directory")
    @Summary(value="Directory to be considered as the root of every relative path used with this connector. Defaults to the user's home")
    @Path(location=PathModel.Location.EXTERNAL)
    private String workingDir;

    public LocalFileSystem connect() throws ConnectionException {
        this.validateWorkingDir();
        return new LocalFileSystem(this.workingDir);
    }

    public void disconnect(LocalFileSystem localFileSystem) {
    }

    public ConnectionValidationResult validate(LocalFileSystem fileSystem) {
        return ConnectionValidationResult.success();
    }

    private void validateWorkingDir() throws ConnectionException {
        java.nio.file.Path workingDirPath;
        if (this.workingDir == null) {
            this.workingDir = System.getProperty("user.home");
            if (this.workingDir == null) {
                throw new FileConnectionException("Could not obtain user's home directory. Please provide a explicit value for the workingDir parameter", FileError.ILLEGAL_PATH);
            }
            LOGGER.warn("File connector '{}' does not specify the workingDir property. Defaulting to '{}'", (Object)this.getConfigName(), (Object)this.workingDir);
        }
        if (Files.notExists(workingDirPath = Paths.get(this.workingDir, new String[0]), new LinkOption[0])) {
            throw new FileConnectionException(String.format("Provided workingDir '%s' does not exists", workingDirPath.toAbsolutePath()), FileError.FILE_DOESNT_EXIST);
        }
        if (!Files.isDirectory(workingDirPath, new LinkOption[0])) {
            throw new FileConnectionException(String.format("Provided workingDir '%s' is not a directory", workingDirPath.toAbsolutePath()), FileError.FILE_IS_NOT_DIRECTORY);
        }
    }

    public String getWorkingDir() {
        return this.workingDir;
    }
}

