/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal;

import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.common.api.AbstractFileSystem;
import org.mule.extension.file.common.api.command.CopyCommand;
import org.mule.extension.file.common.api.command.CreateDirectoryCommand;
import org.mule.extension.file.common.api.command.DeleteCommand;
import org.mule.extension.file.common.api.command.ListCommand;
import org.mule.extension.file.common.api.command.MoveCommand;
import org.mule.extension.file.common.api.command.ReadCommand;
import org.mule.extension.file.common.api.command.RenameCommand;
import org.mule.extension.file.common.api.command.WriteCommand;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.internal.command.LocalCopyCommand;
import org.mule.extension.file.internal.command.LocalCreateDirectoryCommand;
import org.mule.extension.file.internal.command.LocalDeleteCommand;
import org.mule.extension.file.internal.command.LocalListCommand;
import org.mule.extension.file.internal.command.LocalMoveCommand;
import org.mule.extension.file.internal.command.LocalReadCommand;
import org.mule.extension.file.internal.command.LocalRenameCommand;
import org.mule.extension.file.internal.command.LocalWriteCommand;
import org.mule.extension.file.internal.lock.FileChannelPathLock;

public final class LocalFileSystem
extends AbstractFileSystem<LocalFileAttributes> {
    private final CopyCommand copyCommand = new LocalCopyCommand(this);
    private final CreateDirectoryCommand createDirectoryCommand = new LocalCreateDirectoryCommand(this);
    private final DeleteCommand deleteCommand = new LocalDeleteCommand(this);
    private final ListCommand<LocalFileAttributes> listCommand = new LocalListCommand(this);
    private final MoveCommand moveCommand = new LocalMoveCommand(this);
    private final ReadCommand<LocalFileAttributes> readCommand = new LocalReadCommand(this);
    private final RenameCommand renameCommand = new LocalRenameCommand(this);
    private final WriteCommand writeCommand = new LocalWriteCommand(this);

    public LocalFileSystem(String basePath) {
        super(basePath);
    }

    protected CopyCommand getCopyCommand() {
        return this.copyCommand;
    }

    public CreateDirectoryCommand getCreateDirectoryCommand() {
        return this.createDirectoryCommand;
    }

    protected DeleteCommand getDeleteCommand() {
        return this.deleteCommand;
    }

    protected ListCommand getListCommand() {
        return this.listCommand;
    }

    protected MoveCommand getMoveCommand() {
        return this.moveCommand;
    }

    protected ReadCommand getReadCommand() {
        return this.readCommand;
    }

    protected RenameCommand getRenameCommand() {
        return this.renameCommand;
    }

    protected WriteCommand getWriteCommand() {
        return this.writeCommand;
    }

    protected PathLock createLock(Path path) {
        throw new UnsupportedOperationException("Use lock(Path, FileChannel) instead");
    }

    public PathLock lock(Path path, FileChannel channel) {
        FileChannelPathLock lock = new FileChannelPathLock(path, channel);
        this.acquireLock(lock);
        return lock;
    }

    public void changeToBaseDir() {
    }
}

