/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;

abstract class AbstractLocalCopyCommand
extends LocalFileCommand {
    AbstractLocalCopyCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    protected final void execute(String sourcePath, String target, boolean overwrite, boolean createParentDirectory, String renameTo) {
        Path source = this.resolveExistingPath(sourcePath);
        Path targetPath = this.resolvePath(target);
        String targetFileName = StringUtils.isBlank((CharSequence)renameTo) ? source.getFileName().toString() : renameTo;
        StandardCopyOption copyOption = null;
        if (Files.exists(targetPath = this.buildTargetPath(overwrite, createParentDirectory, source, targetPath, targetFileName), new LinkOption[0])) {
            if (overwrite) {
                copyOption = StandardCopyOption.REPLACE_EXISTING;
            } else {
                throw this.alreadyExistsException(targetPath);
            }
        }
        try {
            CopyOption[] copyOptionArray;
            if (copyOption != null) {
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = copyOption;
            } else {
                copyOptionArray = new CopyOption[]{};
            }
            this.doExecute(source, targetPath, overwrite, copyOptionArray);
        }
        catch (FileAlreadyExistsException e) {
            throw new org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException(String.format("Can't %s '%s' to '%s' because the destination path already exists. Consider setting the 'overwrite' parameter to 'true'", this.getAction(), source.toAbsolutePath(), targetPath.toAbsolutePath()));
        }
        catch (Exception e) {
            throw this.exception(String.format("An error occurred while executing '%s' operation on file '%s' to '%s': %s", this.getAction(), source, targetPath, e.getMessage()), e);
        }
    }

    private Path buildTargetPath(boolean overwrite, boolean createParentDirectory, Path source, Path targetPath, String targetFileName) {
        if (Files.exists(targetPath, new LinkOption[0])) {
            if (Files.isDirectory(targetPath, new LinkOption[0])) {
                if (Files.isDirectory(source, new LinkOption[0]) && source.getFileName().equals(targetPath.getFileName()) && !overwrite) {
                    throw this.alreadyExistsException(targetPath);
                }
                targetPath = targetPath.resolve(targetFileName);
            } else if (!overwrite) {
                throw this.alreadyExistsException(targetPath);
            }
        } else if (createParentDirectory) {
            targetPath.toFile().mkdirs();
            targetPath = targetPath.resolve(targetFileName);
        } else {
            throw new IllegalPathException(String.format("Can't %s '%s' to '%s' because the destination path doesn't exist", this.getAction(), source.toAbsolutePath(), targetPath.toAbsolutePath()));
        }
        return targetPath;
    }

    protected abstract void doExecute(Path var1, Path var2, boolean var3, CopyOption[] var4) throws Exception;

    protected abstract String getAction();
}

