/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.mule.extension.file.common.api.command.CreateDirectoryCommand;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;

public final class LocalCreateDirectoryCommand
extends LocalFileCommand
implements CreateDirectoryCommand {
    public LocalCreateDirectoryCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public void createDirectory(String directoryPath) {
        Path target = this.resolvePath(directoryPath);
        if (Files.exists(target, new LinkOption[0])) {
            throw new FileAlreadyExistsException(String.format("Directory '%s' already exists", target.toAbsolutePath()));
        }
        this.mkdirs(target);
    }
}

