/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.mule.extension.file.common.api.command.DeleteCommand;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalDeleteCommand
extends LocalFileCommand
implements DeleteCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDeleteCommand.class);

    public LocalDeleteCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public void delete(String filePath) {
        Path path = this.resolveExistingPath(filePath);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Preparing to delete '{}'", (Object)path);
        }
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        LocalDeleteCommand.this.doDelete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (super.postVisitDirectory(dir, exc) == FileVisitResult.CONTINUE) {
                            LocalDeleteCommand.this.doDelete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                this.doDelete(path);
            }
        }
        catch (AccessDeniedException e) {
            throw new FileAccessDeniedException(String.format("Could not delete file '%s' because access was denied by the operating system", path), (Exception)e);
        }
        catch (IOException e) {
            throw this.exception(String.format("Could not delete '%s'", path), e);
        }
    }

    private void doDelete(Path path) throws IOException {
        Files.delete(path);
        this.logDeletion(path);
    }

    private void logDeletion(Path path) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully deleted '{}'", (Object)path);
        }
    }
}

