/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.command.FileCommand;
import org.mule.extension.file.internal.LocalFileSystem;

abstract class LocalFileCommand
extends FileCommand<LocalFileSystem> {
    LocalFileCommand(LocalFileSystem fileSystem) {
        super((FileSystem)fileSystem);
    }

    protected Path getBasePath(FileSystem fileSystem) {
        return Paths.get(fileSystem.getBasePath(), new String[0]);
    }

    protected boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    protected void doMkDirs(Path directoryPath) {
        File target = directoryPath.toFile();
        try {
            if (!target.mkdirs()) {
                throw this.exception(String.format("Directory '%s' could not be created", target));
            }
        }
        catch (Exception e) {
            throw this.exception(String.format("Exception was found creating directory '%s'", target), e);
        }
    }
}

