/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.command.ListCommand;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class LocalListCommand
extends LocalFileCommand
implements ListCommand<LocalFileAttributes> {
    public LocalListCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public List<Result<InputStream, LocalFileAttributes>> list(FileConnectorConfig config, String directoryPath, boolean recursive, Predicate<LocalFileAttributes> matcher) {
        Path path = this.resolveExistingPath(directoryPath);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw this.cannotListFileException(path);
        }
        LinkedList<Result<InputStream, LocalFileAttributes>> accumulator = new LinkedList<Result<InputStream, LocalFileAttributes>>();
        this.doList(config, path.toFile(), accumulator, recursive, matcher);
        return accumulator;
    }

    private void doList(FileConnectorConfig config, File parent, List<Result<InputStream, LocalFileAttributes>> accumulator, boolean recursive, Predicate<LocalFileAttributes> matcher) {
        if (!parent.canRead()) {
            throw new FileAccessDeniedException(String.format("Could not list files from directory '%s' because access was denied by the operating system", parent.getAbsolutePath()));
        }
        for (File child : parent.listFiles()) {
            Path path = child.toPath();
            LocalFileAttributes attributes = new LocalFileAttributes(path);
            if (!matcher.test(attributes)) continue;
            if (child.isDirectory()) {
                accumulator.add((Result<InputStream, LocalFileAttributes>)Result.builder().output(null).attributes((Object)attributes).build());
                if (!recursive) continue;
                this.doList(config, child, accumulator, recursive, matcher);
                continue;
            }
            accumulator.add((Result<InputStream, LocalFileAttributes>)((LocalFileSystem)this.fileSystem).read(config, child.getAbsolutePath(), false));
        }
    }
}

