/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.command.MoveCommand;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.AbstractLocalCopyCommand;

public final class LocalMoveCommand
extends AbstractLocalCopyCommand
implements MoveCommand {
    public LocalMoveCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public void move(FileConnectorConfig config, String sourcePath, String targetDirectory, boolean overwrite, boolean createParentDirectories, String renameTo) {
        this.execute(sourcePath, targetDirectory, overwrite, createParentDirectories, renameTo);
    }

    @Override
    protected void doExecute(Path source, Path targetPath, boolean overwrite, CopyOption[] options) throws Exception {
        if (Files.isDirectory(source, new LinkOption[0])) {
            if (Files.exists(targetPath, new LinkOption[0])) {
                if (overwrite) {
                    org.mule.runtime.core.api.util.FileUtils.deleteTree((File)targetPath.toFile());
                } else {
                    this.alreadyExistsException(targetPath);
                }
            }
            FileUtils.moveDirectory((File)source.toFile(), (File)targetPath.toFile());
        } else {
            Files.move(source, targetPath, options);
        }
    }

    @Override
    protected String getAction() {
        return "move";
    }
}

