/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.FileConnectorConfig;
import org.mule.extension.file.common.api.command.ReadCommand;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.common.api.lock.NullPathLock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.internal.FileInputStream;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class LocalReadCommand
extends LocalFileCommand
implements ReadCommand<LocalFileAttributes> {
    public LocalReadCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public Result<InputStream, LocalFileAttributes> read(FileConnectorConfig config, String filePath, boolean lock) {
        Path path = this.resolveExistingPath(filePath);
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw this.cannotReadDirectoryException(path);
        }
        if (!Files.isReadable(path)) {
            throw new FileAccessDeniedException(String.format("Could not read the file '%s' because access was denied by the operating system", path));
        }
        FileChannel channel = null;
        NullPathLock pathLock = null;
        FileInputStream payload = null;
        try {
            if (lock) {
                channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
                pathLock = ((LocalFileSystem)this.fileSystem).lock(path, channel);
            } else {
                channel = FileChannel.open(path, StandardOpenOption.READ);
                pathLock = new NullPathLock(path);
            }
            payload = new FileInputStream(channel, (PathLock)pathLock);
            LocalFileAttributes fileAttributes = new LocalFileAttributes(path);
            return Result.builder().output((Object)payload).mediaType(((LocalFileSystem)this.fileSystem).getFileMessageMediaType((FileAttributes)fileAttributes)).attributes((Object)fileAttributes).build();
        }
        catch (AccessDeniedException e) {
            this.onException((InputStream)((Object)payload), channel, (PathLock)pathLock);
            throw new FileAccessDeniedException(String.format("Access to path '%s' denied by the operating system", path), (Exception)e);
        }
        catch (Exception e) {
            this.onException((InputStream)((Object)payload), channel, (PathLock)pathLock);
            throw this.exception(String.format("Unexpected error reading file '%s': %s", path, e.getMessage()), e);
        }
    }

    private void onException(InputStream payload, FileChannel channel, PathLock lock) {
        IOUtils.closeQuietly((Closeable)payload);
        IOUtils.closeQuietly((Closeable)channel);
        if (lock != null) {
            lock.release();
        }
    }
}

