/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.mule.extension.file.common.api.command.RenameCommand;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;

public final class LocalRenameCommand
extends LocalFileCommand
implements RenameCommand {
    public LocalRenameCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public void rename(String filePath, String newName, boolean overwrite) {
        Path source = this.resolveExistingPath(filePath);
        Path target = source.getParent().resolve(newName);
        if (Files.exists(target, new LinkOption[0])) {
            if (!overwrite) {
                throw new FileAlreadyExistsException(String.format("'%s' cannot be renamed because '%s' already exists", source, target));
            }
            try {
                ((LocalFileSystem)this.fileSystem).delete(target.toString());
            }
            catch (Exception e) {
                throw this.exception(String.format("Exception was found deleting '%s' as part of renaming '%s'", target, source), e);
            }
        }
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AccessDeniedException e) {
            throw new FileAccessDeniedException(String.format("Could not rename the file '%s' to '%s' because access was denied by the operating system", source, target), (Exception)e);
        }
        catch (Exception e) {
            throw this.exception(String.format("Exception was found renaming '%s' to '%s'", source, newName), e);
        }
    }
}

