/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.command;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.mule.extension.file.common.api.FileWriteMode;
import org.mule.extension.file.common.api.command.WriteCommand;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.extension.file.common.api.lock.NullPathLock;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.LocalFileCommand;
import org.mule.runtime.extension.api.exception.ModuleException;

public final class LocalWriteCommand
extends LocalFileCommand
implements WriteCommand {
    public LocalWriteCommand(LocalFileSystem fileSystem) {
        super(fileSystem);
    }

    public void write(String filePath, InputStream content, FileWriteMode mode, boolean lock, boolean createParentDirectory, String encoding) {
        Path path = this.resolvePath(filePath);
        this.assureParentFolderExists(path, createParentDirectory);
        FileChannel channel = null;
        NullPathLock pathLock = null;
        try {
            channel = FileChannel.open(path, this.getOpenOptions(mode));
            pathLock = lock ? ((LocalFileSystem)this.fileSystem).lock(path, channel) : new NullPathLock(path);
            try (OutputStream out = Channels.newOutputStream(channel);){
                IOUtils.copy((InputStream)content, (OutputStream)out);
            }
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (FileAlreadyExistsException e) {
            throw new org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException(String.format("Cannot write to path '%s' because it already exists and write mode '%s' was selected. Use a different write mode or point to a path which doesn't exist", path, mode), (Exception)e);
        }
        catch (AccessDeniedException e) {
            throw new FileAccessDeniedException(String.format("Could not write to file '%s' because access was denied by the operating system", path), (Exception)e);
        }
        catch (FileSystemException e) {
            if ("Is a directory".equals(e.getReason())) {
                throw new IllegalPathException(String.format("Cannot write to path '%s' because it is a Directory.", path), (Exception)e);
            }
            throw this.exception(String.format("Exception was found writing to file '%s'", path), e);
        }
        catch (Exception e) {
            throw this.exception(String.format("Exception was found writing to file '%s'", path), e);
        }
        finally {
            if (pathLock != null) {
                pathLock.release();
            }
            IOUtils.closeQuietly((Closeable)channel);
        }
    }

    private OpenOption[] getOpenOptions(FileWriteMode mode) {
        switch (mode) {
            case APPEND: {
                return new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
            }
            case CREATE_NEW: {
                return new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW};
            }
            case OVERWRITE: {
                return new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            }
        }
        throw new IllegalArgumentException("Unsupported write mode " + mode);
    }
}

