/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.lock;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import org.mule.extension.file.common.api.exceptions.FileAccessDeniedException;
import org.mule.extension.file.common.api.exceptions.FileLockedException;
import org.mule.extension.file.common.api.lock.PathLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileChannelPathLock
implements PathLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileChannelPathLock.class);
    private final Path path;
    private final FileChannel channel;
    private FileLock lock;

    public FileChannelPathLock(Path path, FileChannel channel) {
        this.path = path.toAbsolutePath();
        this.channel = channel;
    }

    public boolean tryLock() {
        if (this.isLocked()) {
            throw new FileLockedException("Lock is already acquired");
        }
        try {
            this.lock = this.channel.tryLock();
            return this.isLocked();
        }
        catch (AccessDeniedException e) {
            this.release();
            throw new FileAccessDeniedException(String.format("Could not obtain lock on path ''%s'' because access was denied by the operating system", this.path), (Exception)e);
        }
        catch (Exception e) {
            this.release();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Could not obtain lock on path ''%s'' due to the following exception", this.path), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    public void release() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Found exception attempting to release lock on path '%s'", this.path), (Throwable)e);
                }
            }
            finally {
                this.lock = null;
            }
        }
    }

    public Path getPath() {
        return this.path;
    }
}

