/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.internal.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.mule.extension.file.api.LocalFileAttributes;
import org.mule.extension.file.api.LocalFileMatcher;
import org.mule.extension.file.api.WatermarkMode;
import org.mule.extension.file.common.api.FileAttributes;
import org.mule.extension.file.common.api.lock.NullPathLock;
import org.mule.extension.file.common.api.lock.PathLock;
import org.mule.extension.file.common.api.matcher.NullFilePayloadPredicate;
import org.mule.extension.file.internal.FileConnector;
import org.mule.extension.file.internal.FileInputStream;
import org.mule.extension.file.internal.LocalFileSystem;
import org.mule.extension.file.internal.command.OnNewFileCommand;
import org.mule.extension.file.internal.source.PostActionGroup;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="*/*", strict=false)
@DisplayName(value="On New or Updated File")
@Summary(value="Triggers when a new file is created in a directory")
@Alias(value="listener")
public class DirectoryListener
extends PollingSource<InputStream, FileAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryListener.class);
    private static final String ATTRIBUTES_CONTEXT_VAR = "attributes";
    private static final String POST_PROCESSING_GROUP_NAME = "Post processing action";
    @Config
    private FileConnector config;
    @Connection
    private ConnectionProvider<LocalFileSystem> fileSystemProvider;
    @Parameter
    @Optional
    private String directory;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether or not to also catch files created on sub directories")
    private boolean recursive = true;
    @Parameter
    @Optional
    @Alias(value="matcher")
    @DisplayName(value="Matcher")
    private LocalFileMatcher predicateBuilder;
    @Parameter
    @Optional(defaultValue="DISABLED")
    private WatermarkMode watermarkMode = WatermarkMode.DISABLED;
    private Path directoryPath;
    private LocalFileSystem fileSystem;
    private ComponentLocation location;
    private Predicate<LocalFileAttributes> matcher;

    protected void doStart() throws MuleException {
        this.fileSystem = (LocalFileSystem)((Object)this.fileSystemProvider.connect());
        this.matcher = this.predicateBuilder != null ? this.predicateBuilder.build() : new NullFilePayloadPredicate();
        this.directoryPath = this.resolveRootPath();
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Post processing action") PostActionGroup postAction, SourceCallbackContext ctx) {
        this.postAction(postAction, ctx);
    }

    @OnError
    public void onError(@ParameterGroup(name="Post processing action") PostActionGroup postAction, SourceCallbackContext ctx) {
        if (postAction.isApplyPostActionWhenFailed()) {
            this.postAction(postAction, ctx);
        }
    }

    @OnTerminate
    public void onTerminate() {
    }

    public void poll(PollContext<InputStream, FileAttributes> pollContext) {
        PollWalker walker = new PollWalker(this.directoryPath, pollContext);
        try {
            Files.walkFileTree(this.directoryPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, walker);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Found exception trying to poll directory '%s'. Will try again on the next poll. ", this.directoryPath.toString(), e.getMessage()), (Throwable)e);
        }
    }

    private void postAction(PostActionGroup postAction, SourceCallbackContext ctx) {
        try {
            postAction.validateSelf();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
        }
        ctx.getVariable(ATTRIBUTES_CONTEXT_VAR).ifPresent(attrs -> {
            if (postAction.isAutoDelete()) {
                this.fileSystem.delete(attrs.getPath());
            } else if (postAction.getMoveToDirectory() != null) {
                this.fileSystem.move(this.config, attrs.getPath(), postAction.getMoveToDirectory(), false, true, postAction.getRenameTo());
            }
        });
    }

    private Result<InputStream, FileAttributes> createResult(Path path, FileAttributes attributes) {
        FileInputStream payload = null;
        FileChannel channel = null;
        try {
            channel = FileChannel.open(path, new OpenOption[0]);
            payload = new FileInputStream(channel, (PathLock)new NullPathLock(path));
            return Result.builder().output((Object)payload).mediaType(this.fileSystem.getFileMessageMediaType(attributes)).attributes((Object)attributes).build();
        }
        catch (Exception e) {
            IOUtils.closeQuietly(payload);
            IOUtils.closeQuietly((Closeable)channel);
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void onRejectedItem(Result<InputStream, FileAttributes> result, SourceCallbackContext callbackContext) {
        IOUtils.closeQuietly((Closeable)((Closeable)result.getOutput()));
    }

    protected void doStop() {
        if (this.fileSystem != null) {
            this.fileSystemProvider.disconnect((Object)this.fileSystem);
        }
    }

    private Path resolveRootPath() {
        return new OnNewFileCommand(this.fileSystem).resolveRootPath(this.directory);
    }

    private class PollWalker
    extends SimpleFileVisitor<Path> {
        private final Path directoryPath;
        private final PollContext<InputStream, FileAttributes> pollContext;

        public PollWalker(Path directoryPath, PollContext<InputStream, FileAttributes> pollContext) {
            this.directoryPath = directoryPath;
            this.pollContext = pollContext;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.directoryPath.equals(dir)) {
                return FileVisitResult.CONTINUE;
            }
            return DirectoryListener.this.recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.pollContext.isSourceStopping()) {
                return FileVisitResult.TERMINATE;
            }
            LocalFileAttributes attributes = new LocalFileAttributes(file, attrs);
            if (!DirectoryListener.this.matcher.test(attributes)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skipping file '{}' because the matcher rejected it", (Object)attributes.getPath());
                }
                return FileVisitResult.CONTINUE;
            }
            this.pollContext.accept(item -> {
                item.setResult(DirectoryListener.this.createResult(file, (FileAttributes)attributes)).setId(file.toString());
                if (DirectoryListener.this.watermarkMode != WatermarkMode.DISABLED) {
                    item.setWatermark((Serializable)this.getWatermarkTimestamp(attributes));
                }
                item.getSourceCallbackContext().addVariable(DirectoryListener.ATTRIBUTES_CONTEXT_VAR, (Object)attributes);
            });
            return this.pollContext.isSourceStopping() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
        }

        private LocalDateTime getWatermarkTimestamp(LocalFileAttributes attributes) {
            if (DirectoryListener.this.watermarkMode == WatermarkMode.MODIFIED_TIMESTAMP) {
                return attributes.getLastModifiedTime();
            }
            if (DirectoryListener.this.watermarkMode == WatermarkMode.CREATED_TIMESTAMP) {
                return attributes.getCreationTime();
            }
            throw new IllegalArgumentException("Watermark not supported for mode " + (Object)((Object)DirectoryListener.this.watermarkMode));
        }
    }
}

