/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.vm.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extensions.vm.api.QueueDefinition;
import org.mule.extensions.vm.internal.VMConnector;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.config.QueueProfile;
import org.mule.runtime.core.api.util.concurrent.FunctionalReadWriteLock;
import org.mule.runtime.core.api.util.queue.QueueManager;

public class QueueDefinitionRepository {
    private final QueueManager queueManager;
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.readWriteLock();
    private Map<VMConnector, Map<String, QueueDefinition>> queues = new ConcurrentHashMap<VMConnector, Map<String, QueueDefinition>>();

    public QueueDefinitionRepository(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public void createQueues(VMConnector config, Collection<QueueDefinition> definitions) {
        Map configQueues = this.queues.computeIfAbsent(config, key -> new ConcurrentHashMap());
        this.lock.withWriteLock(() -> {
            HashMap<String, QueueDefinition> createdQueues = new HashMap<String, QueueDefinition>();
            for (QueueDefinition definition : definitions) {
                String queueName = definition.getQueueName();
                this.findByName(queueName).ifPresent(previous -> {
                    throw new IllegalArgumentException(String.format("<vm:config> '%s' is trying to define queue '%s' which is already defined by config '%s'", config.getName(), definition.getQueueName(), ((VMConnector)previous.getFirst()).getName()));
                });
                this.queueManager.getQueueConfiguration(definition.getQueueName()).ifPresent(queueConfig -> {
                    if (queueConfig.isPersistent() != definition.getQueueType().isPersistent()) {
                        throw new IllegalArgumentException(String.format("<vm:config> '%s' is trying to define %s queue '%s' which already exists is already configured in the Mule runtime as %s.", config.getName(), definition.getQueueType().name(), definition.getQueueName(), queueConfig.isPersistent() ? "persistent" : "transient"));
                    }
                });
                QueueProfile profile = new QueueProfile(definition.getMaxOutstandingMessages(), definition.getQueueType().isPersistent());
                profile.configureQueue(queueName, this.queueManager);
                createdQueues.put(queueName, definition);
            }
            configQueues.putAll(createdQueues);
        });
    }

    public void unregisterQueues(VMConnector config) {
        this.lock.withWriteLock(() -> this.queues.remove(config));
    }

    public Optional<Pair<VMConnector, QueueDefinition>> findByName(String name) {
        return (Optional)this.lock.withReadLock(r -> this.queues.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(name)).map(entry -> new Pair(entry.getKey(), ((Map)entry.getValue()).get(name))).findFirst());
    }
}

