/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.vm.internal;

import java.util.List;
import javax.inject.Inject;
import org.mule.extensions.vm.api.QueueDefinition;
import org.mule.extensions.vm.api.VMError;
import org.mule.extensions.vm.internal.VMConnectorQueueManager;
import org.mule.extensions.vm.internal.connection.VMConnectionProvider;
import org.mule.extensions.vm.internal.listener.VMListener;
import org.mule.extensions.vm.internal.operations.VMOperations;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

@Extension(name="VM")
@Xml(prefix="vm")
@Sources(value={VMListener.class})
@Operations(value={VMOperations.class})
@ConnectionProviders(value={VMConnectionProvider.class})
@ErrorTypes(value=VMError.class)
public class VMConnector
implements Startable,
Stoppable {
    @Inject
    private VMConnectorQueueManager queueManager;
    @RefName
    private String name;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="queues")
    private List<QueueDefinition> queueDefinitions;
    @Parameter
    @Optional(defaultValue="AUTO")
    private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;

    public void start() throws MuleException {
        if (this.queueDefinitions == null || this.queueDefinitions.isEmpty()) {
            throw new IllegalArgumentException("No queues were defined for <vm:config> " + this.name);
        }
        this.queueManager.createQueues(this, this.queueDefinitions);
    }

    public void stop() throws MuleException {
        this.queueManager.unregisterQueues(this);
    }

    public String getName() {
        return this.name;
    }

    public List<QueueDefinition> getQueueDefinitions() {
        return this.queueDefinitions;
    }
}

